/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.BitSet;
import javax.jdo.JDODataStoreException;
import org.jpox.StateManager;
import org.jpox.store.mapping.ArrayMapping;
import org.jpox.store.rdbms.datatype.BlobImpl;
import org.jpox.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.jpox.util.TypeConversionHelper;

public class OracleArrayMapping
extends ArrayMapping {
    public void postInsert(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
            if (value == null) {
                return;
            }
            this.validateElementsForWriting(sm, value);
            byte[] bytes = new byte[]{};
            try {
                if (this.fmd.isSerialized()) {
                    if (!(value instanceof Serializable)) {
                        throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.ObjectNotSerializable", value.getClass().getName()));
                    }
                    BlobImpl b = new BlobImpl(value);
                    bytes = b.getBytes(0L, (int)b.length());
                } else if (value instanceof boolean[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBooleanArray(value);
                } else if (value instanceof char[]) {
                    bytes = TypeConversionHelper.getByteArrayFromCharArray(value);
                } else if (value instanceof double[]) {
                    bytes = TypeConversionHelper.getByteArrayFromDoubleArray(value);
                } else if (value instanceof float[]) {
                    bytes = TypeConversionHelper.getByteArrayFromFloatArray(value);
                } else if (value instanceof int[]) {
                    bytes = TypeConversionHelper.getByteArrayFromIntArray(value);
                } else if (value instanceof long[]) {
                    bytes = TypeConversionHelper.getByteArrayFromLongArray(value);
                } else if (value instanceof short[]) {
                    bytes = TypeConversionHelper.getByteArrayFromShortArray(value);
                } else if (value instanceof Boolean[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBooleanObjectArray(value);
                } else if (value instanceof Byte[]) {
                    bytes = TypeConversionHelper.getByteArrayFromByteObjectArray(value);
                } else if (value instanceof Character[]) {
                    bytes = TypeConversionHelper.getByteArrayFromCharObjectArray(value);
                } else if (value instanceof Double[]) {
                    bytes = TypeConversionHelper.getByteArrayFromDoubleObjectArray(value);
                } else if (value instanceof Float[]) {
                    bytes = TypeConversionHelper.getByteArrayFromFloatObjectArray(value);
                } else if (value instanceof Integer[]) {
                    bytes = TypeConversionHelper.getByteArrayFromIntObjectArray(value);
                } else if (value instanceof Long[]) {
                    bytes = TypeConversionHelper.getByteArrayFromLongObjectArray(value);
                } else if (value instanceof Short[]) {
                    bytes = TypeConversionHelper.getByteArrayFromShortObjectArray(value);
                } else if (value instanceof BigDecimal[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBigDecimalArray(value);
                } else if (value instanceof BigInteger[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBigIntegerArray(value);
                } else if (value instanceof byte[]) {
                    bytes = (byte[])value;
                } else if (value instanceof BitSet) {
                    bytes = TypeConversionHelper.getByteArrayFromBooleanArray(TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)value));
                } else {
                    if (!(value instanceof Serializable)) {
                        throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.ObjectNotSerializable", value.getClass().getName()));
                    }
                    BlobImpl b = new BlobImpl(value);
                    bytes = b.getBytes(0L, (int)b.length());
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.fmd, e.getMessage()), (Throwable)e);
            }
            catch (IOException e1) {
                // empty catch block
            }
            OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDataStoreMapping(0), bytes);
        } else {
            super.postInsert(sm);
        }
    }

    public void postUpdate(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            this.postInsert(sm);
        } else {
            super.postUpdate(sm);
        }
    }
}

