/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import org.jpox.ClassNameConstants;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class NumericRDBMSMapping
extends ColumnMapping {
    private static final int INT_MAX_DECIMAL_DIGITS = 10;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;

    protected NumericRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public NumericRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                NumericRDBMSMapping.applyValidValuesToColumn(this.column, validValues);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                if (this.column.getColumnMetaData().getLength() == null) {
                    this.column.getColumnMetaData().setLength(10);
                }
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                this.column.getColumnMetaData().setLength(1);
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN (1,0)");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
                this.column.checkDecimal();
            }
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(2);
    }

    public void setChar(Object ps, int param, char value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "char", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public char getChar(Object rs, int param) {
        char value;
        try {
            value = (char)((ResultSet)rs).getInt(param);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "char", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "int", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "int", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setByte(Object ps, int param, byte value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "byte", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public byte getByte(Object rs, int param) {
        byte value;
        try {
            value = ((ResultSet)rs).getByte(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "byte", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setBoolean(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "boolean", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        try {
            value = ((ResultSet)rs).getBoolean(param);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "boolean", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setShort(Object ps, int param, short value) {
        try {
            ((PreparedStatement)ps).setShort(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "short", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public short getShort(Object rs, int param) {
        short value;
        try {
            value = ((ResultSet)rs).getShort(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "short", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "long", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "long", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Byte) {
                ((PreparedStatement)ps).setInt(param, ((Byte)value).byteValue());
            } else if (value instanceof Integer) {
                ((PreparedStatement)ps).setInt(param, (Integer)value);
            } else if (value instanceof Character) {
                String s = value.toString();
                ((PreparedStatement)ps).setInt(param, s.charAt(0));
            } else if (value instanceof String) {
                String s = (String)value;
                ((PreparedStatement)ps).setInt(param, s.charAt(0));
            } else if (value instanceof Long) {
                ((PreparedStatement)ps).setLong(param, (Long)value);
            } else if (value instanceof Short) {
                ((PreparedStatement)ps).setShort(param, (Short)value);
            } else if (value instanceof BigDecimal) {
                ((PreparedStatement)ps).setBigDecimal(param, (BigDecimal)value);
            } else if (value instanceof Boolean) {
                ((PreparedStatement)ps).setBoolean(param, (Boolean)value);
            } else {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((BigInteger)value));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Numeric", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        try {
            BigDecimal value = ((ResultSet)rs).getBigDecimal(param);
            if (value == null) {
                return null;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumericRDBMSMapping.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName())) {
                return value.toBigInteger();
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Integer == null ? (class$java$lang$Integer = NumericRDBMSMapping.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
                return new Integer(value.intValue());
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Long == null ? (class$java$lang$Long = NumericRDBMSMapping.class$("java.lang.Long")) : class$java$lang$Long).getName())) {
                return new Long(value.longValue());
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumericRDBMSMapping.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
                return new Boolean(value.intValue() == 1);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Byte == null ? (class$java$lang$Byte = NumericRDBMSMapping.class$("java.lang.Byte")) : class$java$lang$Byte).getName())) {
                return new Byte(value.byteValue());
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Short == null ? (class$java$lang$Short = NumericRDBMSMapping.class$("java.lang.Short")) : class$java$lang$Short).getName())) {
                return new Short(value.shortValue());
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Character == null ? (class$java$lang$Character = NumericRDBMSMapping.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
                return new Character((char)value.intValue());
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$String == null ? (class$java$lang$String = NumericRDBMSMapping.class$("java.lang.String")) : class$java$lang$String).getName())) {
                return new Character((char)value.intValue()).toString();
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumericRDBMSMapping.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName())) {
                return value;
            }
            return new Long(value.longValue());
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Numeric", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

