/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.UnsupportedDataTypeException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public abstract class ColumnMapping
extends RDBMSMapping {
    protected Column column;

    public ColumnMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public boolean isNullable() {
        if (this.column != null) {
            return this.column.isNullable();
        }
        return true;
    }

    public DatastoreField getDatastoreField() {
        return this.column;
    }

    public abstract TypeInfo getTypeInfo();

    protected void initTypeInfo() {
        TypeInfo typeInfo = this.getTypeInfo();
        if (typeInfo == null) {
            throw new UnsupportedDataTypeException(LOCALISER.msg("RDBMS.Mapping.NoTypeFoundForColumn", this.column));
        }
        if (this.column != null) {
            this.column.setTypeInfo(typeInfo);
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public String getInsertionInputParameter() {
        return this.column.getWrapperFunction(1);
    }

    public String getUpdateInputParameter() {
        return this.column.getWrapperFunction(2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnMapping)) {
            return false;
        }
        ColumnMapping cm = (ColumnMapping)obj;
        return this.getClass().equals(cm.getClass()) && this.storeMgr.equals(cm.storeMgr) && (this.column == null ? cm.column == null : this.column.equals(cm.column));
    }

    public int hashCode() {
        return this.storeMgr.hashCode() ^ (this.column == null ? 0 : this.column.hashCode());
    }
}

