/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import org.jpox.ClassNameConstants;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.TypeConversionHelper;

public class CharRDBMSMapping
extends ColumnMapping {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;

    protected CharRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public CharRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected void initialize() {
        if (this.column != null) {
            Object[] validValues;
            SingleFieldMapping m;
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && this.column.getColumnMetaData().getLength() == null && (m = (SingleFieldMapping)this.getJavaTypeMapping()).getDefaultLength(0) > 0) {
                this.column.getColumnMetaData().setLength(m.getDefaultLength(0));
            }
            this.column.getColumnMetaData().setJdbcType("CHAR");
            this.column.checkString();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                CharRDBMSMapping.applyValidValuesToColumn(this.column, validValues);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                this.column.getColumnMetaData().setLength(1);
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN ('Y','N')");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
            int maxlength = this.getTypeInfo().precision;
            if (this.column.getColumnMetaData().getLength() <= 0 || this.column.getColumnMetaData().getLength() > maxlength) {
                throw new JDOUserException("String max length of " + this.column.getColumnMetaData().getLength() + " is outside the acceptable range [0, " + maxlength + "] for column \"" + this.column.getIdentifier() + "\"");
            }
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(1);
    }

    public void setChar(Object ps, int param, char value) {
        try {
            ((PreparedStatement)ps).setString(param, new Character(value).toString());
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "char", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public char getChar(Object rs, int param) {
        char value;
        try {
            value = ((ResultSet)rs).getString(param).charAt(0);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "char", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else if (this.getDatabaseAdapter().isNullEqualsEmptyStrings()) {
                if (value != null && value.length() == 0) {
                    value = this.getDatabaseAdapter().getSurrogateForEmptyStrings();
                }
                ((PreparedStatement)ps).setString(param, value);
            } else {
                Integer colLength = this.column.getColumnMetaData().getLength();
                if (colLength != null && colLength < value.length()) {
                    throw new JDOFatalUserException(LOCALISER.msg("RDBMS.Mapping.DataLongerThanColumn", value, ((Object)this.column.getIdentifier()).toString(), "" + colLength));
                }
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "String", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            value = ((ResultSet)rs).getString(param);
            if (this.getDatabaseAdapter().isNullEqualsEmptyStrings() && value != null && value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                value = "";
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Manager.UnableToGetParam", "String", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setString(param, value ? "Y" : "N");
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "boolean", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block5: {
            try {
                String s = ((ResultSet)rs).getString(param);
                if (s == null) {
                    throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
                }
                if (s.equals("Y")) {
                    value = true;
                    break block5;
                }
                if (s.equals("N")) {
                    value = false;
                    break block5;
                }
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
            catch (SQLException e) {
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "boolean", "" + param, this.column, e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Boolean) {
                ((PreparedStatement)ps).setString(param, (Boolean)value != false ? "Y" : "N");
            } else if (value instanceof Time) {
                ((PreparedStatement)ps).setString(param, ((Time)value).toString());
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setString(param, ((Date)value).toString());
            } else if (value instanceof java.util.Date) {
                ((PreparedStatement)ps).setString(param, DateFormat.getInstance().format((java.util.Date)value));
            } else if (value instanceof Timestamp) {
                Calendar cal = this.storeMgr.getPMFContext().getPmfConfiguration().getCalendarForDateTimezone();
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value, cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value);
                }
            } else if (value instanceof String) {
                ((PreparedStatement)ps).setString(param, (String)value);
            } else {
                ((PreparedStatement)ps).setString(param, value.toString());
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject(Object rs, int param) {
        try {
            String s = ((ResultSet)rs).getString(param);
            if (s == null) {
                return null;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = CharRDBMSMapping.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
                if (s.equals("Y")) {
                    return Boolean.TRUE;
                }
                if (!s.equals("N")) throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
                return Boolean.FALSE;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Character == null ? (class$java$lang$Character = CharRDBMSMapping.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
                return new Character(s.charAt(0));
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
                return Time.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
                return Date.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                return DateFormat.getInstance().parse(s);
            }
            if (!this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIMESTAMP)) return s;
            Calendar cal = this.storeMgr.getPMFContext().getPmfConfiguration().getCalendarForDateTimezone();
            return TypeConversionHelper.stringToTimestamp(s, cal);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

