/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.datatype.BlobImpl;
import org.jpox.store.rdbms.mapping.AbstractLargeBinaryRDBMSMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class BlobRDBMSMapping
extends AbstractLargeBinaryRDBMSMapping {
    protected BlobRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BlobRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(mapping, storeMgr, field);
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(2004);
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (this.getDatabaseAdapter().supportsSettingBlobUsingSetString()) {
                if (value == null) {
                    if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                        ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                    } else {
                        ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                    }
                } else {
                    ((PreparedStatement)ps).setString(param, value);
                }
            } else if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setBlob(param, new BlobImpl(this.column.getDefaultValue().toString().trim()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else {
                ((PreparedStatement)ps).setBlob(param, new BlobImpl(value));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "String", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "String", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            if (this.getDatabaseAdapter().supportsSettingBlobUsingSetString()) {
                value = ((ResultSet)rs).getString(param);
            } else {
                byte[] bytes = ((ResultSet)rs).getBytes(param);
                if (bytes == null) {
                    value = null;
                } else {
                    BlobImpl blob = new BlobImpl(bytes);
                    value = (String)blob.getObject();
                }
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "String", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

