/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.key;

import javax.jdo.JDOFatalInternalException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Key;

public class Index
extends Key {
    private final boolean isUnique;
    private final String extendedIndexSettings;

    public Index(DatastoreContainerObject table, boolean isUnique, String extendedIndexSettings) {
        super(table);
        this.isUnique = isUnique;
        this.extendedIndexSettings = extendedIndexSettings;
    }

    public Index(CandidateKey ck) {
        super(ck.getDatastoreContainerObject());
        this.isUnique = true;
        this.extendedIndexSettings = null;
        this.columns.addAll(ck.getColumns());
    }

    public Index(ForeignKey fk) {
        super(fk.getDatastoreContainerObject());
        this.isUnique = false;
        this.extendedIndexSettings = null;
        this.columns.addAll(fk.getColumns());
    }

    public boolean getUnique() {
        return this.isUnique;
    }

    public void setColumn(int seq, Column col) {
        this.assertSameDatastoreObject(col);
        Index.setMinSize(this.columns, seq + 1);
        if (this.columns.get(seq) != null) {
            throw new JDOFatalInternalException("Index part #" + seq + " for " + this.table + " already set");
        }
        this.columns.set(seq, col);
    }

    public int size() {
        return this.columns.size();
    }

    public int hashCode() {
        return (this.isUnique ? 0 : 1) ^ super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Index)) {
            return false;
        }
        Index idx = (Index)obj;
        if (idx.isUnique != this.isUnique) {
            return false;
        }
        return super.equals(obj);
    }

    public String getExtendedIndexSettings() {
        return this.extendedIndexSettings;
    }

    public String toString() {
        return this.getColumnList();
    }
}

