/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.datatype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.sql.Blob;
import java.sql.SQLException;
import javax.jdo.JDOFatalUserException;
import org.jpox.util.JPOXLogger;

public class BlobImpl
implements Blob {
    private InputStream stream;
    private int length;
    private byte[] bytes;

    public BlobImpl(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        this.bytes = baos.toByteArray();
        this.stream = new ByteArrayInputStream(this.bytes);
        this.length = this.bytes.length;
    }

    public BlobImpl(byte[] bytes) {
        this.bytes = bytes;
        this.stream = new ByteArrayInputStream(bytes);
        this.length = bytes.length;
    }

    public BlobImpl(InputStream stream) {
        this.stream = stream;
        this.length = this.bytes.length;
    }

    public Object getObject() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (StreamCorruptedException e) {
            String msg = "StreamCorruptedException: object is corrupted";
            JPOXLogger.RDBMS.error(msg);
            throw new JDOFatalUserException(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "IOException: error when reading object";
            JPOXLogger.RDBMS.error(msg);
            throw new JDOFatalUserException(msg, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            String msg = "ClassNotFoundException: error when creating object";
            JPOXLogger.RDBMS.error(msg);
            throw new JDOFatalUserException(msg, (Throwable)e);
        }
    }

    public long length() throws SQLException {
        return this.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] bytesToReturn = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytesToReturn[i] = this.bytes[(int)pos + i];
        }
        return bytesToReturn;
    }

    public int setBytes(long value, byte[] bytes, int pos, int length) throws SQLException {
        return -1;
    }

    public void truncate(long value) {
    }

    public int setBytes(long value, byte[] bytes) throws SQLException {
        return -1;
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.stream;
    }

    public OutputStream setBinaryStream(long value) throws SQLException {
        return null;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("[BlobImpl.position] may not be called");
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("[BlobImpl.position] may not be called");
    }
}

