/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.MSSQLServerColumnInfo;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.typeinfo.MSSQLTypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

class MSSQLServerAdapter
extends DatabaseAdapter {
    private static final String MSSQL_RESERVED_WORDS = "ADD,ALL,ALTER,AND,ANY,AS,ASC,AUTHORIZATION,BACKUP,BEGIN,BETWEEN,BREAK,BROWSE,BULK,BY,CASCADE,CASE,CHECK,CHECKPOINT,CLOSE,CLUSTERED,COALESCE,COLLATE,COLUMN,COMMIT,COMPUTE,CONSTRAINT,CONTAINS,CONTAINSTABLE,CONTINUE,CONVERT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DBCC,DEALLOCATE,DECLARE,DEFAULT,DELETE,DENY,DESC,DISK,DISTINCT,DISTRIBUTED,DOUBLE,DROP,DUMMY,DUMP,ELSE,END,ERRLVL,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,FETCH,FILE,FILLFACTOR,FOR,FOREIGN,FREETEXT,FREETEXTTABLE,FROM,FULL,FUNCTION,GOTO,GRANT,GROUP,HAVING,HOLDLOCK,IDENTITY,IDENTITY_INSERT,IDENTITYCOL,IF,IN,INDEX,INNER,INSERT,INTERSECT,INTO,IS,JOIN,KEY,KILL,LEFT,LIKE,LINENO,LOAD,NATIONAL,NOCHECK,NONCLUSTERED,NOT,NULL,NULLIF,OF,OFF,OFFSETS,ON,OPEN,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OPTION,OR,ORDER,OUTER,OVER,PERCENT,PLAN,PRECISION,PRIMARY,PRINT,PROC,PROCEDURE,PUBLIC,RAISERROR,READ,READTEXT,RECONFIGURE,REFERENCES,REPLICATION,RESTORE,RESTRICT,RETURN,REVOKE,RIGHT,ROLLBACK,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SCHEMA,SELECT,SESSION_USER,SET,SETUSER,SHUTDOWN,SOME,STATISTICS,SYSTEM_USER,TABLE,TEXTSIZE,THEN,TO,TOP,TRAN,DATABASE,TRANSACTION,TRIGGER,TRUNCATE,TSEQUAL,UNION,UNIQUE,UPDATE,UPDATETEXT,USE,USER,VALUES,VARYING,VIEW,WAITFOR,WHEN,WHERE,WHILE,WITH,WRITETEXT";
    static /* synthetic */ Class class$java$math$BigInteger;

    public MSSQLServerAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(MSSQL_RESERVED_WORDS));
    }

    public String getVendorID() {
        return "sqlserver";
    }

    public String getCatalogName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        return catalog != null ? catalog : "";
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return null;
    }

    public String getSelectNewUUIDStmt() {
        return "SELECT NEWID()";
    }

    public String getNewUUIDFunction() {
        return "NEWID()";
    }

    public boolean supportsBooleanComparison() {
        return false;
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return action == ForeignKey.CASCADE_ACTION;
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        return action == ForeignKey.CASCADE_ACTION;
    }

    public boolean supportsQueryFetchSizeLowerThanOne() {
        return false;
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        return new MSSQLServerColumnInfo(rs);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        MSSQLTypeInfo ti = new MSSQLTypeInfo(rs);
        if (ti.typeName.toLowerCase().startsWith("tinyint")) {
            return null;
        }
        return ti;
    }

    protected void createTypeInfo(DatabaseMetaData metadata) throws SQLException {
        TypeInfo ti;
        super.createTypeInfo(metadata);
        Integer key = new Integer(-11);
        if (this.typesByTypeNumber.get(key) == null) {
            ti = new TypeInfo("UNIQUEIDENTIFIER", 1, 36, "'", "'", null, 1, false, 2, false, false, false, "UNIQUEIDENTIFIER", 0, 0, 10);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(2004)) == null) {
            ti = new TypeInfo("IMAGE", 2004, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "BLOB", 0, 0, 0);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(2005)) == null) {
            ti = new TypeInfo("TEXT", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 1, false, false, false, "TEXT", 0, 0, 0);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(8)) == null) {
            ti = new TypeInfo("float", 8, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 2);
            this.typesByTypeNumber.put(key, ti);
        }
        if (this.typesByTypeNumber.get(key = new Integer(-4)) == null) {
            ti = new TypeInfo("IMAGE", -4, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "LONGVARBINARY", 0, 0, 0);
            this.typesByTypeNumber.put(key, ti);
        }
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public NumericExpression lengthMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new NumericExpression("LEN", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MSSQLServerAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(this.lengthMethod(str).sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MSSQLServerAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression trimMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new StringExpression("RTRIM", args);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MSSQLServerAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        return new BooleanExpression(new StringExpression("CHARINDEX", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MSSQLServerAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        if (from != null) {
            args.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("CHARINDEX", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "SELECT @@IDENTITY";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public String getOperatorConcat() {
        return "+";
    }

    public String getSelectWithLockOption() {
        return "(UPDLOCK, ROWLOCK)";
    }

    public boolean getPlaceWithOptionAfterFromClause() {
        return true;
    }

    public boolean getPlaceWithOptionWithinJoinClauses() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

