/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.datastore.JDOConnection;
import javax.resource.spi.security.PasswordCredential;
import javax.sql.XADataSource;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.exceptions.TransactionActiveException;
import org.jpox.exceptions.TransactionNotActiveException;
import org.jpox.resource.ManagedConnectionImpl;
import org.jpox.store.rdbms.AbstractRDBMSTransaction;
import org.jpox.store.rdbms.JDOConnectionImpl;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.util.JPOXLogger;

public class RDBMSManagedTransaction
extends AbstractRDBMSTransaction {
    private final ManagedConnectionImpl mc;
    private final PasswordCredential credential;

    public RDBMSManagedTransaction(ManagedConnectionImpl mc, PasswordCredential credential) {
        this.mc = mc;
        this.dba = (RDBMSAdapter)mc.getStoreManager().getDatastoreAdapter();
        AbstractPersistenceManagerFactory apmf = mc.getAbstractPersistenceManagerFactory();
        this.tds = apmf.getTransactionalDataSource();
        this.useUpdateLock = apmf.getUseUpdateLock();
        this.credential = credential;
        this.setRetainValues(apmf.getRetainValues());
        this.setOptimistic(apmf.getOptimistic());
        this.setNontransactionalRead(apmf.getNontransactionalRead());
        this.setNontransactionalWrite(apmf.getNontransactionalWrite());
        this.setTransactionIsolation(apmf.getTransactionIsolation());
    }

    public PersistenceManager getPersistenceManager() {
        return this.mc.getPMHandle();
    }

    public synchronized JDOConnection getJDOConnection() {
        this.assertJDOConnectionNotInUse();
        this.isJDOConnectionInUse = true;
        return new JDOConnectionImpl(this.conn, new Runnable(){

            public void run() {
                RDBMSManagedTransaction.this.isJDOConnectionInUse = false;
            }
        });
    }

    public Connection getConnection(boolean forWriting, boolean forQuery, boolean useOpenedConnection) throws SQLException {
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug("getConnection(forWriting=" + forWriting + ", forQuery=" + forQuery + ", useOpenedConnection=" + useOpenedConnection + "): entered");
        }
        this.assertJDOConnectionNotInUse();
        if (forWriting && !this.active) {
            throw new JDOUserException(LOCALISER.msg("Transaction.NontransactionalWriteUnsupported"));
        }
        if (this.conn == null) {
            if (this.active) {
                throw new IllegalStateException("conn == null, but transaction active! When a transaction is active, the connection must already exist here!");
            }
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug("getConnection(forWriting=" + forWriting + ", forQuery=" + forQuery + ", useOpenedConnection=" + useOpenedConnection + "): conn==null => calling dba.getConnection(...)");
            }
            this.conn = this.dba.getConnection(this.tds, this.credential == null ? null : this.credential.getUserName(), this.credential == null ? null : new String(this.credential.getPassword()), this.isolationLevel);
        }
        if (this.active) {
            this.mc.flush();
        }
        return this.conn;
    }

    public synchronized void releaseConnection(Connection conn) throws SQLException {
        if (conn != null && conn == this.conn) {
            if (!this.active) {
                if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                    JPOXLogger.TRANSACTION.debug("releaseConnection(Connection): A transaction is NOT active => closing NTR connection now!");
                }
                this.closeConnection();
            } else if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug("releaseConnection(Connection): A transaction is active! Ignoring this call, because we close only connections for non-transactional reads here.");
            }
        } else if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            if (conn == null) {
                JPOXLogger.TRANSACTION.debug("releaseConnection(Connection): conn is null! Ignoring this call.");
            } else {
                JPOXLogger.TRANSACTION.debug("releaseConnection(Connection): conn != this.conn: conn=" + conn + " this.conn=" + this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws SQLException {
        if (this.conn != null) {
            try {
                if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                    JPOXLogger.TRANSACTION.debug(LOCALISER.msg(this.optimistic ? "Transaction.Optimistic.ConnectionClosed" : "Transaction.Pessimistic.ConnectionClosed", this.conn));
                }
                this.dba.closeConnection(this.conn);
            }
            finally {
                this.conn = null;
            }
        }
    }

    public synchronized void begin() {
        this.assertNotInUse();
        try {
            this.conn = this.dba.getConnection(this.tds, this.credential == null ? null : this.credential.getUserName(), this.credential == null ? null : new String(this.credential.getPassword()), this.isolationLevel);
        }
        catch (SQLException sqle) {
            throw new JDODataStoreException(LOCALISER.msg("Transaction.ConnectionUnobtainable"), (Throwable)sqle);
        }
        this.active = true;
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.StartedForConnection", this.conn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        if (!this.active) {
            throw new TransactionActiveException(this);
        }
        this.assertJDOConnectionNotInUse();
        if (this.rollbackOnly) {
            String msg = LOCALISER.msg("Transaction.CommitWithRollbackOnly");
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug(msg);
            }
            throw new JDOFatalDataStoreException(msg);
        }
        try {
            this.commiting = true;
            boolean success = false;
            try {
                try {
                    if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                        JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.CommitForConnection", this.conn));
                    }
                    if (this.sync != null) {
                        this.sync.beforeCompletion();
                    }
                    this.mc.flush();
                    this.mc.preCommit();
                    if (!(this.tds[0] instanceof XADataSource)) {
                        this.conn.commit();
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            this.mc.preRollback();
                        }
                        finally {
                            if (!(this.tds[0] instanceof XADataSource)) {
                                this.conn.rollback();
                            }
                        }
                    }
                }
            }
            finally {
                try {
                    this.active = false;
                    this.closeConnection();
                }
                finally {
                    try {
                        if (success) {
                            this.mc.postCommit();
                        }
                    }
                    finally {
                        this.commiting = false;
                        if (this.sync != null) {
                            if (success) {
                                this.sync.afterCompletion(3);
                            } else {
                                this.sync.afterCompletion(4);
                            }
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("Transaction.FailedToCommit"), (Throwable[])new Exception[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() {
        if (!this.active) {
            throw new TransactionNotActiveException();
        }
        this.assertJDOConnectionNotInUse();
        try {
            this.commiting = true;
            try {
                try {
                    if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                        JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.RollbackForConnection", this.conn));
                    }
                    this.mc.preRollback();
                }
                finally {
                    if (!(this.tds[0] instanceof XADataSource)) {
                        this.conn.rollback();
                    }
                }
            }
            finally {
                try {
                    this.active = false;
                    this.closeConnection();
                }
                finally {
                    this.commiting = false;
                    if (this.sync != null) {
                        this.sync.afterCompletion(4);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("Transaction.FailedToRollback"), (Throwable[])new Exception[]{e});
        }
        this.rollbackOnly = false;
    }

    protected void assertNotInUse() {
        if (this.active) {
            throw new TransactionActiveException(this);
        }
    }
}

