/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import org.jpox.exceptions.TransactionCommiting;
import org.jpox.store.rdbms.RDBMSTransaction;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.util.Localiser;

public abstract class AbstractRDBMSTransaction
implements RDBMSTransaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected RDBMSAdapter dba;
    protected DataSource[] tds;
    protected boolean active = false;
    protected boolean commiting = false;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected Synchronization sync = null;
    protected boolean rollbackOnly = false;
    protected int isolationLevel;
    protected boolean useUpdateLock;
    protected boolean isJDOConnectionInUse = false;
    protected Connection conn = null;

    public synchronized boolean isConnectionOpen() {
        return this.conn != null;
    }

    public synchronized Connection getConnection(boolean forWriting, boolean forQuery) throws SQLException {
        return this.getConnection(forWriting, forQuery, false);
    }

    public abstract Connection getConnection(boolean var1, boolean var2, boolean var3) throws SQLException;

    public abstract void releaseConnection(Connection var1) throws SQLException;

    public synchronized void setRetainValues(boolean retainValues) {
        this.assertNotCommiting();
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public synchronized void setRestoreValues(boolean restoreValues) {
        this.assertNotInUse();
        this.assertNotCommiting();
        this.restoreValues = restoreValues;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public synchronized void setOptimistic(boolean optimistic) {
        this.assertNotInUse();
        this.assertNotCommiting();
        this.optimistic = optimistic;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public synchronized void setNontransactionalRead(boolean nontransactionalRead) {
        this.assertNotCommiting();
        this.nontransactionalRead = nontransactionalRead;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.assertNotInUse();
        this.assertNotCommiting();
        if (nontransactionalWrite) {
            throw new JDOUnsupportedOptionException("Non-transactional write mode not (yet) supported");
        }
        this.nontransactionalWrite = nontransactionalWrite;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public synchronized void setSynchronization(Synchronization sync) {
        this.assertNotCommiting();
        this.sync = sync;
    }

    public Synchronization getSynchronization() {
        return this.sync;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    public void setTransactionIsolation(int isolationLevel) {
        this.assertNotInUse();
        this.assertNotCommiting();
        switch (isolationLevel) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(LOCALISER.msg("Transaction.IsolationLevelInvalid", isolationLevel));
            }
        }
        this.isolationLevel = isolationLevel;
    }

    public boolean useUpdateLockOnFetch() {
        if (!this.active || this.optimistic) {
            return false;
        }
        if (this.isolationLevel == 4 || this.isolationLevel == 8) {
            return false;
        }
        return this.useUpdateLock;
    }

    public void setUseUpdateLock(boolean lock) {
        this.assertNotInUse();
        this.assertNotCommiting();
        this.useUpdateLock = lock;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCommitting() {
        return this.commiting;
    }

    protected abstract void assertNotInUse();

    protected void assertNotCommiting() {
        if (this.commiting) {
            throw new TransactionCommiting(this);
        }
    }

    protected void assertJDOConnectionNotInUse() {
        if (this.isJDOConnectionInUse) {
            throw new JDOUserException("The JDOConnection was acquired by the developer and must be closed before using the JDO API.");
        }
    }
}

