/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.poid;

import java.util.Properties;
import javax.jdo.JDODataStoreException;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.poid.PoidGenerator;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class AbstractPoidGenerator
implements PoidGenerator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected String name;
    protected Properties properties;
    protected int allocationSize = 5;
    protected int initialValue = 0;
    protected PoidBlock poidBlock;

    public AbstractPoidGenerator(String name, Properties props) {
        this.name = name;
        this.properties = props;
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object next() {
        if (this.poidBlock == null || !this.poidBlock.hasNext()) {
            this.poidBlock = this.obtainPoidBlock();
        }
        return this.poidBlock.next().getOid();
    }

    public synchronized Object current() {
        if (this.poidBlock == null) {
            return null;
        }
        return this.poidBlock.current().getOid();
    }

    public long nextValue() {
        return this.getLongValueForObject(this.next());
    }

    public long currentValue() {
        return this.getLongValueForObject(this.current());
    }

    private long getLongValueForObject(Object oid) {
        if (oid instanceof Long) {
            return (Long)oid;
        }
        if (oid instanceof Integer) {
            return ((Integer)oid).longValue();
        }
        if (oid instanceof Short) {
            return ((Short)oid).longValue();
        }
        throw new JDODataStoreException(LOCALISER.msg("PoidGenerator.NotNumericError", this.name));
    }

    public synchronized void allocate(int additional) {
        if (this.poidBlock == null) {
            this.poidBlock = this.obtainPoidBlock(additional);
        } else {
            this.poidBlock.addBlock(this.obtainPoidBlock(additional));
        }
    }

    protected PoidBlock obtainPoidBlock() {
        return this.obtainPoidBlock(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoidBlock obtainPoidBlock(int number) {
        boolean repository_exists;
        PoidBlock block;
        block11: {
            block = null;
            repository_exists = true;
            try {
                block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
            }
            catch (PoidException poidex) {
                JPOXLogger.POID.info(LOCALISER.msg("PoidGenerator.BlockAllocationError", poidex.getMessage()));
                if (this.requiresRepository()) {
                    repository_exists = false;
                    break block11;
                }
                throw poidex;
            }
            catch (RuntimeException ex) {
                JPOXLogger.POID.info(LOCALISER.msg("PoidGenerator.BlockAllocationError", ex.getMessage()));
                if (this.requiresRepository()) {
                    repository_exists = false;
                    break block11;
                }
                throw ex;
            }
        }
        if (!repository_exists) {
            JPOXLogger.POID.info(LOCALISER.msg("PoidGenerator.CreatingRepository"));
            if (!this.createRepository()) {
                throw new PoidException(LOCALISER.msg("PoidGenerator.RepositoryOfIdsInvalid"));
            }
            block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
        }
        return block;
    }

    protected PoidBlock reserveBlock() {
        return this.reserveBlock(this.allocationSize);
    }

    protected abstract PoidBlock reserveBlock(long var1);

    protected boolean requiresRepository() {
        return false;
    }

    protected boolean createRepository() {
        return true;
    }
}

