/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AppIDObjectIdFieldConsumer;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.mapping.OIDMapping;
import org.jpox.store.rdbms.fieldmanager.ResultSetGetter;
import org.jpox.store.rdbms.table.CorrespondentColumnsMapping;
import org.jpox.store.rdbms.table.ElementContainerTable;
import org.jpox.util.AIDUtils;
import org.jpox.util.JPOXLogger;

public class PersistenceCapableMapping
extends OIDMapping {
    private JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    private AbstractClassMetaData cmd;
    private boolean representsIdentity = false;
    private int numberOfDatastoreFields = 0;
    static /* synthetic */ Class class$javax$jdo$identity$LongIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$IntIdentity;
    static /* synthetic */ Class class$javax$jdo$identity$ShortIdentity;

    public PersistenceCapableMapping() {
    }

    protected PersistenceCapableMapping(PersistenceCapableMapping pcMapping) {
        this.initialize(pcMapping.dba, pcMapping.type);
        this.datastoreContainer = pcMapping.datastoreContainer;
        this.javaTypeMappings = new JavaTypeMapping[pcMapping.javaTypeMappings.length];
        System.arraycopy(pcMapping.javaTypeMappings, 0, this.javaTypeMappings, 0, this.javaTypeMappings.length);
        this.representsIdentity = true;
    }

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    public JavaTypeMapping getIdMapping() {
        return new PersistenceCapableMapping(this);
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (mapping == null) {
            throw new JDOFatalInternalException("mapping argument in PersistenceCapableMapping.addJavaTypeMapping is null");
        }
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    protected void prepareDatastoreMapping() {
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        StoreManager storeMgr = this.datastoreContainer.getStoreManager();
        AbstractClassMetaData refCmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.fmd.getType(), clr);
        JavaTypeMapping referenceMapping = null;
        if (refCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
            if (cmds != null && cmds.length > 0) {
                if (cmds.length > 1) {
                    JPOXLogger.JDO.warn("Field " + this.fmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation " + "where the other end uses \"subclass-table\" inheritance strategy and more than 1 subclasses with a table. " + "This is not fully supported by JPOX");
                }
            } else {
                return;
            }
            referenceMapping = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIDMapping();
        } else {
            referenceMapping = storeMgr.getDatastoreClass(this.fmd.getType().getName(), clr).getIDMapping();
        }
        CorrespondentColumnsMapping correspondentColumnsMapping = new CorrespondentColumnsMapping(this.fmd, referenceMapping, true);
        int relationType = this.fmd.getRelationType(clr);
        boolean createDatastoreMappings = true;
        if (relationType == 6) {
            AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
            createDatastoreMappings = relatedFmd.getJoinMetaData() == null;
        } else if (relationType == 2) {
            createDatastoreMappings = this.fmd.getMappedBy() == null;
        }
        for (int i = 0; i < referenceMapping.getNumberOfDatastoreFields(); ++i) {
            DatastoreMapping refDatastoreMapping = referenceMapping.getDataStoreMapping(i);
            JavaTypeMapping mapping = this.dba.getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType(), storeMgr);
            this.addJavaTypeMapping(mapping);
            if (createDatastoreMappings) {
                ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                if (colmd == null) {
                    throw new JDOFatalUserException(LOCALISER.msg("PersistenceCapableMapping.PrimaryKeyColumnNotMapped", refDatastoreMapping.getDatastoreField().getIdentifier(), this.toString()));
                }
                MappingManager mmgr = this.datastoreContainer.getStoreManager().getMappingManager();
                DatastoreField col = mmgr.createDatastoreField(this.fmd, this.datastoreContainer, this.dba, mapping, colmd, refDatastoreMapping.getDatastoreField(), clr);
                DatastoreMapping datastoreMapping = mmgr.createDatastoreMapping(mapping, storeMgr, col, refDatastoreMapping.getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                this.addDataStoreMapping(datastoreMapping);
                continue;
            }
            mapping.setReferenceMapping(referenceMapping);
        }
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreFields() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreFields();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreFields();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDataStoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new JDOFatalInternalException("Invalid index " + index + " for DataStoreMapping.");
    }

    public void setObject(PersistenceManager pm, Object ps, int[] param, Object value) {
        this.setObject(pm, ps, param, value, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(PersistenceManager pm, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        if (value == null) {
            int n = 0;
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                JavaTypeMapping mapping = this.javaTypeMappings[i];
                if (mapping.getNumberOfDatastoreFields() <= 0) continue;
                int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                mapping.setObject(pm, ps, posMapping, null);
            }
            return;
        } else {
            if (!(value instanceof PersistenceCapable)) {
                throw new JDOFatalInternalException(LOCALISER.msg("Mapping.ObjectIsNotPersistenceCapable", value.getClass(), value));
            }
            StateManager sm = null;
            if (value != null) {
                sm = pm.findStateManager((PersistenceCapable)value);
            }
            try {
                AbstractClassMetaData acmd;
                PersistenceCapable pc = (PersistenceCapable)value;
                boolean isStrategyDatastoreAttributed = false;
                if (this.fmd != null && (acmd = pm.getMetaDataManager().getMetaDataForClass(this.fmd.getType(), pm.getClassLoaderResolver())).getIdentityType() == IdentityType.APPLICATION) {
                    for (int i = 0; i < acmd.getPrimaryKeyFieldNumbers().length; ++i) {
                        IdentityStrategy strategy = acmd.getManagedFieldAbsolute(acmd.getPrimaryKeyFieldNumbers()[i]).getValueStrategy();
                        if (strategy == null) continue;
                        isStrategyDatastoreAttributed |= pm.getStoreManager().isStrategyDatastoreAttributed(strategy);
                    }
                }
                boolean inserted = false;
                if (ownerFieldNumber >= 0) {
                    inserted = pm.isInserted(pc, ownerFieldNumber);
                }
                if (sm != null && sm.getAttachedPC() != null && ownerSM != null) {
                    ownerSM.replaceField(ownerFieldNumber, sm.getAttachedPC());
                }
                if (!pm.isInserting(pc) || inserted || !isStrategyDatastoreAttributed && this.fmd != null && this.fmd.isPrimaryKey()) {
                    Object id = pc.jdoGetObjectId();
                    boolean requiresPersisting = false;
                    if (pc.jdoIsDetached() && ownerSM != null) {
                        requiresPersisting = true;
                    } else if (id == null) {
                        requiresPersisting = true;
                    } else if ((PersistenceManager)pc.jdoGetPersistenceManager() != null && pm.getPMHandle() != ((PersistenceManager)pc.jdoGetPersistenceManager()).getPMHandle()) {
                        throw new JDOUserException(LOCALISER.msg("Mapping.FieldNotAssignableIsFromAnotherPM"), id);
                    }
                    if (requiresPersisting) {
                        PersistenceCapable pcNew = (PersistenceCapable)pm.makePersistentInternal(value, null);
                        if (isStrategyDatastoreAttributed) {
                            pm.flush();
                        }
                        id = pcNew.jdoGetObjectId();
                        if (pc.jdoIsDetached() && ownerSM != null) {
                            ownerSM.replaceField(ownerFieldNumber, pcNew);
                            ClassLoaderResolver clr = pm.getClassLoaderResolver();
                            int relationType = this.fmd.getRelationType(clr);
                            if (relationType == 6) {
                                if (JPOXLogger.JDO.isInfoEnabled()) {
                                    JPOXLogger.JDO.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional." + " Have just attached the N side so should really update the reference in the 1 side collection" + " to refer to this attached object. Not yet implemented");
                                }
                            } else if (relationType == 2) {
                                AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
                                StateManager relatedSM = pm.findStateManager(pcNew);
                                relatedSM.replaceField(relatedFmd.getAbsoluteFieldNumber(), ownerSM.getObject());
                            }
                        }
                    }
                    if (sm != null) {
                        sm.setStoringPC();
                    }
                    if (this.getNumberOfDatastoreFields() <= 0) return;
                    if (id instanceof OID) {
                        super.setObject(pm, ps, param, id);
                        return;
                    }
                    pc.jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)new AppIDObjectIdFieldConsumer(param, pm, ps, this.javaTypeMappings), id);
                    return;
                }
                if (sm != null) {
                    sm.setStoringPC();
                }
                if (this.getNumberOfDatastoreFields() <= 0) return;
                int n = 0;
                for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                    JavaTypeMapping mapping = this.javaTypeMappings[i];
                    if (mapping.getNumberOfDatastoreFields() <= 0) continue;
                    int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
                    for (int j = 0; j < posMapping.length; ++j) {
                        posMapping[j] = param[n++];
                    }
                    mapping.setObject(pm, ps, posMapping, null);
                }
                throw new NotYetFlushedException(pc);
            }
            finally {
                if (sm != null) {
                    sm.unsetStoringPC();
                }
            }
        }
    }

    public Object getObject(PersistenceManager pm, Object rs, int[] param) {
        try {
            if (((ResultSet)rs).getObject(param[0]) == null) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(e.toString());
        }
        if (this.cmd == null) {
            this.cmd = pm.getMetaDataManager().getMetaDataForClass(this.getType(), pm.getClassLoaderResolver());
        }
        if (this.representsIdentity) {
            if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                OID oid = (OID)super.getObject(pm, rs, param);
                String className = pm.getStoreManager().getClassNameForObjectID(oid, pm.getClassLoaderResolver(), pm);
                if (!oid.getPcClass().equals(className)) {
                    return OIDFactory.getInstance(className, oid.keyValue());
                }
                return oid;
            }
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                ClassLoaderResolver clr = pm.getClassLoaderResolver();
                Class objectIdClass = clr.classForName(this.cmd.getObjectidClass());
                Class pcClass = clr.classForName(this.cmd.getFullClassName());
                Object id = this.cmd.usesSingleFieldIdentityClass() ? this.createSingleFieldIdentity(pm, rs, param, this.cmd, objectIdClass, pcClass) : this.createObjectIdInstanceReflection(pm, rs, param, this.cmd, objectIdClass);
                return id;
            }
            return null;
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.getObjectForDatastoreIdentity(pm, rs, param, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getObjectForApplicationIdentity(pm, rs, param, this.cmd);
        }
        return null;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.getNumberOfDatastoreFields() > 0) {
            return new ObjectExpression(qs, this, te);
        }
        ClassLoaderResolver clr = qs.getClassLoaderResolver();
        int relationType = this.fmd.getRelationType(clr);
        if (relationType == 2) {
            DatastoreClass targetTable = qs.getStoreManager().getDatastoreClass(this.fmd.getTypeName(), clr);
            JavaTypeMapping refMapping = targetTable.getFieldMapping(this.fmd.getRelatedFieldMetaData(clr));
            JavaTypeMapping selectMapping = targetTable.getIDMapping();
            DatastoreIdentifier targetTableIdentifier = qs.getStoreManager().getIdentifierFactory().newIdentifier(0, "RELATED" + this.fmd.getAbsoluteFieldNumber());
            LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
            return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
        }
        if (relationType == 6) {
            AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
            if (this.fmd.getJoinMetaData() != null || relatedFmd.getJoinMetaData() != null) {
                DatastoreContainerObject targetTable = qs.getStoreManager().getDatastoreContainerObject(relatedFmd);
                JavaTypeMapping refMapping = null;
                JavaTypeMapping selectMapping = null;
                ElementContainerTable elementTable = (ElementContainerTable)targetTable;
                refMapping = elementTable.getElementMapping();
                selectMapping = elementTable.getOwnerMapping();
                DatastoreIdentifier targetTableIdentifier = qs.getStoreManager().getIdentifierFactory().newIdentifier(0, "JOINTABLE" + this.fmd.getAbsoluteFieldNumber());
                LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
                return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
            }
        }
        return null;
    }

    public void deleteDependent(StateManager sm) {
        PersistenceCapable pc;
        int fieldNumber = this.fmd.getAbsoluteFieldNumber();
        sm.isLoaded(sm.getObject(), fieldNumber);
        ClassLoaderResolver clr = sm.getPersistenceManager().getClassLoaderResolver();
        AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
        boolean hasFK = false;
        if (this.fmd.getForeignKeyMetaData() != null) {
            hasFK = true;
        }
        if (relatedFmd != null && relatedFmd.getForeignKeyMetaData() != null) {
            hasFK = true;
        }
        if (sm.getPersistenceManager().getPMFContext().getPmfConfiguration().getDeletionPolicy().equals("JDO2")) {
            hasFK = false;
        }
        if ((pc = (PersistenceCapable)sm.provideField(fieldNumber)) != null) {
            if (!hasFK || this.fmd.getRelationType(clr) == 6) {
                boolean isNullable = this.isNullable();
                if (this.getNumberOfDatastoreFields() == 0 && relatedFmd != null) {
                    DatastoreClass relatedTable = sm.getStoreManager().getDatastoreClass(relatedFmd.getClassName(), sm.getPersistenceManager().getClassLoaderResolver());
                    JavaTypeMapping relatedMapping = relatedTable.getFieldMapping(relatedFmd);
                    isNullable = relatedMapping.isNullable();
                }
                if (isNullable) {
                    sm.replaceField(fieldNumber, null);
                    sm.makeDirty(fieldNumber);
                }
            }
            sm.getPersistenceManager().deletePersistent(pc);
        }
    }

    private Object getObjectForDatastoreIdentity(PersistenceManager pm, Object rs, int[] param, AbstractClassMetaData cmd) {
        Object oid = super.getObject(pm, rs, param);
        if (oid instanceof PersistenceCapable) {
            return oid;
        }
        return oid == null ? null : pm.getObjectById(oid, false, true, null);
    }

    private Object createSingleFieldIdentity(PersistenceManager pm, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass, Class pcClass) {
        int paramNumber = param[0];
        try {
            Object idObj = ((ResultSet)rs).getObject(paramNumber);
            if (idObj == null) {
                throw new JDOFatalInternalException(LOCALISER.msg("PersistenceCapableMapping.CantCreateSingleFieldIdentityWithNull"));
            }
            idObj = this.convertIfNecessary(objectIdClass, idObj);
            return AIDUtils.getNewSingleFieldIdentity(objectIdClass, pcClass, idObj);
        }
        catch (Exception e) {
            JPOXLogger.JDO.error(LOCALISER.msg("PersistenceCapableMapping.CantCreateAID", cmd.getObjectidClass(), e));
            return null;
        }
    }

    private Object convertIfNecessary(Class objectIdClass, Object idObj) {
        if (idObj instanceof BigInteger && (class$javax$jdo$identity$LongIdentity == null ? (class$javax$jdo$identity$LongIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.LongIdentity")) : class$javax$jdo$identity$LongIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Long(((BigInteger)idObj).longValue());
        } else if (idObj instanceof BigInteger && (class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Long(((BigInteger)idObj).intValue());
        } else if (idObj instanceof BigDecimal && (class$javax$jdo$identity$LongIdentity == null ? (class$javax$jdo$identity$LongIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.LongIdentity")) : class$javax$jdo$identity$LongIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Long(((BigDecimal)idObj).longValue());
        } else if (idObj instanceof BigDecimal && (class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Integer(((BigDecimal)idObj).intValue());
        } else if (idObj instanceof Long && (class$javax$jdo$identity$IntIdentity == null ? (class$javax$jdo$identity$IntIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.IntIdentity")) : class$javax$jdo$identity$IntIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Integer(((Long)idObj).intValue());
        } else if (idObj instanceof Long && (class$javax$jdo$identity$ShortIdentity == null ? (class$javax$jdo$identity$ShortIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.ShortIdentity")) : class$javax$jdo$identity$ShortIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Short(((Long)idObj).shortValue());
        } else if (idObj instanceof Integer && (class$javax$jdo$identity$ShortIdentity == null ? (class$javax$jdo$identity$ShortIdentity = PersistenceCapableMapping.class$("javax.jdo.identity.ShortIdentity")) : class$javax$jdo$identity$ShortIdentity).isAssignableFrom(objectIdClass)) {
            idObj = new Short(((Integer)idObj).shortValue());
        }
        return idObj;
    }

    private Object createObjectIdInstanceReflection(PersistenceManager pm, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass) {
        Object fieldValue = null;
        try {
            Object id = objectIdClass.newInstance();
            int paramIndex = 0;
            for (int i = 0; i < cmd.getPrimaryKeyFieldNumbers().length; ++i) {
                AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(cmd.getPrimaryKeyFieldNumbers()[i]);
                Field field = objectIdClass.getField(fmd.getName());
                JavaTypeMapping m = pm.getStoreManager().getDatastoreClass(cmd.getFullClassName(), pm.getClassLoaderResolver()).getFieldMapping(fmd);
                for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                    Object obj;
                    if ((obj = ((ResultSet)rs).getObject(param[paramIndex++])) instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)obj;
                        obj = this.convertIfNecessary(field.getType(), bigDecimal);
                        if (!bigDecimal.subtract(new BigDecimal("" + obj)).equals(new BigDecimal("0"))) {
                            throw new JDOFatalInternalException("Cannot convert retrieved BigInteger value to field of object id class!");
                        }
                    }
                    fieldValue = obj;
                }
                field.set(id, fieldValue);
            }
            return id;
        }
        catch (Exception e) {
            JPOXLogger.JDO.error(LOCALISER.msg("PersistenceCapableMapping.CantCreateAIDWithReflection", cmd.getObjectidClass(), this.fmd == null ? null : this.fmd.getName(), fieldValue, e));
            return null;
        }
    }

    private Object getObjectForAbstractClass(PersistenceManager pm, Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = pm.getClassLoaderResolver();
        Class objectIdClass = clr.classForName(cmd.getObjectidClass());
        Class pcClass = clr.classForName(cmd.getFullClassName());
        Object id = cmd.usesSingleFieldIdentityClass() ? this.createSingleFieldIdentity(pm, rs, param, cmd, objectIdClass, pcClass) : this.createObjectIdInstanceReflection(pm, rs, param, cmd, objectIdClass);
        return pm.getObjectById(id, false, true, null);
    }

    private Object getObjectForApplicationIdentity(PersistenceManager pm, final Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = pm.getClassLoaderResolver();
        if (((ClassMetaData)cmd).isAbstractPersistenceCapable() && cmd.getObjectidClass() != null) {
            return this.getObjectForAbstractClass(pm, rs, param, cmd);
        }
        int totalFieldCount = cmd.getNoOfManagedFields() + cmd.getNoOfInheritedManagedFields();
        final StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[totalFieldCount];
        int paramIndex = 0;
        DatastoreClass datastoreClass = pm.getStoreManager().getDatastoreClass(cmd.getFullClassName(), clr);
        final int[] pkFieldNumbers = cmd.getPrimaryKeyFieldNumbers();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(pkFieldNumbers[i]);
            JavaTypeMapping m = datastoreClass.getFieldMapping(fmd);
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
            int[] expressionsIndex = new int[m.getNumberOfDatastoreFields()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = param[paramIndex++];
            }
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setExpressionIndex(expressionsIndex);
        }
        return pm.getObjectByAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(pkFieldNumbers, new ResultSetGetter(sm, (ResultSet)rs, statementExpressionIndex));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(pkFieldNumbers, new ResultSetGetter(sm, (ResultSet)rs, statementExpressionIndex));
            }

            public FetchPlanImpl getFetchPlanForLoading() {
                return null;
            }
        }, false, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

