/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.util.Localiser;

public abstract class JavaTypeMapping {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected AbstractPropertyMetaData fmd;
    protected DatastoreMapping[] datastoreMappings = new DatastoreMapping[0];
    protected DatastoreContainerObject datastoreContainer;
    protected DatastoreAdapter dba;
    protected String type;
    protected JavaTypeMapping referenceMapping;

    protected JavaTypeMapping() {
    }

    protected JavaTypeMapping(DatastoreAdapter dba, String type, AbstractPropertyMetaData fmd, DatastoreContainerObject container) {
        this.dba = dba;
        this.type = type;
        this.fmd = fmd;
        this.datastoreContainer = container;
    }

    public void initialize(DatastoreAdapter dba, String type) {
        this.dba = dba;
        this.type = type;
    }

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        this.dba = dba;
        this.fmd = fmd;
        this.type = fmd.getType().getName();
        this.datastoreContainer = container;
    }

    public boolean isNullable() {
        for (int i = 0; i < this.datastoreMappings.length; ++i) {
            if (this.datastoreMappings[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    public DatastoreMapping[] getDataStoreMappings() {
        return this.datastoreMappings;
    }

    public DatastoreContainerObject getDatastoreContainer() {
        return this.datastoreContainer;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        return this.datastoreMappings[index];
    }

    public JavaTypeMapping getReferenceMapping() {
        return this.referenceMapping;
    }

    public void setReferenceMapping(JavaTypeMapping referenceMapping) {
        this.referenceMapping = referenceMapping;
    }

    public void addDataStoreMapping(DatastoreMapping datastoreMapping) {
        DatastoreMapping[] dm = this.datastoreMappings;
        this.datastoreMappings = new DatastoreMapping[this.datastoreMappings.length + 1];
        System.arraycopy(dm, 0, this.datastoreMappings, 0, dm.length);
        this.datastoreMappings[dm.length] = datastoreMapping;
    }

    public int getNumberOfDatastoreFields() {
        return this.datastoreMappings.length;
    }

    public AbstractPropertyMetaData getFieldMetaData() {
        return this.fmd;
    }

    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        throw new UnsupportedOperationException("Datastore type mapping is not supported by: " + this.getClass());
    }

    public String getType() {
        return this.type;
    }

    public abstract Object getSampleValue(ClassLoaderResolver var1);

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    public abstract ScalarExpression newLiteral(QueryExpression var1, Object var2);

    public abstract ScalarExpression newScalarExpression(QueryExpression var1, LogicSetExpression var2);

    protected String failureMessage(String method) {
        return LOCALISER.msg("Mapping.FailureMessage", this.getClass().getName(), method);
    }

    public void setDefault(PersistenceManager pm, Object datastoreStatement, int[] exprIndex) {
        this.getDataStoreMapping(0).setObject(datastoreStatement, exprIndex[0], this.isNullable() ? null : this.getSampleValue(pm.getClassLoaderResolver()));
    }

    public void setBoolean(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, boolean value) {
        throw new JDOFatalInternalException(this.failureMessage("setBoolean"));
    }

    public boolean getBoolean(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("setBoolean"));
    }

    public void setChar(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, char value) {
        throw new JDOFatalInternalException(this.failureMessage("setChar"));
    }

    public char getChar(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getChar"));
    }

    public void setByte(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, byte value) {
        throw new JDOFatalInternalException(this.failureMessage("setByte"));
    }

    public byte getByte(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getByte"));
    }

    public void setShort(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, short value) {
        throw new JDOFatalInternalException(this.failureMessage("setShort"));
    }

    public short getShort(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getShort"));
    }

    public void setInt(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, int value) {
        throw new JDOFatalInternalException(this.failureMessage("setInt"));
    }

    public int getInt(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getInt"));
    }

    public void setLong(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, long value) {
        throw new JDOFatalInternalException(this.failureMessage("setLong"));
    }

    public long getLong(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getLong"));
    }

    public void setFloat(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, float value) {
        throw new JDOFatalInternalException(this.failureMessage("setFloat"));
    }

    public float getFloat(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getFloat"));
    }

    public void setDouble(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, double value) {
        throw new JDOFatalInternalException(this.failureMessage("setDouble"));
    }

    public double getDouble(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getDouble"));
    }

    public void setString(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, String value) {
        throw new JDOFatalInternalException(this.failureMessage("setString"));
    }

    public String getString(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getString"));
    }

    public void setObject(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, Object value, StateManager ownerSM, int ownerFieldNumber) {
        throw new JDOFatalInternalException(this.failureMessage("setObject"));
    }

    public void setObject(PersistenceManager pm, Object datastoreStatement, int[] exprIndex, Object value) {
        throw new JDOFatalInternalException(this.failureMessage("setObject"));
    }

    public Object getObject(PersistenceManager pm, Object datastoreResults, int[] exprIndex, StateManager ownerSM, int ownerFieldNumber) {
        throw new JDOFatalInternalException(this.failureMessage("getObject"));
    }

    public Object getObject(PersistenceManager pm, Object datastoreResults, int[] exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getObject"));
    }
}

