/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.EmbeddedMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.BigIntegerMapping;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.EmbeddedPCMapping;
import org.jpox.store.mapping.IntegerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.LongMapping;
import org.jpox.store.mapping.ShortMapping;
import org.jpox.store.mapping.SimpleDatastoreRepresentation;
import org.jpox.store.mapping.SingleFieldMapping;

public abstract class EmbeddedMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    protected List javaTypeMappings;
    protected ClassLoaderResolver clr;
    protected EmbeddedMetaData emd;
    protected String typeName;
    protected int objectType = -1;

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        throw new JDOFatalInternalException("subclass must override this method");
    }

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject datastoreContainer, ClassLoaderResolver clr, EmbeddedMetaData emd, String typeName, int objectType) {
        super.initialize(dba, fmd, datastoreContainer, clr);
        this.clr = clr;
        this.emd = emd;
        this.typeName = typeName;
        this.objectType = objectType;
        AbstractClassMetaData pcCmd = fmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClass(typeName, clr);
        if (pcCmd == null) {
            pcCmd = fmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForInterface(clr.classForName(typeName), clr);
        }
        AbstractPropertyMetaData[] embFmds = emd == null && pcCmd.isEmbeddedOnly() ? pcCmd.getManagedFields() : emd.getFieldMetaData();
        int[] pcFieldNumbers = pcCmd.getAllFieldNumbers();
        for (int i = 0; i < pcFieldNumbers.length; ++i) {
            AbstractPropertyMetaData pcFmd = pcCmd.getManagedFieldAbsolute(pcFieldNumbers[i]);
            if (pcFmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || emd != null && emd.getOwnerField() != null && emd.getOwnerField().equals(pcFmd.getName())) continue;
            AbstractPropertyMetaData embeddedFmd = null;
            for (int j = 0; j < embFmds.length; ++j) {
                if (embFmds[j] == null) {
                    throw new RuntimeException("embFmds[j] is null" + pcCmd.toString() + " type " + typeName);
                }
                if (pcCmd.getField(embFmds[j].getName()) == null) {
                    throw new RuntimeException("pcCmd.getField(embFmds[j].getName()) is null" + pcCmd.toString() + " type " + typeName + " embFmds[j].getName() " + embFmds[j].getName());
                }
                if (pcCmd.getField(embFmds[j].getName()).getAbsoluteFieldNumber() != pcFieldNumbers[i]) continue;
                embeddedFmd = embFmds[j];
                break;
            }
            JavaTypeMapping embFmdMapping = embeddedFmd != null ? dba.getMappingManager().getMapping(datastoreContainer, embeddedFmd, dba, clr, 0) : dba.getMappingManager().getMapping(datastoreContainer, pcFmd, dba, clr, 0);
            this.addJavaTypeMapping(embFmdMapping);
            for (int j = 0; j < embFmdMapping.getNumberOfDatastoreFields(); ++j) {
                DatastoreMapping datastoreMapping = embFmdMapping.getDataStoreMapping(j);
                this.addDataStoreMapping(datastoreMapping);
            }
        }
    }

    protected void prepareDatastoreMapping() {
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (this.javaTypeMappings == null) {
            this.javaTypeMappings = new ArrayList();
        }
        if (mapping == null) {
            throw new JDOFatalInternalException("mapping argument in EmbeddedMapping.addJavaTypeMapping is null");
        }
        this.javaTypeMappings.add(mapping);
    }

    public int getNumberOfJavaTypeMappings() {
        return this.javaTypeMappings != null ? this.javaTypeMappings.size() : 0;
    }

    public JavaTypeMapping getJavaTypeMapping(int i) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        return (JavaTypeMapping)this.javaTypeMappings.get(i);
    }

    public JavaTypeMapping getJavaTypeMapping(String fieldName) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        Iterator iter = this.javaTypeMappings.iterator();
        while (iter.hasNext()) {
            JavaTypeMapping m = (JavaTypeMapping)iter.next();
            if (!m.getFieldMetaData().getName().equals(fieldName)) continue;
            return m;
        }
        return null;
    }

    public void setObject(PersistenceManager pm, Object ps, int[] param, Object value) {
        this.setObject(pm, ps, param, value, null, -1);
    }

    public void setObject(PersistenceManager pm, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        if (value == null) {
            int n = 0;
            String nullColumn = null;
            String nullValue = null;
            if (this.emd != null) {
                nullColumn = this.emd.getNullIndicatorColumn();
                nullValue = this.emd.getNullIndicatorValue();
            }
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = (JavaTypeMapping)this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                if (nullColumn != null && nullValue != null && mapping.getFieldMetaData().getColumnMetaData().length > 0 && mapping.getFieldMetaData().getColumnMetaData()[0].getName().equals(nullColumn)) {
                    if (mapping instanceof IntegerMapping || mapping instanceof BigIntegerMapping || mapping instanceof LongMapping || mapping instanceof ShortMapping) {
                        Number convertedValue = null;
                        try {
                            if (mapping instanceof IntegerMapping || mapping instanceof ShortMapping) {
                                convertedValue = new Integer(nullValue);
                            } else if (mapping instanceof LongMapping || mapping instanceof BigIntegerMapping) {
                                convertedValue = new Long(nullValue);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        mapping.setObject(pm, ps, posMapping, convertedValue);
                        continue;
                    }
                    mapping.setObject(pm, ps, posMapping, nullValue);
                    continue;
                }
                if (mapping.getNumberOfDatastoreFields() <= 0) continue;
                mapping.setObject(pm, ps, posMapping, null);
            }
        } else {
            if (!(value instanceof PersistenceCapable)) {
                throw new JDOFatalInternalException(LOCALISER.msg("Mapping.ObjectIsNotPersistenceCapable", value.getClass(), value));
            }
            PersistenceCapable pc = (PersistenceCapable)value;
            AbstractClassMetaData embCmd = pm.getMetaDataManager().getMetaDataForClass(pc.getClass().getName(), pm.getClassLoaderResolver());
            StateManager embSM = pm.findStateManager(pc);
            if (embSM == null || pc.jdoGetPersistenceManager() == null) {
                embSM = StateManagerFactory.newStateManager(pc, pm, false);
                embSM.addEmbeddedOwner(ownerSM, ownerFieldNumber);
                embSM.setPcObjectType(this.objectType);
            }
            int n = 0;
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = (JavaTypeMapping)this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                int embAbsFieldNum = embCmd.getFieldNumberAbsolute(mapping.getFieldMetaData().getName());
                Object fieldValue = embSM.provideField(embAbsFieldNum);
                if (mapping instanceof EmbeddedPCMapping) {
                    mapping.setObject(pm, ps, posMapping, fieldValue, embSM, embAbsFieldNum);
                    continue;
                }
                if (mapping.getNumberOfDatastoreFields() <= 0) continue;
                mapping.setObject(pm, ps, posMapping, fieldValue);
            }
        }
    }

    public Object getObject(PersistenceManager pm, Object rs, int[] param) {
        return this.getObject(pm, rs, param, null, -1);
    }

    public Object getObject(PersistenceManager pm, Object rs, int[] param, StateManager ownerSM, int ownerFieldNumber) {
        int ownerFieldNumberInElement;
        String ownerField;
        PersistenceCapable value = null;
        StateManager embSM = StateManagerFactory.newStateManager(pm, this.getJavaType(), (Object)null);
        embSM.setPcObjectType(this.objectType);
        value = embSM.getObject();
        String nullColumn = null;
        String nullValue = null;
        if (this.emd != null) {
            nullColumn = this.emd.getNullIndicatorColumn();
            nullValue = this.emd.getNullIndicatorValue();
        }
        AbstractClassMetaData embCmd = pm.getMetaDataManager().getMetaDataForClass(this.typeName, this.clr);
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
            JavaTypeMapping mapping = (JavaTypeMapping)this.javaTypeMappings.get(i);
            int embAbsFieldNum = embCmd.getFieldNumberAbsolute(mapping.getFieldMetaData().getName());
            if (mapping instanceof EmbeddedPCMapping) {
                int numSubParams = mapping.getNumberOfDatastoreFields();
                int[] subParam = new int[numSubParams];
                int k = 0;
                for (int j = n; j < n + numSubParams; ++j) {
                    subParam[k++] = param[j];
                }
                n += numSubParams;
                Object subValue = mapping.getObject(pm, rs, subParam, embSM, embAbsFieldNum);
                if (subValue == null) continue;
                embSM.replaceField(embAbsFieldNum, subValue);
                continue;
            }
            int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            Object fieldValue = mapping.getObject(pm, rs, posMapping);
            if (fieldValue != null) {
                embSM.replaceField(embAbsFieldNum, fieldValue);
            }
            if (nullColumn == null || !mapping.getFieldMetaData().getColumnMetaData()[0].getName().equals(nullColumn) || (nullValue != null || fieldValue != null) && (nullValue == null || !fieldValue.toString().equals(nullValue))) continue;
            value = null;
            break;
        }
        if (this.emd != null && (ownerField = this.emd.getOwnerField()) != null && (ownerFieldNumberInElement = embCmd.getFieldNumberAbsolute(ownerField)) >= 0) {
            embSM.replaceField(ownerFieldNumberInElement, ownerSM.getObject());
        }
        if (value != null && ownerSM != null) {
            embSM.addEmbeddedOwner(ownerSM, ownerFieldNumber);
        }
        return value;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return null;
    }

    public Class getJavaType() {
        return this.clr.classForName(this.typeName);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        ObjectExpression expr = new ObjectExpression(qs, this, te);
        return expr;
    }
}

