/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ContainerMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreObject;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NoDatastoreMappingException;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.scostore.Store;
import org.jpox.util.ClassUtils;

public abstract class AbstractContainerMapping
extends SingleFieldMapping {
    protected String fieldName;
    protected StoreManager storeMgr;
    protected DatastoreObject contentsTable;
    protected Store contentsStore;
    protected Class instantiatedType;
    static /* synthetic */ Class class$org$jpox$StateManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$ArrayList;

    public void initialize(DatastoreAdapter dba, AbstractPropertyMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.fieldName = fmd.getName();
        this.storeMgr = this.datastoreContainer.getStoreManager();
        ContainerMetaData conmd = fmd.getContainer();
        if (conmd == null) {
            throw new JDOUserException(LOCALISER.msg("ContainerMapping.ContainerMetaDataError", fmd.getFullFieldName()));
        }
        if (!this.containerIsStoredInSingleColumn()) {
            this.contentsTable = this.storeMgr.newJoinDatastoreContainerObject(fmd, clr);
        }
        this.contentsStore = null;
    }

    protected void prepareDatastoreMapping() {
        if (this.containerIsStoredInSingleColumn()) {
            super.prepareDatastoreMapping();
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return ClassNameConstants.JAVA_IO_SERIALIZABLE;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    public void setObject(PersistenceManager pm, Object preparedStatement, int[] exprIndex, Object value) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new JDOFatalInternalException(this.failureMessage("setObject"));
        }
        StateManager[] sms = null;
        if (value != null) {
            HashSet<StateManager> smsColl = null;
            if (value instanceof Collection) {
                Iterator elementsIter = ((Collection)value).iterator();
                while (elementsIter.hasNext()) {
                    StateManager sm;
                    Object elem = elementsIter.next();
                    if (!(elem instanceof PersistenceCapable) || (sm = pm.findStateManager((PersistenceCapable)elem)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet<StateManager>();
                    }
                    smsColl.add(sm);
                }
            } else if (value instanceof Map) {
                Iterator entriesIter = ((Map)value).entrySet().iterator();
                while (entriesIter.hasNext()) {
                    StateManager sm;
                    Map.Entry entry = entriesIter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key instanceof PersistenceCapable && (sm = pm.findStateManager((PersistenceCapable)key)) != null) {
                        if (smsColl == null) {
                            smsColl = new HashSet();
                        }
                        smsColl.add(sm);
                    }
                    if (!(val instanceof PersistenceCapable) || (sm = pm.findStateManager((PersistenceCapable)val)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet();
                    }
                    smsColl.add(sm);
                }
            }
            if (smsColl != null) {
                sms = smsColl.toArray(new StateManager[smsColl.size()]);
            }
        }
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].setStoringPC();
            }
        }
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], value);
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].unsetStoringPC();
            }
        }
    }

    public Object getObject(PersistenceManager pm, Object resultSet, int[] exprIndex) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new JDOFatalInternalException(this.failureMessage("getObject"));
        }
        return this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
    }

    public DatastoreContainerObject getDatastoreContainer() {
        if (this.containerIsStoredInSingleColumn()) {
            return this.datastoreContainer;
        }
        return null;
    }

    public int getNumberOfDatastoreFields() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getNumberOfDatastoreFields();
        }
        return 0;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMapping(index);
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    public DatastoreMapping[] getDataStoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMappings();
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    protected boolean containerIsStoredInSingleColumn() {
        return this.fmd != null && this.fmd.isSerialized();
    }

    public boolean includeInFetchStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInUpdateStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInInsertStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public int hashCode() {
        return this.fmd == null || this.storeMgr == null ? super.hashCode() : this.fmd.hashCode() ^ this.storeMgr.hashCode();
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return null;
    }

    protected Object newWrapper(StateManager ownerSM, String fieldName) {
        Class newType;
        String typeName = this.getType();
        if (this.instantiatedType != null) {
            typeName = this.instantiatedType.getName();
        }
        if ((newType = this.storeMgr.getPMFContext().getTypeManager().getSecondClassWrapper(typeName)) == null) {
            typeName = this.fmd.getTypeName();
            newType = this.storeMgr.getPMFContext().getTypeManager().getSecondClassWrapper(typeName);
            if (newType == null) {
                throw new JDOUserException(LOCALISER.msg("ContainerMapping.NewWrapperTypeNotValid", typeName));
            }
        }
        return ClassUtils.newInstance(newType, new Class[]{class$org$jpox$StateManager == null ? (class$org$jpox$StateManager = AbstractContainerMapping.class$("org.jpox.StateManager")) : class$org$jpox$StateManager, class$java$lang$String == null ? (class$java$lang$String = AbstractContainerMapping.class$("java.lang.String")) : class$java$lang$String}, new Object[]{ownerSM, this.fmd.getName()});
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.instantiatedType == null) {
            if (value == null) {
                if (this.fmd.getOrderMetaData() != null && this.fmd.getType() == (class$java$util$Collection == null ? (class$java$util$Collection = AbstractContainerMapping.class$("java.util.Collection")) : class$java$util$Collection)) {
                    this.instantiatedType = class$java$util$ArrayList == null ? (class$java$util$ArrayList = AbstractContainerMapping.class$("java.util.ArrayList")) : class$java$util$ArrayList;
                }
            } else {
                this.instantiatedType = value.getClass();
            }
        }
        sm.replaceField(this.fmd.getAbsoluteFieldNumber(), this.newWrapper(sm, this.fieldName));
    }

    protected void validateElementForWriting(StateManager sm, Object element) {
        if (element != null && element instanceof PersistenceCapable) {
            PersistenceManager pm = sm.getPersistenceManager();
            if (!JDOHelper.isPersistent((Object)element)) {
                boolean exists = false;
                if (JDOHelper.isDetached((Object)element)) {
                    try {
                        StateManager objSM;
                        Object obj = pm.getObjectById(((PersistenceCapable)element).jdoGetObjectId(), true, false, element.getClass().getName());
                        if (obj != null && (objSM = pm.findStateManager((PersistenceCapable)obj)) != null) {
                            pm.evictFromTransaction(objSM);
                        }
                        exists = true;
                    }
                    catch (JDOObjectNotFoundException onfe) {
                        exists = false;
                    }
                }
                if (!exists) {
                    pm.makePersistentInternal(element, null);
                }
            } else if (pm != JDOHelper.getPersistenceManager((Object)element)) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Collection.WriteInvalidWithDifferentPM"), JDOHelper.getObjectId((Object)element));
            }
        }
    }

    protected void validateElementsForWriting(StateManager sm, Object elements) {
        block3: {
            block4: {
                if (elements == null) break block3;
                if (!elements.getClass().isArray()) break block4;
                if (elements.getClass().getComponentType().isPrimitive()) break block3;
                Object[] obj = (Object[])elements;
                for (int i = 0; i < obj.length; ++i) {
                    this.validateElementForWriting(sm, obj[i]);
                }
                break block3;
            }
            if (elements instanceof Collection) {
                Collection col = (Collection)elements;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    this.validateElementForWriting(sm, it.next());
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

