/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.extent;

import java.util.HashMap;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.FetchPlan;
import javax.jdo.JDOFatalUserException;
import org.jpox.PersistenceManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.store.StoreManager;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.util.Localiser;

public abstract class AbstractExtent
implements Extent {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected final PersistenceManager pm;
    protected final Class candidateClass;
    protected final boolean subclasses;
    protected final AbstractClassMetaData cmd;
    protected final StoreManager storeMgr;
    protected final Query query;
    protected HashMap queryResultsByIterator = new HashMap();

    public AbstractExtent(PersistenceManager pm, Class cls, boolean subclasses) {
        if (cls == null) {
            throw new JDOFatalUserException(LOCALISER.msg("Extent.ClassNameNotSpecified"));
        }
        this.storeMgr = pm.getStoreManager();
        this.cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(cls, pm.getClassLoaderResolver());
        if (this.cmd == null) {
            throw new JDOFatalUserException(LOCALISER.msg("Extent.ClassHasNoMetaData", cls.getName()));
        }
        this.pm = pm;
        this.candidateClass = cls;
        this.subclasses = subclasses;
        this.query = (Query)pm.newQuery();
        this.query.setClass(this.candidateClass);
        this.query.setCandidates(this);
    }

    public boolean hasSubclasses() {
        return this.subclasses;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public javax.jdo.PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public Iterator iterator() {
        QueryResult qr = (QueryResult)this.query.execute();
        Iterator iter = qr.iterator();
        this.queryResultsByIterator.put(iter, qr);
        return iter;
    }

    public void close(Iterator iter) {
        QueryResult qr = (QueryResult)this.queryResultsByIterator.remove(iter);
        qr.close();
    }

    public void closeAll() {
        Iterator iter = this.queryResultsByIterator.values().iterator();
        while (iter.hasNext()) {
            QueryResult qr = (QueryResult)iter.next();
            qr.close();
            iter.remove();
        }
    }

    public FetchPlan getFetchPlan() {
        return this.query.getFetchPlan();
    }

    public String toString() {
        return LOCALISER.msg("Extent.ClassExtentInfo", this.candidateClass.getName(), "" + this.subclasses);
    }
}

