/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.HashMap;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.exceptions.TableMismatchException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;

public class TableExprAsJoins
extends LogicSetExpression {
    protected final HashMap rangeVarsByTable = new HashMap();

    public TableExprAsJoins(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier mainRangeVar) {
        super(qs, mainTable, mainRangeVar);
        this.rangeVarsByTable.put(mainTable, mainRangeVar);
    }

    public String referenceColumn(DatastoreField col) {
        String rangeVarString;
        this.assertNotFrozen();
        DatastoreContainerObject table = col.getDatastoreContainerObject();
        DatastoreIdentifier rangeVar = (DatastoreIdentifier)this.rangeVarsByTable.get(table);
        if (rangeVar == null) {
            if (!(this.mainTable instanceof DatastoreClass) || !(table instanceof DatastoreClass)) {
                throw new TableMismatchException(col, this.mainTable);
            }
            IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
            rangeVar = idFactory.newIdentifier(this.mainRangeVar, String.valueOf(this.rangeVarsByTable.size()));
            this.rangeVarsByTable.put(table, rangeVar);
            DatastoreClass mt = (DatastoreClass)this.mainTable;
            DatastoreClass st = (DatastoreClass)table;
            LogicSetExpression stTblExpr = this.qs.newTableExpression(st, rangeVar);
            ScalarExpression mtExpr = mt.getIDMapping().newScalarExpression(this.qs, this);
            ScalarExpression stExpr = st.getIDMapping().newScalarExpression(this.qs, stTblExpr);
            this.qs.innerJoin(mtExpr, stExpr, stTblExpr, true, true);
        }
        if ((rangeVarString = ((Object)rangeVar).toString()).length() > 0) {
            return col.applySelectFunction(rangeVarString + "." + col.getIdentifier());
        }
        return col.applySelectFunction(((Object)col.getIdentifier()).toString());
    }

    public String toString() {
        if (this.sqlText == null) {
            DatastoreIdentifier mainTableName = this.mainTable.getIdentifier();
            StringBuffer sb = new StringBuffer(this.mainTable.toString());
            if (!this.mainRangeVar.equals(mainTableName)) {
                sb.append(' ').append(this.mainRangeVar);
            }
            this.sqlText = sb.toString();
        }
        return this.sqlText;
    }
}

