/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import javax.jdo.JDOUserException;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;

public class ReferenceExpression
extends ScalarExpression {
    public ReferenceExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public ScalarExpression cast(Class castType) {
        JavaTypeMapping[] javaTypeMappings = ((ReferenceMapping)this.mapping).getJavaTypeMapping();
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            JavaTypeMapping m = javaTypeMappings[i];
            if (!castType.getName().equals(m.getType())) continue;
            return m.newScalarExpression(this.qs, this.te);
        }
        return super.cast(castType);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        ScalarExpression bexpr = null;
        JavaTypeMapping[] javaTypeMappings = ((ReferenceMapping)this.mapping).getJavaTypeMapping();
        if (expr.mapping instanceof ReferenceMapping) {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                if (bexpr == null) {
                    bexpr = m.newScalarExpression(this.qs, this.te).eq(expr);
                    bexpr.encloseWithInParentheses();
                    continue;
                }
                bexpr = ((BooleanExpression)bexpr).ior(m.newScalarExpression(this.qs, this.te).eq(expr).encloseWithInParentheses());
                bexpr.encloseWithInParentheses();
            }
        } else {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                JavaTypeMapping exprMapping = expr.mapping;
                if (m.getNumberOfDatastoreFields() != exprMapping.getNumberOfDatastoreFields()) continue;
                if (bexpr == null) {
                    bexpr = m.newScalarExpression(this.qs, this.te).eq(expr);
                    bexpr.encloseWithInParentheses();
                    continue;
                }
                bexpr = ((BooleanExpression)bexpr).ior(m.newScalarExpression(this.qs, this.te).eq(expr).encloseWithInParentheses());
                bexpr.encloseWithInParentheses();
            }
        }
        bexpr.encloseWithInParentheses();
        return bexpr;
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        ScalarExpression bexpr = null;
        JavaTypeMapping[] javaTypeMappings = ((ReferenceMapping)this.mapping).getJavaTypeMapping();
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            JavaTypeMapping m = javaTypeMappings[i];
            bexpr = bexpr == null ? m.newScalarExpression(this.qs, this.te).noteq(expr) : ((BooleanExpression)bexpr).and(m.newScalarExpression(this.qs, this.te).noteq(expr));
        }
        bexpr.encloseWithInParentheses();
        return bexpr;
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        throw new JDOUserException(LOCALISER.msg("InterfaceExpression.AccessFieldInvalid", fieldName, this.mapping.getType()));
    }
}

