/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.DatastoreObject;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NoSuchPersistentFieldException;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.EmbeddedKeyPCMapping;
import org.jpox.store.mapping.EmbeddedMapping;
import org.jpox.store.mapping.EmbeddedPCMapping;
import org.jpox.store.mapping.EmbeddedValuePCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.table.ElementContainerTable;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.util.Localiser;

public abstract class LogicSetExpression {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    protected final QueryExpression qs;
    protected final DatastoreContainerObject mainTable;
    protected final DatastoreIdentifier mainRangeVar;
    protected final StoreManager storeMgr;
    protected String sqlText = null;
    protected Map embeddedFieldMappings = null;

    protected LogicSetExpression(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier mainRangeVar) {
        this.qs = qs;
        this.mainTable = mainTable;
        this.mainRangeVar = mainRangeVar;
        this.storeMgr = mainTable.getStoreManager();
    }

    protected void assertNotFrozen() {
        if (this.sqlText != null) {
            // empty if block
        }
    }

    public final DatastoreObject getMainTable() {
        return this.mainTable;
    }

    public final DatastoreIdentifier getRangeVariable() {
        return this.mainRangeVar;
    }

    public ScalarExpression newFieldExpression(String fieldName) {
        if (this.mainTable instanceof DatastoreClass) {
            DatastoreClass ct = (DatastoreClass)this.mainTable;
            JavaTypeMapping m = null;
            if (fieldName.equals("this")) {
                m = ct.getIDMapping();
                return m.newScalarExpression(this.qs, this);
            }
            if (fieldName.indexOf(".") > 0) {
                ScalarExpression expr;
                String baseField;
                block22: {
                    baseField = fieldName.substring(0, fieldName.indexOf("."));
                    try {
                        m = ct.getFieldMapping(baseField);
                    }
                    catch (NoSuchPersistentFieldException npfe) {
                        if (this.embeddedFieldMappings != null) {
                            m = (JavaTypeMapping)this.embeddedFieldMappings.get(baseField);
                        }
                        if (m != null) break block22;
                        throw npfe;
                    }
                }
                if (m == null) {
                    throw new JDOUserException(LOCALISER.msg("TableExpression.QueryFieldNonExistent", fieldName, ((Object)ct).toString()));
                }
                if (m instanceof EmbeddedPCMapping) {
                    String subField = fieldName.substring(fieldName.indexOf(".") + 1);
                    if ((m = this.getMappingForEmbeddedField((EmbeddedPCMapping)m, subField)) == null) {
                        throw new JDOUserException(LOCALISER.msg("TableExpression.QuerySubFieldNonExistent", fieldName, subField, baseField));
                    }
                    if (this.embeddedFieldMappings == null) {
                        this.embeddedFieldMappings = new HashMap();
                    }
                    this.embeddedFieldMappings.put(subField, m);
                }
                if ((expr = m.newScalarExpression(this.qs, this)) instanceof ObjectExpression) {
                    ((ObjectExpression)expr).setFieldDefinition(m.getFieldMetaData().getName(), m.getFieldMetaData().getTypeName());
                }
                return expr;
            }
            m = ct.getFieldMapping(fieldName);
            if (m == null) {
                throw new JDOUserException(LOCALISER.msg("TableExpression.QueryFieldNonExistent", fieldName, ((Object)ct).toString()));
            }
            ScalarExpression expr = m.newScalarExpression(this.qs, this);
            if (expr instanceof ObjectExpression) {
                ((ObjectExpression)expr).setFieldDefinition(fieldName, m.getType());
            }
            return expr;
        }
        if (this.mainTable instanceof ElementContainerTable || this.mainTable instanceof MapTable) {
            JoinTable join;
            String fld = fieldName;
            if (fieldName.indexOf(".") > 0) {
                String subField;
                fld = subField = fieldName.substring(fieldName.indexOf(".") + 1);
            }
            if (this.mainTable instanceof ElementContainerTable) {
                join = (ElementContainerTable)this.mainTable;
                JavaTypeMapping m = ((ElementContainerTable)join).getElementMapping();
                if (m instanceof EmbeddedElementPCMapping) {
                    JavaTypeMapping fieldMapping = ((EmbeddedMapping)m).getJavaTypeMapping(fld);
                    if (fieldMapping != null) {
                        return fieldMapping.newScalarExpression(this.qs, this);
                    }
                    throw new JDOUserException("'" + fieldName + "' was not found as a field stored in the join table " + this.mainTable);
                }
            } else if (this.mainTable instanceof MapTable) {
                JavaTypeMapping fieldMapping;
                join = (MapTable)this.mainTable;
                JavaTypeMapping m = ((MapTable)join).getKeyMapping();
                if (m instanceof EmbeddedKeyPCMapping && (fieldMapping = ((EmbeddedMapping)m).getJavaTypeMapping(fld)) != null) {
                    return fieldMapping.newScalarExpression(this.qs, this);
                }
                m = ((MapTable)join).getValueMapping();
                if (m instanceof EmbeddedValuePCMapping && (fieldMapping = ((EmbeddedMapping)m).getJavaTypeMapping(fld)) != null) {
                    return fieldMapping.newScalarExpression(this.qs, this);
                }
            }
            throw new JDOUserException("'" + fieldName + "' was not found as an embedded element/key/value field stored in the join table " + this.mainTable);
        }
        throw new JDOUserException("'" + fieldName + "' can't be referenced in " + this.mainTable.toString() + ": table does not store a persistence-capable class or a join table storing a persistence-capable class");
    }

    private JavaTypeMapping getMappingForEmbeddedField(EmbeddedPCMapping m, String fieldName) {
        if (m == null || fieldName == null) {
            return null;
        }
        if (fieldName.indexOf(".") < 0) {
            return m.getJavaTypeMapping(fieldName);
        }
        String field = fieldName.substring(0, fieldName.indexOf("."));
        String subField = fieldName.substring(fieldName.indexOf(".") + 1);
        JavaTypeMapping mapping = m.getJavaTypeMapping(field);
        if (mapping instanceof EmbeddedPCMapping && subField != null) {
            return this.getMappingForEmbeddedField((EmbeddedPCMapping)mapping, subField);
        }
        return mapping;
    }

    public abstract String referenceColumn(DatastoreField var1);

    public abstract String toString();

    public int hashCode() {
        return this.mainTable.hashCode() ^ this.mainRangeVar.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicSetExpression)) {
            return false;
        }
        LogicSetExpression expr = (LogicSetExpression)obj;
        return this.mainRangeVar.equals(expr.mainRangeVar) && this.mainTable.equals(expr.mainTable);
    }
}

