/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import javax.jdo.JDOUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.ContainerSizeExpression;
import org.jpox.store.expression.ExistsExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.UnboundVariable;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.store.scostore.CollectionStore;

public class CollectionExpression
extends ScalarExpression {
    private final CollectionStore collStore;
    private final String fieldName;

    public CollectionExpression(QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, CollectionStore collStore, String fieldName) {
        super(qs);
        this.mapping = ownerMapping;
        this.collStore = collStore;
        this.fieldName = fieldName;
        this.te = te;
    }

    public NumericExpression sizeMethod() {
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
        DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
        return new ContainerSizeExpression(this.qs, this.collStore.getSizeSubquery(this.qs, this.mapping, this.te, ctRangeVar));
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        DatastoreIdentifier etRangeVar;
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        if (expr instanceof NullLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
        }
        if (expr instanceof UnboundVariable) {
            UnboundVariable var = (UnboundVariable)expr;
            if (var.getVariableType() == null) {
                var.setVariableType(this.qs.getClassLoaderResolver().classForName(this.collStore.getElementType()));
            }
            String etIdentifier = "UNBOUND." + var.getVariableName();
            String ctIdentifier = idFactory.newIdentifier(idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName), var.getVariableName()).getIdentifier();
            DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
            DatastoreIdentifier etRangeVar2 = idFactory.newIdentifier(0, etIdentifier);
            QueryExpression qexpr = this.collStore.getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
            qexpr.setParent(this.qs);
            ScalarExpression bindTo = this.collStore.joinElementsTo(qexpr, this.qs, this.mapping, this.te, ctRangeVar, var.getVariableType(), expr, expr.te == null ? etRangeVar2 : expr.te.getRangeVariable());
            var.bindTo(bindTo);
            if (this.qs.hasCrossJoin(this.qs.getTableExpression(etRangeVar2))) {
                qexpr.andCondition(bindTo.eq(expr.mapping.newScalarExpression(this.qs, this.qs.getTableExpression(etRangeVar2))));
            }
            return new ExistsExpression(this.qs, qexpr, true);
        }
        if (expr instanceof Literal) {
            DatastoreIdentifier etRangeVar3;
            String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
            DatastoreIdentifier ctRangeVar = this.qs.getStoreManager().getIdentifierFactory().newIdentifier(0, ctIdentifier);
            if (expr.te == null) {
                String etIdentifier;
                int n = 0;
                while (this.qs.getTableExpression(etRangeVar3 = idFactory.newIdentifier(0, etIdentifier = ctIdentifier + '.' + ++n)) != null) {
                }
            } else {
                etRangeVar3 = expr.te.getRangeVariable();
            }
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            QueryExpression qexpr = this.collStore.getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
            ScalarExpression expr1 = this.collStore.joinElementsTo(qexpr, this.qs, this.mapping, this.te, ctRangeVar, clr.classForName(expr.getMapping().getType()), expr, expr.te == null ? etRangeVar3 : expr.te.getRangeVariable());
            qexpr.andCondition(expr.eq(expr1));
            return new ExistsExpression(this.qs, qexpr, true);
        }
        String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
        DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
        if (expr.te == null) {
            String etIdentifier;
            int n = 0;
            while (this.qs.getTableExpression(etRangeVar = idFactory.newIdentifier(0, etIdentifier = ctIdentifier + '.' + ++n)) != null) {
            }
        } else {
            etRangeVar = expr.te.getRangeVariable();
        }
        ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
        ScalarExpression joinExpr = this.collStore.joinElementsTo(expr.getQueryExpression(), this.qs, this.mapping, this.te, ctRangeVar, clr.classForName(this.collStore.getElementType()), expr, etRangeVar);
        return joinExpr.eq(expr);
    }

    public BooleanExpression isEmptyMethod() {
        IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
        String ctIdentifier = idFactory.newIdentifier(this.te.getRangeVariable(), this.fieldName).getIdentifier();
        DatastoreIdentifier ctRangeVar = idFactory.newIdentifier(0, ctIdentifier);
        QueryExpression qexpr = this.collStore.getExistsSubquery(this.qs, this.mapping, this.te, ctRangeVar);
        qexpr.setParent(this.qs);
        return new ExistsExpression(this.qs, qexpr, false);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return this.isEmptyMethod();
        }
        throw new JDOUserException(LOCALISER.msg("CollectionExpression.EqualsNotNullInvalid"));
    }

    public StatementText toStatementText(int mode) {
        throw new JDOUserException("Cannot reference collection object directly: field name = " + this.fieldName);
    }
}

