/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.JDOUserException;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.JavaTypeMapping;

public class CharacterExpression
extends ScalarExpression {
    protected CharacterExpression(QueryExpression qs) {
        super(qs);
    }

    public CharacterExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public CharacterExpression(String functionName, List args) {
        super(functionName, args);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof StringLiteral) {
            Object value = ((StringLiteral)expr).getValue();
            if (value instanceof String && ((String)value).length() > 1) {
                throw new JDOUserException("Can't perform equality comparison between a character and a String of more than 1 character (" + value + ") !");
            }
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).eq(expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).noteq(expr);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.lt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).lt(expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.lteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).lteq(expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.gt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).gt(expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.gteq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).gteq(expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_ADD, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_ADD, expr);
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_SUB, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_SUB, expr);
        }
        return super.sub(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }

    public CharacterExpression toLowerCaseMethod() {
        ArrayList<CharacterExpression> args = new ArrayList<CharacterExpression>();
        args.add(this);
        return new CharacterExpression("LOWER", args);
    }

    public CharacterExpression toUpperCaseMethod() {
        ArrayList<CharacterExpression> args = new ArrayList<CharacterExpression>();
        args.add(this);
        return new CharacterExpression("UPPER", args);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_MUL, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_MUL, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).mul(expr);
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_DIV, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), OP_DIV, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).div(expr);
        }
        return super.div(expr);
    }

    public ScalarExpression mod(ScalarExpression expr) {
        if (expr instanceof CharacterExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().modOperator(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression((CharacterExpression)expr));
        }
        if (expr instanceof NumericExpression) {
            return this.qs.getStoreManager().getDatastoreAdapter().modOperator(this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this), expr);
        }
        return super.sub(expr);
    }

    public ScalarExpression neg() {
        return new NumericExpression(OP_NEG, this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this));
    }

    public ScalarExpression com() {
        return this.qs.getStoreManager().getDatastoreAdapter().toNumericExpression(this).neg().sub(new IntegerLiteral(this.qs, this.mapping, BigInteger.ONE));
    }
}

