/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.List;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class BinaryExpression
extends ScalarExpression {
    protected BinaryExpression(QueryExpression qs) {
        super(qs);
    }

    public BinaryExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public BinaryExpression(String functionName, List args) {
        super(functionName, args);
    }

    public BinaryExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, OP_NOTEQ, expr);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BooleanExpression(this, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof BinaryExpression) {
            return new BinaryExpression(this, OP_CONCAT, expr);
        }
        return super.add(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, OP_IN, expr);
    }
}

