/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.lang.reflect.Array;
import javax.jdo.JDOFatalException;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.expression.ArrayExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;

public class ArrayLiteral
extends ArrayExpression
implements Literal {
    Object value;

    protected ArrayLiteral(QueryExpression qs) {
        super(qs);
    }

    public ArrayLiteral(QueryExpression qs, ScalarExpression[] expr) {
        super(qs);
        this.exprs = expr;
    }

    public ArrayLiteral(QueryExpression qs, JavaTypeMapping mapping, Object literal) {
        super(qs);
        this.mapping = mapping;
        this.value = literal;
        if (this.value == null || !this.value.getClass().isArray()) {
            throw new JDOFatalException("Invalid argument literal : " + this.value);
        }
        DatastoreAdapter dba = qs.getStoreManager().getDatastoreAdapter();
        this.exprs = new ScalarExpression[Array.getLength(this.value)];
        for (int i = 0; i < Array.getLength(this.value); ++i) {
            JavaTypeMapping m = dba.getMapping(Array.get(this.value, i).getClass(), qs.getStoreManager(), qs.getClassLoaderResolver());
            this.exprs[i] = m.newLiteral(qs, Array.get(this.value, i));
        }
    }

    public Object getValue() {
        return this.value;
    }
}

