/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.state.jpa;

import javax.jdo.JDOUserException;
import javax.jdo.Transaction;
import org.jpox.StateManager;
import org.jpox.state.LifeCycleState;

class PersistentDirty
extends LifeCycleState {
    protected PersistentDirty() {
        this.isPersistent = true;
        this.isDirty = true;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = true;
        this.stateType = 3;
    }

    public LifeCycleState transitionDeletePersistent(StateManager sm) {
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeNontransactional(StateManager sm) {
        throw new JDOUserException(LOCALISER.msg("LifeCycle.PersistentDirtyToNontransactional"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan) {
        throw new JDOUserException(LOCALISER.msg("LifeCycle.PersistentDirtyToTransient"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRefresh(StateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        Transaction tx = sm.getPersistenceManager().currentTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionDetach(StateManager sm) {
        return this.changeState(sm, 10);
    }

    public String toString() {
        return "P_DIRTY";
    }
}

