/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.sco;

import java.io.ObjectStreamException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.sco.SCOCollection;
import org.jpox.sco.SCOCollectionIterator;
import org.jpox.sco.SCOMtoN;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.exceptions.IncompatibleElementTypeException;
import org.jpox.sco.exceptions.IncompatibleFieldTypeException;
import org.jpox.sco.exceptions.NullsNotAllowedException;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreClass;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.CollectionMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class SortedSet
extends AbstractSet
implements java.util.SortedSet,
SCOCollection,
SCOMtoN,
Cloneable,
Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private transient Object owner;
    private transient StateManager ownerSM;
    private transient String fieldName;
    private transient int fieldNumber;
    private transient Class elementType;
    private transient boolean allowNulls;
    protected CollectionStore backingStore;
    protected TreeSet delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    static /* synthetic */ Class class$java$util$TreeSet;

    public SortedSet(StateManager ownerSM, String fieldName) {
        this.init(ownerSM, fieldName, false, null);
    }

    private void init(StateManager ownerSM, String fieldName, boolean allowNulls, SetStore setStore) {
        this.owner = ownerSM.getObject();
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = allowNulls;
        Class<?> c = ownerSM.getObject().getClass();
        StoreManager storeMgr = ownerSM.getStoreManager();
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(c, ownerSM.getPersistenceManager().getClassLoaderResolver());
        boolean serialised = SCOUtils.collectionHasSerialisedElements(cmd.getField(fieldName));
        this.fieldNumber = cmd.getFieldNumberAbsolute(fieldName);
        if (setStore != null) {
            this.backingStore = setStore;
            this.elementType = ownerSM.getPersistenceManager().getClassLoaderResolver().classForName(setStore.getElementType());
        } else if (!serialised && cmd.getManagedFieldAbsolute(this.fieldNumber).getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            DatastoreClass ownerTable = storeMgr.getDatastoreClass(c.getName(), ownerSM.getPersistenceManager().getClassLoaderResolver());
            JavaTypeMapping m = ownerTable.getFieldMapping(ownerSM.getClassMetaData().getField(fieldName));
            if (!(m instanceof CollectionMapping)) {
                throw new IncompatibleFieldTypeException(ownerSM, fieldName, (class$java$util$TreeSet == null ? (class$java$util$TreeSet = SortedSet.class$("java.util.TreeSet")) : class$java$util$TreeSet).getName(), ownerSM.getMetaDataManager().getMetaDataForField(c, ownerSM.getPersistenceManager().getClassLoaderResolver(), fieldName).getTypeName());
            }
            this.backingStore = ((CollectionMapping)m).getBackingStore(ownerSM.getPersistenceManager().getClassLoaderResolver());
            this.elementType = ownerSM.getPersistenceManager().getClassLoaderResolver().classForName(this.backingStore.getElementType());
        }
        if (this.elementType != null && !this.elementType.isAssignableFrom(this.elementType)) {
            throw new IncompatibleElementTypeException(ownerSM, fieldName, this.elementType.getName(), this.elementType.getName());
        }
        Comparator comparator = SCOUtils.getComparator(cmd.getField(fieldName), ownerSM.getPersistenceManager().getClassLoaderResolver());
        this.delegate = comparator != null ? new TreeSet(comparator) : new TreeSet();
        this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName, cmd);
        if (this.useCache && !SCOUtils.useCachedLazyLoading(ownerSM, fieldName, cmd)) {
            this.loadFromStore();
        }
    }

    public Class getElementType() {
        return this.elementType;
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    public void setValueFrom(Object o, boolean forUpdate) {
        AbstractPropertyMetaData fmd;
        Collection c = (Collection)o;
        if (c != null && SCOUtils.collectionHasSerialisedElements(fmd = this.ownerSM.getClassMetaData().getField(this.fieldName)) && fmd.getCollection().getElementClassMetaData() != null) {
            PersistenceManager pm = this.ownerSM.getPersistenceManager();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                PersistenceCapable pc = (PersistenceCapable)iter.next();
                StateManager objSM = pm.findStateManager(pc);
                if (objSM != null) continue;
                objSM = StateManagerFactory.newStateManager(pc, pm, false);
                objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
            }
        }
        if (forUpdate) {
            this.clear();
            this.addAll(c);
        } else {
            this.delegate.clear();
            this.delegate.addAll(c);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public void runReachability(Set reachables) {
        Object[] values = this.toArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i] instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)values[i]).runReachability(reachables);
        }
    }

    public void makeTransient(FetchPlanState state) {
        Object[] values = this.toArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i] instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().internalMakeTransient(values[i], state);
        }
        this.ownerSM = null;
        this.backingStore = null;
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        Object[] values = this.toArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i] instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)values[i]).loadFieldsInFetchPlan(state);
        }
    }

    public void detach(FetchPlanState state) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object == null || !(object instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().detachInternal(object, state);
        }
        this.ownerSM = null;
        this.backingStore = null;
    }

    public Object detachCopy(FetchPlanState state) {
        TreeSet<Object> detached = new TreeSet<Object>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof PersistenceCapable) {
                detached.add(this.ownerSM.getPersistenceManager().detachCopyInternal(object, state));
                continue;
            }
            detached.add(object);
        }
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractPropertyMetaData fmd = this.ownerSM.getClassMetaData().getField(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet<Object> attachedElements = new HashSet<Object>(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object detachedElement = iter.next();
            if (ClassUtils.isPersistenceCapable(detachedElement) && detachedElement instanceof Detachable) {
                attachedElements.add(this.ownerSM.getPersistenceManager().attachCopy(detachedElement, elementsWithoutIdentity));
                continue;
            }
            attachedElements.add(detachedElement);
        }
        SCOUtils.updateCollectionWithCollectionElements(this, attachedElements);
    }

    public synchronized QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.elementType);
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newQueryStatement(this.ownerSM, candidate_class.getName());
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newResultObjectFactory(this.ownerSM, stmt, ignoreCache, useFetchPlan);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            TreeSet sorted = new TreeSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                sorted.remove(iter.next());
            }
            return sorted.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set c = (Set)o;
        return c.size() == this.size() && this.containsAll((Collection)c);
    }

    public Object first() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.first();
        }
        if (!this.useCache) {
            Iterator iter = this.iterator();
            return iter.next();
        }
        this.loadFromStore();
        return this.delegate.first();
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    public java.util.SortedSet headSet(Object toElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headSet(toElement);
        }
        if (!this.useCache) {
            throw new JDOUserException("JPOX doesn't currently support SortedSet.headSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headSet(toElement);
    }

    public java.util.SortedSet subSet(Object fromElement, Object toElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subSet(fromElement, toElement);
        }
        if (!this.useCache) {
            throw new JDOUserException("JPOX doesn't currently support SortedSet.subSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.subSet(fromElement, toElement);
    }

    public java.util.SortedSet tailSet(Object fromElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headSet(fromElement);
        }
        if (!this.useCache) {
            throw new JDOUserException("JPOX doesn't currently support SortedSet.tailSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headSet(fromElement);
    }

    public Object last() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.last();
        }
        if (!this.useCache) {
            Iterator iter = this.iterator();
            Object last = null;
            while (iter.hasNext()) {
                last = iter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.last();
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    public boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.add(this.ownerSM, element);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "add", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean addAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.addAll(this.ownerSM, c);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "addAll", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(c);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            this.backingStore.clear(this.ownerSM);
        }
        this.delegate.clear();
    }

    public boolean remove(Object element) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.remove(this.ownerSM, element);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "remove", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean removeAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean delegateSuccess = this.delegate.removeAll(c);
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.removeAll(this.ownerSM, c);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "removeAll", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new TreeSet(this.delegate);
        }
        return new TreeSet(this.delegate);
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

