/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.sco;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.JDODataStoreException;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.sco.SCOCollection;
import org.jpox.sco.SCOCollectionIterator;
import org.jpox.sco.SCOMtoN;
import org.jpox.sco.SCOUtils;
import org.jpox.sco.exceptions.IncompatibleElementTypeException;
import org.jpox.sco.exceptions.IncompatibleFieldTypeException;
import org.jpox.sco.exceptions.NullsNotAllowedException;
import org.jpox.sco.exceptions.QueryUnownedSCOException;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreClass;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.CollectionMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class Set
extends AbstractSet
implements SCOCollection,
SCOMtoN,
Cloneable,
Queryable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected Object owner;
    protected StateManager ownerSM;
    protected String fieldName;
    protected int fieldNumber;
    protected Class elementType;
    protected boolean allowNulls;
    protected CollectionStore backingStore;
    protected Collection delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    static /* synthetic */ Class class$java$util$Set;

    public Set(StateManager ownerSM, String fieldName) {
        this.init(ownerSM, fieldName, false, null);
    }

    public Set(StateManager ownerSM, String fieldName, boolean allowsNulls, SetStore backingStore) {
        this.init(ownerSM, fieldName, allowsNulls, backingStore);
    }

    protected void init(StateManager ownerSM, String fieldName, boolean allowNulls, SetStore backingStore) {
        this.owner = ownerSM.getObject();
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = allowNulls;
        Class<?> c = ownerSM.getObject().getClass();
        StoreManager storeMgr = ownerSM.getStoreManager();
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(c, ownerSM.getPersistenceManager().getClassLoaderResolver());
        boolean serialised = SCOUtils.collectionHasSerialisedElements(cmd.getField(fieldName));
        this.fieldNumber = cmd.getFieldNumberAbsolute(fieldName);
        if (backingStore != null) {
            this.backingStore = backingStore;
            this.elementType = ownerSM.getPersistenceManager().getClassLoaderResolver().classForName(backingStore.getElementType());
        } else if (!serialised && cmd.getManagedFieldAbsolute(this.fieldNumber).getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            DatastoreClass ownerTable = storeMgr.getDatastoreClass(c.getName(), ownerSM.getPersistenceManager().getClassLoaderResolver());
            JavaTypeMapping m = ownerTable.getFieldMapping(ownerSM.getClassMetaData().getField(fieldName));
            if (!(m instanceof CollectionMapping)) {
                throw new IncompatibleFieldTypeException(ownerSM, fieldName, (class$java$util$Set == null ? (class$java$util$Set = Set.class$("java.util.Set")) : class$java$util$Set).getName(), ownerSM.getMetaDataManager().getMetaDataForField(c, ownerSM.getPersistenceManager().getClassLoaderResolver(), fieldName).getTypeName());
            }
            this.backingStore = ((CollectionMapping)m).getBackingStore(ownerSM.getPersistenceManager().getClassLoaderResolver());
            this.elementType = ownerSM.getPersistenceManager().getClassLoaderResolver().classForName(this.backingStore.getElementType());
        }
        if (this.elementType != null && !this.elementType.isAssignableFrom(this.elementType)) {
            throw new IncompatibleElementTypeException(ownerSM, fieldName, this.elementType.getName(), this.elementType.getName());
        }
        this.delegate = new HashSet();
        this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName, cmd);
        if (this.useCache && !SCOUtils.useCachedLazyLoading(ownerSM, fieldName, cmd)) {
            this.loadFromStore();
        }
    }

    public Class getElementType() {
        return this.elementType;
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    public void setValueFrom(Object o, boolean forUpdate) {
        AbstractPropertyMetaData fmd;
        Collection c = (Collection)o;
        if (c != null && SCOUtils.collectionHasSerialisedElements(fmd = this.ownerSM.getClassMetaData().getField(this.fieldName)) && fmd.getCollection().getElementClassMetaData() != null) {
            PersistenceManager pm = this.ownerSM.getPersistenceManager();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                PersistenceCapable pc = (PersistenceCapable)iter.next();
                StateManager objSM = pm.findStateManager(pc);
                if (objSM != null) continue;
                objSM = StateManagerFactory.newStateManager(pc, pm, false);
                objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
            }
        }
        if (forUpdate) {
            SCOUtils.updateCollectionWithCollection(this, c);
        } else {
            this.delegate.clear();
            this.delegate.addAll(c);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.owner = null;
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.makeDirty(this.fieldNumber);
        }
    }

    public void runReachability(java.util.Set reachables) {
        Object[] values = this.toArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i] instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)values[i]).runReachability(reachables);
        }
    }

    public void makeTransient(FetchPlanState state) {
        Object[] values = this.toArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i] instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().internalMakeTransient(values[i], state);
        }
        this.ownerSM = null;
        this.backingStore = null;
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        Object[] values = this.toArray();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !(values[i] instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().findStateManager((PersistenceCapable)values[i]).loadFieldsInFetchPlan(state);
        }
    }

    public void detach(FetchPlanState state) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object == null || !(object instanceof PersistenceCapable)) continue;
            this.ownerSM.getPersistenceManager().detachInternal(object, state);
        }
        this.ownerSM = null;
        this.backingStore = null;
    }

    public Object detachCopy(FetchPlanState state) {
        HashSet<Object> detached = new HashSet<Object>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof PersistenceCapable) {
                detached.add(this.ownerSM.getPersistenceManager().detachCopyInternal(object, state));
                continue;
            }
            detached.add(object);
        }
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractPropertyMetaData fmd = this.ownerSM.getClassMetaData().getField(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet<Object> attachedElements = new HashSet<Object>(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object detachedElement = iter.next();
            if (ClassUtils.isPersistenceCapable(detachedElement) && detachedElement instanceof Detachable) {
                attachedElements.add(this.ownerSM.getPersistenceManager().attachCopy(detachedElement, elementsWithoutIdentity));
                continue;
            }
            attachedElements.add(detachedElement);
        }
        SCOUtils.updateCollectionWithCollectionElements(this, attachedElements);
    }

    public synchronized QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.elementType);
    }

    public synchronized QueryExpression newQueryStatement(Class candidate_class) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newQueryStatement(this.ownerSM, candidate_class.getName());
    }

    public synchronized ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        if (this.backingStore == null) {
            throw new QueryUnownedSCOException();
        }
        return this.backingStore.newResultObjectFactory(this.ownerSM, stmt, ignoreCache, useFetchPlan);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((HashSet)this.delegate).clone();
    }

    public synchronized boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.Set)) {
            return false;
        }
        java.util.Set c = (java.util.Set)o;
        return c.size() == this.size() && this.containsAll((Collection)c);
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((Object)this.delegate).hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public synchronized boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.add(this.ownerSM, element);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "add", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean addAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.addAll(this.ownerSM, c);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "addAll", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(c);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            this.backingStore.clear(this.ownerSM);
        }
        this.delegate.clear();
    }

    public synchronized boolean remove(Object element) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.remove(this.ownerSM, element);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "remove", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean removeAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean delegateSuccess = this.delegate.removeAll(c);
        boolean backingSuccess = false;
        if (this.backingStore != null) {
            try {
                backingSuccess = this.backingStore.removeAll(this.ownerSM, c);
            }
            catch (JDODataStoreException dse) {
                JPOXLogger.JDO.warn(LOCALISER.msg("SCO.ErrorExecutingMethod", "removeAll", this.fieldName, (Object)dse));
                backingSuccess = false;
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new HashSet(this.delegate);
        }
        return new HashSet(this.delegate);
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

