/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.resource;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOException;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jpox.AbstractPersistenceManager;
import org.jpox.LifecycleListenerForClass;
import org.jpox.PersistenceManager;
import org.jpox.resource.ManagedConnectionFactoryImpl;
import org.jpox.resource.PersistenceManagerImpl;
import org.jpox.store.rdbms.RDBMSManagedTransaction;
import org.jpox.util.JPOXLogger;

public class ManagedConnectionImpl
extends AbstractPersistenceManager
implements LocalTransaction,
ManagedConnection,
XAResource {
    private final PasswordCredential credential;
    private final List closedHandles = new ArrayList();
    private final List handles = new ArrayList();
    private final Collection cels = new ArrayList();
    private PrintWriter logWriter;

    public ManagedConnectionImpl(ManagedConnectionFactory mcf, PasswordCredential credential) throws ResourceException {
        super((ManagedConnectionFactoryImpl)mcf, credential == null ? null : credential.getUserName(), credential == null ? null : new String(credential.getPassword()));
        this.credential = credential;
        this.tx = this.getStoreManager().getManagedTransaction(this, credential);
    }

    PasswordCredential getPasswordCredential() {
        return this.credential;
    }

    ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return (ManagedConnectionFactoryImpl)this.apmf;
    }

    public void destroy() throws ResourceException {
        if (!this.handles.isEmpty()) {
            ArrayList handlesToClose = new ArrayList(this.handles);
            Iterator it = handlesToClose.iterator();
            while (it.hasNext()) {
                PersistenceManager pm = (PersistenceManager)it.next();
                if (pm.isClosed()) continue;
                pm.close();
            }
        }
        if (this.tx != null) {
            try {
                ((RDBMSManagedTransaction)this.tx).closeConnection();
            }
            catch (SQLException e) {
                throw new ResourceException("Problem destroying ManagedConnection: " + e);
            }
        }
        this.close();
    }

    public synchronized void cleanup() throws ResourceException {
        Iterator i = this.handles.iterator();
        while (i.hasNext()) {
            ((PersistenceManagerImpl)i.next()).setManagedConnection(null);
        }
        this.handles.clear();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        PasswordCredential pc = this.getManagedConnectionFactory().getPasswordCredential(subject);
        if (this.credential != pc && this.credential != null && pc != null && !this.credential.equals((Object)pc)) {
            throw new ResourceException("Wrong subject: " + subject + " MCF credentials: " + pc + " MC credentials: " + this.credential);
        }
        PersistenceManagerImpl o = new PersistenceManagerImpl(this);
        o.removeAllInstanceLifecycleListeners();
        List lifecycleListeners = this.getManagedConnectionFactory().getLifecycleListenerSpecifications();
        if (lifecycleListeners != null) {
            Iterator listenerIter = lifecycleListeners.iterator();
            while (listenerIter.hasNext()) {
                LifecycleListenerForClass listener = (LifecycleListenerForClass)listenerIter.next();
                o.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        this.handles.add(0, o);
        return o;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
        this.logWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener cel) {
        Collection collection = this.cels;
        synchronized (collection) {
            this.cels.add(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener cel) {
        Collection collection = this.cels;
        synchronized (collection) {
            this.cels.remove(cel);
        }
    }

    public void associateConnection(Object c) throws ResourceException {
        if (!(c instanceof PersistenceManagerImpl)) {
            throw new ResourceException("wrong Connection type!");
        }
        ((PersistenceManagerImpl)c).setManagedConnection(this);
        this.handles.add(0, c);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this;
    }

    public Transaction getJdoTransaction() {
        return this.tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new ResourceException("Not Yet Implemented");
    }

    public XAResource getXAResource() throws ResourceException {
        return this;
    }

    public void begin() throws ResourceException {
        if (this.tx == null) {
            JPOXLogger.JDO.error("Invalid state during begin invoke. Transaction is closed.");
            return;
        }
        try {
            this.tx.begin();
        }
        catch (JDOException e) {
            throw new ResourceException("JDOException: " + (Object)((Object)e));
        }
        Iterator it = this.handles.iterator();
        while (it.hasNext()) {
            this.notifyTxBegin((PersistenceManagerImpl)it.next());
        }
    }

    public void commit() throws ResourceException {
        if (this.tx == null) {
            JPOXLogger.JDO.error("Invalid state during commit invoke. Transaction is closed.");
            return;
        }
        try {
            this.tx.commit();
        }
        catch (JDOException e) {
            if (JPOXLogger.JDO.isInfoEnabled()) {
                JPOXLogger.JDO.info("Exception during commit: ", e);
            }
            throw new ResourceException("JDOException: " + (Object)((Object)e));
        }
        ArrayList h = new ArrayList(this.handles);
        Iterator it = h.iterator();
        while (it.hasNext()) {
            this.notifyTxCommit((PersistenceManagerImpl)it.next());
        }
        ArrayList ch = new ArrayList(this.closedHandles);
        ch.removeAll(h);
        Iterator it2 = ch.iterator();
        while (it2.hasNext()) {
            this.notifyTxCommit((PersistenceManagerImpl)it2.next());
        }
        this.closedHandles.clear();
    }

    public void rollback() throws ResourceException {
        if (this.tx == null) {
            JPOXLogger.JDO.error("Invalid state during rollback invoke. Transaction is closed.");
            return;
        }
        try {
            this.tx.rollback();
        }
        catch (JDOException e) {
            if (JPOXLogger.JDO.isInfoEnabled()) {
                JPOXLogger.JDO.info("Exception during rollback: ", e);
            }
            throw new ResourceException("JDOException: " + (Object)((Object)e));
        }
        ArrayList h = new ArrayList(this.handles);
        Iterator it = h.iterator();
        while (it.hasNext()) {
            this.notifyTxRollback((PersistenceManagerImpl)it.next());
        }
        ArrayList ch = new ArrayList(this.closedHandles);
        ch.removeAll(h);
        Iterator it2 = ch.iterator();
        while (it2.hasNext()) {
            this.notifyTxRollback((PersistenceManagerImpl)it2.next());
        }
        this.closedHandles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyClosed(PersistenceManagerImpl handle) {
        this.disconnectLifecycleListener();
        this.disconnectQueryCache();
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1, null);
        ce.setConnectionHandle((Object)handle);
        ArrayList localCels = null;
        Collection collection = this.cels;
        synchronized (collection) {
            localCels = new ArrayList(this.cels);
        }
        Iterator i = localCels.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).connectionClosed(ce);
        }
        if (this.tx != null && this.tx.isActive()) {
            this.closedHandles.add(handle);
        }
    }

    public synchronized void preCommit() {
        super.preCommit();
        this.flush();
        this.disconnectSMCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTxBegin(PersistenceManagerImpl handle) {
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 2, null);
        ce.setConnectionHandle((Object)handle);
        ArrayList localCels = null;
        Collection collection = this.cels;
        synchronized (collection) {
            localCels = new ArrayList(this.cels);
        }
        Iterator i = localCels.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).localTransactionStarted(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTxCommit(PersistenceManagerImpl handle) {
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3, null);
        ce.setConnectionHandle((Object)handle);
        ArrayList localCels = null;
        Collection collection = this.cels;
        synchronized (collection) {
            localCels = new ArrayList(this.cels);
        }
        Iterator i = localCels.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).localTransactionCommitted(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTxRollback(PersistenceManagerImpl handle) {
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 4, null);
        ce.setConnectionHandle((Object)handle);
        ArrayList localCels = null;
        Collection collection = this.cels;
        synchronized (collection) {
            localCels = new ArrayList(this.cels);
        }
        Iterator i = localCels.iterator();
        while (i.hasNext()) {
            ((ConnectionEventListener)i.next()).localTransactionRolledback(ce);
        }
    }

    public PersistenceManager getPMHandle() {
        if (this.handles.size() != 1 && JPOXLogger.JDO.isInfoEnabled()) {
            JPOXLogger.JDO.info(LOCALISER.msg("PM.HandleInvalid", "" + this.handles.size()));
        }
        return (PersistenceManager)this.handles.iterator().next();
    }

    public boolean isSamePM(javax.jdo.PersistenceManager pm) {
        return this.handles.contains(pm);
    }

    public JDOConnection getDataStoreConnection() {
        return this.tx.getJDOConnection();
    }

    public void commit(Xid xid, boolean flags) throws XAException {
        try {
            this.tx.commit();
        }
        catch (JDOException e) {
            if (JPOXLogger.JDO.isInfoEnabled()) {
                JPOXLogger.JDO.info("Exception during commit: ", e);
            }
            throw new XAException("JDOException: " + (Object)((Object)e));
        }
        ArrayList h = new ArrayList(this.handles);
        Iterator it = h.iterator();
        while (it.hasNext()) {
            this.notifyTxCommit((PersistenceManagerImpl)it.next());
        }
        ArrayList ch = new ArrayList(this.closedHandles);
        ch.removeAll(h);
        Iterator it2 = ch.iterator();
        while (it2.hasNext()) {
            this.notifyTxCommit((PersistenceManagerImpl)it2.next());
        }
        this.closedHandles.clear();
    }

    public void end(Xid xid, int flags) throws XAException {
        if (flags == 0x4000000) {
            this.flush();
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return false;
    }

    public int prepare(Xid flags) throws XAException {
        return 0;
    }

    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.tx.rollback();
        }
        catch (JDOException e) {
            if (JPOXLogger.JDO.isInfoEnabled()) {
                JPOXLogger.JDO.info("Exception during rollback: ", e);
            }
            throw new XAException("JDOException: " + (Object)((Object)e));
        }
        ArrayList h = new ArrayList(this.handles);
        Iterator it = h.iterator();
        while (it.hasNext()) {
            this.notifyTxRollback((PersistenceManagerImpl)it.next());
        }
        ArrayList ch = new ArrayList(this.closedHandles);
        ch.removeAll(h);
        Iterator it2 = ch.iterator();
        while (it2.hasNext()) {
            this.notifyTxRollback((PersistenceManagerImpl)it2.next());
        }
        this.closedHandles.clear();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (!this.tx.isActive()) {
            try {
                this.tx.begin();
            }
            catch (JDOException e) {
                throw new XAException("JDOException: " + (Object)((Object)e));
            }
            Iterator it = this.handles.iterator();
            while (it.hasNext()) {
                this.notifyTxBegin((PersistenceManagerImpl)it.next());
            }
        }
    }
}

