/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.plugin;

import java.net.URL;
import org.jpox.plugin.Extension;
import org.jpox.plugin.Plugin;

public class ExtensionPoint {
    private final String id;
    private final String name;
    private final URL schema;
    private final Plugin plugin;
    private Extension[] extensions;

    public ExtensionPoint(String id, String name, URL schema, Plugin plugin) {
        this.id = id;
        this.name = name;
        this.schema = schema;
        this.plugin = plugin;
        this.extensions = new Extension[0];
    }

    public Extension[] getExtensions() {
        return this.extensions;
    }

    public void addExtension(Extension extension) {
        Extension[] exs = new Extension[this.extensions.length + 1];
        System.arraycopy(this.extensions, 0, exs, 0, this.extensions.length);
        exs[this.extensions.length] = extension;
        this.extensions = exs;
    }

    public String getId() {
        return this.id;
    }

    public String getUniqueId() {
        return this.plugin.getId() + "." + this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getSchema() {
        return this.schema;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

