/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOUserException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.JDOEntityResolver;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaDataUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    private static MetaDataUtils instance;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public static synchronized MetaDataUtils getInstance() {
        if (instance == null) {
            instance = new MetaDataUtils();
        }
        return instance;
    }

    protected MetaDataUtils() {
    }

    public List getOrderedClassNamesFromFileList(URL[] metaDataFileURLs, Map classToMetaDataMap) throws Exception {
        HashMap<String, String> superclassesByClass = new HashMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        db.setEntityResolver(new JDOEntityResolver());
        for (int i = 0; i < metaDataFileURLs.length; ++i) {
            Element docElement = db.parse(metaDataFileURLs[i].openStream()).getDocumentElement();
            NodeList nodes = docElement.getElementsByTagName("class");
            for (int j = 0; j < nodes.getLength(); ++j) {
                Element clsElement = (Element)nodes.item(j);
                String packageName = ((Element)clsElement.getParentNode()).getAttribute("name");
                String superclassName = clsElement.getAttribute("persistence-capable-superclass");
                superclassName = superclassName.length() == 0 ? null : ClassUtils.createFullClassName(packageName, superclassName);
                String className = clsElement.getAttribute("name");
                if (StringUtils.isWhitespace(packageName)) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Package.NameNotSpecified", metaDataFileURLs[i]));
                    continue;
                }
                if (StringUtils.isWhitespace(className)) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.NameNotSpecified", packageName, metaDataFileURLs[i]));
                    continue;
                }
                className = ClassUtils.createFullClassName(packageName, className);
                superclassesByClass.put(className, superclassName);
                if (classToMetaDataMap == null) continue;
                classToMetaDataMap.put(className, metaDataFileURLs[i]);
            }
        }
        int numClasses = superclassesByClass.size();
        ArrayList orderedNames = new ArrayList(numClasses);
        ArrayList sortedNames = new ArrayList(numClasses);
        sortedNames.addAll(superclassesByClass.keySet());
        Collections.sort(sortedNames);
        Iterator i = sortedNames.iterator();
        while (i.hasNext()) {
            MetaDataUtils.addClassToOrderedList(orderedNames, (String)i.next(), superclassesByClass);
        }
        return orderedNames;
    }

    private static void addClassToOrderedList(List names, String className, Map superclassesByClass) throws Exception {
        String superclassName = (String)superclassesByClass.get(className);
        if (superclassName != null) {
            MetaDataUtils.addClassToOrderedList(names, superclassName, superclassesByClass);
        }
        if (!names.contains(className)) {
            names.add(className);
        }
    }

    public static boolean arrayStorableAsByteArrayInSingleColumn(AbstractPropertyMetaData fmd) {
        if (fmd == null || !fmd.hasArray()) {
            return false;
        }
        String arrayComponentType = fmd.getType().getComponentType().getName();
        return arrayComponentType.equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER);
    }

    public boolean storesFCO(AbstractPropertyMetaData fmd, ClassLoaderResolver clr) {
        if (fmd == null) {
            return false;
        }
        MetaDataManager mgr = fmd.getAbstractClassMetaData().getMetaDataManager();
        if (fmd.isSerialized() || fmd.isEmbedded()) {
            return false;
        }
        if (fmd.hasCollection() && !fmd.getCollection().isSerializedElement() && !fmd.getCollection().isEmbeddedElement()) {
            if (fmd.getCollection().getElementClassMetaData() != null) {
                return true;
            }
            String elementType = fmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (elementCls != null && mgr.getPMFContext().getTypeManager().isReferenceType(elementCls) && mgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasMap()) {
            if (fmd.getMap().getKeyClassMetaData() != null && !fmd.getMap().isEmbeddedKey() && !fmd.getMap().isSerializedKey()) {
                return true;
            }
            String keyType = fmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (keyCls != null && mgr.getPMFContext().getTypeManager().isReferenceType(keyCls) && mgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (fmd.getMap().getValueClassMetaData() != null && !fmd.getMap().isEmbeddedValue() && !fmd.getMap().isSerializedValue()) {
                return true;
            }
            String valueType = fmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (valueCls != null && mgr.getPMFContext().getTypeManager().isReferenceType(valueCls) && mgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasArray() && !fmd.getArray().isSerializedElement() && !fmd.getArray().isEmbeddedElement()) {
            if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MetaDataUtils.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(fmd.getType().getComponentType())) {
                return true;
            }
        } else {
            if (mgr.getPMFContext().getTypeManager().isReferenceType(fmd.getType()) && mgr.getMetaDataForImplementationOfReference(fmd.getType(), null, clr) != null) {
                return true;
            }
            if (mgr.getMetaDataForClass(fmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public String[] getValuesForCommaSeparatedAttribute(String attr) {
        if (attr == null || attr.length() == 0) {
            return null;
        }
        String[] values = StringUtils.split(attr, ",");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }

    public String[] getImplementationNamesForReferenceField(AbstractPropertyMetaData fmd, int fieldRole, ClassLoaderResolver clr) {
        String[] implTypes = null;
        String implTypeStr = null;
        implTypeStr = 4 == fieldRole ? fmd.getArray().getElementType() : fmd.getFieldType();
        if (implTypeStr != null) {
            implTypes = this.getValuesForCommaSeparatedAttribute(implTypeStr);
        }
        if (implTypes == null) {
            implTypes = 3 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : (5 == fieldRole ? fmd.getValuesForExtension("key-implementation-classes") : (6 == fieldRole ? fmd.getValuesForExtension("value-implementation-classes") : (4 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : fmd.getValuesForExtension("implementation-classes"))));
        }
        if (implTypes == null) {
            String type = null;
            type = fmd.hasCollection() && fieldRole == 3 ? fmd.getCollection().getElementType() : (fmd.hasMap() && fieldRole == 5 ? fmd.getMap().getKeyType() : (fmd.hasMap() && fieldRole == 6 ? fmd.getMap().getValueType() : (fmd.hasArray() && fieldRole == 4 ? fmd.getType().getComponentType().getName() : fmd.getTypeName())));
            if (!type.equals(ClassNameConstants.OBJECT)) {
                implTypes = fmd.getAbstractClassMetaData().getMetaDataManager().getClassesImplementingInterface(type, clr);
            }
            if (implTypes == null) {
                throw new JDOUserException(LOCALISER.msg("MetaData.Reference.NoImplementationClassesFound", fmd.getFullFieldName(), type));
            }
        }
        int noOfDups = 0;
        block0: for (int i = 0; i < implTypes.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                ++noOfDups;
                continue block0;
            }
        }
        String[] impls = new String[implTypes.length - noOfDups];
        int n = 0;
        for (int i = 0; i < implTypes.length; ++i) {
            boolean dup = false;
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            impls[n++] = implTypes[i];
        }
        return impls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

