/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.jpox.PMFConfiguration;
import org.jpox.PMFContext;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ElementMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.IdentityMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.JDOMetaDataManager;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MapMetaData;
import org.jpox.metadata.MetaDataParser;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class MetaDataMigrator {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int return_code = 0;
        System.out.println(LOCALISER.msg("MetaData.Migrator.Title"));
        System.out.println(LOCALISER.msg("MetaData.Migrator.Title.2"));
        boolean verbose = false;
        ArrayList<String> files = new ArrayList<String>();
        String indent_value = "4";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-indent")) {
                indent_value = args[++i];
                continue;
            }
            if (args[i].equals("-help")) {
                System.out.println(LOCALISER.msg("MetaData.Migrator.Help.Usage"));
                System.out.println(LOCALISER.msg("MetaData.Migrator.Help.Options.0"));
                System.out.println(LOCALISER.msg("MetaData.Migrator.Help.Options.1"));
                System.out.println(LOCALISER.msg("MetaData.Migrator.Help.Options.2"));
                System.out.println(LOCALISER.msg("MetaData.Migrator.Help.Options.3"));
                System.exit(0);
                continue;
            }
            files.add(args[i]);
        }
        int indent_size = 4;
        try {
            indent_size = new Integer(indent_value);
        }
        catch (Exception e) {
            indent_size = 4;
        }
        StringBuffer indent_str = new StringBuffer("");
        for (int i = 0; i < indent_size; ++i) {
            indent_str.append(" ");
        }
        if (verbose) {
            System.out.println(LOCALISER.msg("MetaData.Migrator.IndentSize", indent_size));
        }
        if (files.isEmpty()) {
            String error_msg = LOCALISER.msg("MetaData.Migrator.NoFiles.Error");
            System.err.println(error_msg);
            JPOXLogger.METADATA.error(error_msg);
        }
        JDOMetaDataManager mgr = new JDOMetaDataManager(new PMFContext(new PMFConfiguration(){}));
        MetaDataParser parser = new MetaDataParser(mgr, true);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            String file = (String)iter.next();
            if (verbose) {
                System.out.print(LOCALISER.msg("MetaData.Migrator.ProcessingFile", file));
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ProcessingFile", file));
                }
            }
            FileMetaData filemd = (FileMetaData)parser.parseMetaDataURL(new URL("file:" + file), "jdo");
            MetaDataMigrator.convertFileMetaData(filemd);
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                writer.write("<?xml version=\"1.0\"?>\n");
                writer.write("<!DOCTYPE jdo SYSTEM \"file:/javax/jdo/jdo.dtd\">\n");
                writer.write(filemd.toString(indent_str.toString()));
                if (JPOXLogger.METADATA.isDebugEnabled()) {
                    JPOXLogger.METADATA.debug("Written file " + file);
                }
            }
            catch (IOException ioe) {
                JPOXLogger.METADATA.error("Error writing file " + file + " : " + ioe);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            if (!verbose) continue;
            System.out.println(LOCALISER.msg("MetaData.Migrator.ProcessedFile"));
        }
        System.exit(return_code);
    }

    protected static void convertFileMetaData(FileMetaData filemd) {
        if (filemd == null) {
            return;
        }
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                cmd.setInheritanceMetaData(new InheritanceMetaData(cmd, "new-table"));
                if (cmd.hasExtension("table-name")) {
                    cmd.setTable(cmd.getValueForExtension("table-name"));
                    cmd.removeExtension("table-name");
                    if (JPOXLogger.METADATA.isDebugEnabled()) {
                        JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToAttribute", "table-name", "table"));
                    }
                }
                JPOXLogger.METADATA.info("identity-type for class is " + cmd.getIdentityType());
                if (cmd.getIdentityType() == null || cmd.getIdentityType() == IdentityType.DATASTORE) {
                    IdentityMetaData imd = null;
                    if (cmd.hasExtension("key-auto-increment")) {
                        imd = new IdentityMetaData(cmd, null, "autoincrement", null);
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "key-auto-increment", "datastore-identity"));
                        }
                    } else if (cmd.hasExtension("poid-class-generator") || cmd.hasExtension("use-poid-generator")) {
                        String poid_class = cmd.getValueForExtension("poid-class-generator");
                        if (poid_class != null) {
                            if (poid_class.equals("org.jpox.poid.SequenceTablePoidGenerator")) {
                                imd = new IdentityMetaData(cmd, null, "native", null);
                            } else if (poid_class.equals("org.jpox.poid.MaxPoidGenerator")) {
                                imd = new IdentityMetaData(cmd, null, "increment", null);
                            } else if (poid_class.equals("org.jpox.poid.OracleSequencePoidGenerator") || poid_class.equals("org.jpox.poid.PostgresqlSequencePoidGenerator") || poid_class.equals("org.jpox.poid.SAPDBSequencePoidGenerator")) {
                                String sequence = cmd.getValueForExtension("sequence-name");
                                imd = new IdentityMetaData(cmd, null, "sequence", sequence);
                            }
                        }
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "poid-class-generator", "datastore-identity"));
                        }
                    }
                    if (imd != null) {
                        cmd.setIdentityMetaData(imd);
                    }
                    if (cmd.hasExtension("key-column-name")) {
                        imd = cmd.getIdentityMetaData();
                        if (imd == null) {
                            imd = new IdentityMetaData(cmd, null, null, null);
                            cmd.setIdentityMetaData(imd);
                        }
                        imd.addColumn(new ColumnMetaData((ExtendableMetaData)imd, cmd.getValueForExtension("key-column-name")));
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "key-column-name", "datastore-identity -> column"));
                        }
                    }
                    cmd.removeExtension("key-auto-increment");
                    cmd.removeExtension("poid-class-generator");
                    cmd.removeExtension("use-poid-generator");
                    cmd.removeExtension("sequence-name");
                    cmd.removeExtension("key-column-name");
                }
                if (cmd.hasExtension("optimistic-mode") || cmd.hasExtension("optimistic-column-name")) {
                    VersionMetaData vmd = cmd.getVersionMetaData();
                    if (vmd == null) {
                        String mode_value = cmd.getValueForExtension("optimistic-mode");
                        String strategy = null;
                        if (mode_value != null) {
                            if (mode_value.toLowerCase().equals("version")) {
                                strategy = "version-number";
                            } else if (mode_value.toLowerCase().equals("timestamp")) {
                                strategy = "timestamp";
                            }
                        }
                        vmd = new VersionMetaData(strategy, cmd.getValueForExtension("optimistic-column-name"), null);
                        cmd.setVersionMetaData(vmd);
                    }
                    cmd.removeExtension("optimistic-mode");
                    cmd.removeExtension("optimistic-column-name");
                }
                for (int k = 0; k < cmd.getNoOfFields(); ++k) {
                    MapMetaData mapmd;
                    CollectionMetaData collmd;
                    AbstractPropertyMetaData fmd = cmd.getField(k);
                    ColumnMetaData[] colmds = fmd.getColumnMetaData();
                    ColumnMetaData colmd = null;
                    if (colmds != null && colmds.length > 0) {
                        colmd = colmds[0];
                    }
                    if (fmd.hasExtension("column-name")) {
                        if (colmd == null) {
                            colmd = new ColumnMetaData((ExtendableMetaData)fmd, (String)null);
                            fmd.addColumn(colmd);
                        }
                        colmd.setName(fmd.getValueForExtension("column-name"));
                        fmd.removeExtension("column-name");
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "column-name", "column -> name"));
                        }
                    }
                    if (fmd.hasExtension("length")) {
                        String length_value;
                        if (colmd == null) {
                            colmd = new ColumnMetaData((ExtendableMetaData)fmd, (String)null);
                            fmd.addColumn(colmd);
                        }
                        if ((length_value = fmd.getValueForExtension("length")).startsWith("max")) {
                            colmd.setLength(Integer.parseInt(length_value.substring(3).trim()));
                            colmd.setJdbcType("VARCHAR");
                        } else if (length_value.toLowerCase().equals("unlimited")) {
                            colmd.setJdbcType("BLOB");
                        } else {
                            colmd.setLength(Integer.parseInt(length_value));
                            colmd.setJdbcType("CHAR");
                        }
                        fmd.removeExtension("length");
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "length", "column -> length"));
                        }
                    }
                    if (fmd.hasExtension("scale")) {
                        if (colmd == null) {
                            colmd = new ColumnMetaData((ExtendableMetaData)fmd, (String)null);
                            fmd.addColumn(colmd);
                        }
                        String scale_value = fmd.getValueForExtension("scale");
                        colmd.setScale(Integer.parseInt(scale_value));
                        fmd.removeExtension("scale");
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "scale", "column -> scale"));
                        }
                    }
                    if (fmd.hasExtension("precision")) {
                        String precision_value;
                        if (colmd == null) {
                            colmd = new ColumnMetaData((ExtendableMetaData)fmd, (String)null);
                            fmd.addColumn(colmd);
                        }
                        if ((precision_value = fmd.getValueForExtension("precision")).startsWith("min")) {
                            colmd.setLength(Integer.parseInt(precision_value.substring(3).trim()));
                            colmd.setJdbcType("DECIMAL");
                        } else {
                            colmd.setLength(Integer.parseInt(precision_value));
                        }
                        fmd.removeExtension("precision");
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "precision", "column -> precision"));
                        }
                    }
                    if (fmd.hasExtension("key-auto-increment")) {
                        if (fmd.getValueForExtension("key-auto-increment").equals("true")) {
                            fmd.setValueStrategy(IdentityStrategy.IDENTITY);
                        }
                        fmd.removeExtension("key-auto-increment");
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Migrator.ChangeExtensionTagToElement", "key-auto-increment", "value-strategy"));
                        }
                    }
                    if ((collmd = fmd.getCollection()) != null) {
                        String clear_on_delete_value;
                        if (!collmd.hasExtension("owner-field")) {
                            if (fmd.getJoinMetaData() == null) {
                                fmd.setJoinMetaData(new JoinMetaData(null, null, null, null, null));
                            }
                        } else {
                            String owner_field_value = collmd.getValueForExtension("owner-field");
                            if (fmd.getMappedBy() == null) {
                                fmd.setMappedBy(owner_field_value);
                            }
                            collmd.removeExtension("owner-field");
                        }
                        if (collmd.hasExtension("table-name")) {
                            fmd.setTable(collmd.getValueForExtension("table-name"));
                            collmd.removeExtension("table-name");
                        }
                        if (collmd.hasExtension("owner-column-name")) {
                            JoinMetaData jmd = fmd.getJoinMetaData();
                            if (jmd == null) {
                                jmd = new JoinMetaData(null, null, null, null, null);
                                fmd.setJoinMetaData(jmd);
                            }
                            jmd.addColumn(new ColumnMetaData((ExtendableMetaData)jmd, collmd.getValueForExtension("owner-column-name")));
                            collmd.removeExtension("owner-column-name");
                        }
                        if (collmd.hasExtension("element-column-name")) {
                            ElementMetaData emd = fmd.getElementMetaData();
                            if (emd == null) {
                                emd = new ElementMetaData(null, null, null, null, null, null, null);
                                fmd.setElementMetaData(emd);
                            }
                            emd.addColumn(new ColumnMetaData((ExtendableMetaData)emd, collmd.getValueForExtension("element-column-name")));
                            collmd.removeExtension("element-column-name");
                        }
                        if ((clear_on_delete_value = collmd.getValueForExtension("clear-on-delete")) == null || clear_on_delete_value.equalsIgnoreCase("true")) {
                            fmd.setDependent(true);
                        } else {
                            fmd.setDependent(false);
                        }
                        collmd.removeExtension("clear-on-delete");
                    }
                    if ((mapmd = fmd.getMap()) != null) {
                        if (!mapmd.hasExtension("owner-field")) {
                            if (fmd.getJoinMetaData() == null) {
                                fmd.setJoinMetaData(new JoinMetaData(null, null, null, null, null));
                            }
                        } else {
                            String owner_field_value = mapmd.getValueForExtension("owner-field");
                            if (fmd.getMappedBy() == null) {
                                fmd.setMappedBy(owner_field_value);
                            }
                            mapmd.removeExtension("owner-field");
                        }
                    }
                    if (fmd.hasExtension("collection-field")) {
                        fmd.removeExtension("collection-field");
                    }
                    if (fmd.hasExtension("list-field")) {
                        fmd.removeExtension("list-field");
                    }
                    if (!fmd.hasExtension("map-field")) continue;
                    fmd.removeExtension("map-field");
                }
            }
        }
    }
}

