/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jdo.JDOException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.RegisterClassEvent;
import javax.jdo.spi.RegisterClassListener;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFContext;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.AnnotationManager;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataParser;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PersistenceFileMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.TableGeneratorMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;

public abstract class MetaDataManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    protected PMFContext pmfContext = null;
    protected AnnotationManager annotationManager = null;
    protected MetaDataParser metaDataParser = null;
    protected boolean validateMetaData = true;
    protected Map fileMetaDataByURLString = new HashMap();
    protected Map classMetaDataByClass = new HashMap();
    protected Map queryMetaDataByName = new HashMap();
    protected Map sequenceMetaDataByPackageSequence = new HashMap();
    protected Map tableGeneratorMetaDataByPackageSequence = new HashMap();
    protected boolean enhancing = false;
    ArrayList utilisedFileMetaData = new ArrayList();
    static /* synthetic */ Class class$org$jpox$metadata$MetaDataManager;
    static /* synthetic */ Class class$java$lang$Object;

    public MetaDataManager(PMFContext pmfContext) {
        this.pmfContext = pmfContext;
        JDOImplHelper.getInstance().removeRegisterClassListener((RegisterClassListener)new MetaDataRegisterClassListener());
        this.setValidate(pmfContext.getPmfConfiguration().getMetaDataValidate());
        if (JavaUtils.isJRE1_5OrAbove()) {
            try {
                ClassLoaderResolver clr = pmfContext.getClassLoaderResolver(null);
                Class annotationReaderClass = clr.classForName("org.jpox.metadata.annotations.AnnotationManagerImpl");
                Class[] ctrArgs = new Class[]{class$org$jpox$metadata$MetaDataManager == null ? (class$org$jpox$metadata$MetaDataManager = MetaDataManager.class$("org.jpox.metadata.MetaDataManager")) : class$org$jpox$metadata$MetaDataManager};
                Object[] ctrParams = new Object[]{this};
                Constructor ctor = annotationReaderClass.getConstructor(ctrArgs);
                this.annotationManager = (AnnotationManager)ctor.newInstance(ctrParams);
            }
            catch (Exception e) {
                JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.AnnotationManagerNotFound"));
            }
        }
    }

    public ClassMetaData newClassObject(PackageMetaData pmd, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, String entityName) {
        ClassMetaData cmd = new ClassMetaData(pmd, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table, entityName);
        return cmd;
    }

    public FieldMetaData newFieldObject(MetaData md, String name, String pk, String modifier, String defaultFetchGroup, String nullValue, String embedded, String serialized, String dependent, String mappedBy, String column, String table, String deleteAction, String indexed, String unique, String recursionDepth, String loadFetchGroup, String valueStrategy, String sequence, String fieldType) {
        FieldMetaData fmd = new FieldMetaData(md, name, pk, modifier, defaultFetchGroup, nullValue, embedded, serialized, dependent, mappedBy, column, table, deleteAction, indexed, unique, recursionDepth, loadFetchGroup, valueStrategy, sequence, fieldType);
        return fmd;
    }

    public PropertyMetaData newPropertyObject(MetaData md, String name, String pk, String modifier, String defaultFetchGroup, String nullValue, String embedded, String serialized, String dependent, String mappedBy, String column, String table, String deleteAction, String indexed, String unique, String recursionDepth, String loadFetchGroup, String valueStrategy, String sequence, String fieldType, String fieldName) {
        PropertyMetaData pmd = new PropertyMetaData(md, name, pk, modifier, defaultFetchGroup, nullValue, embedded, serialized, dependent, mappedBy, column, table, deleteAction, indexed, unique, recursionDepth, loadFetchGroup, valueStrategy, sequence, fieldType, fieldName);
        return pmd;
    }

    public void setValidate(boolean validate) {
        this.validateMetaData = validate;
    }

    public PMFContext getPMFContext() {
        return this.pmfContext;
    }

    public void close() {
        this.classMetaDataByClass.clear();
        this.queryMetaDataByName.clear();
        this.sequenceMetaDataByPackageSequence.clear();
        this.tableGeneratorMetaDataByPackageSequence.clear();
        this.fileMetaDataByURLString.clear();
        this.classMetaDataByClass = null;
        this.queryMetaDataByName = null;
        this.sequenceMetaDataByPackageSequence = null;
        this.tableGeneratorMetaDataByPackageSequence = null;
        this.fileMetaDataByURLString = null;
    }

    public boolean isEnhancing() {
        return this.enhancing;
    }

    public Collection getClassesWithMetaData() {
        return Collections.unmodifiableCollection(this.classMetaDataByClass.keySet());
    }

    public abstract boolean hasMetaDataForClass(String var1);

    protected abstract boolean isClassWithoutMetaData(String var1);

    public synchronized AbstractClassMetaData getMetaDataForClass(String className, ClassLoaderResolver clr) {
        if (className == null) {
            return null;
        }
        if (this.isClassWithoutMetaData(className)) {
            return null;
        }
        Class c = null;
        try {
            c = clr == null ? Class.forName(className) : clr.classForName(className, null, false);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (ClassNotResolvedException cnre) {
            // empty catch block
        }
        if (c == null) {
            return null;
        }
        return this.getMetaDataForClass(c, clr);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(Class c, ClassLoaderResolver clr) {
        if (c == null) {
            return null;
        }
        AbstractClassMetaData cmd = null;
        cmd = c.isInterface() ? this.getClassMetaDataForImplementationOfPersistentInterface(c.getName()) : this.getMetaDataForClassInternal(c, clr);
        if (cmd != null) {
            if (!cmd.isInitialised()) {
                cmd.initialise();
            }
            if (this.utilisedFileMetaData.size() > 0) {
                Iterator iter = this.utilisedFileMetaData.iterator();
                while (iter.hasNext()) {
                    FileMetaData filemd = (FileMetaData)iter.next();
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
            }
        }
        this.utilisedFileMetaData.clear();
        return cmd;
    }

    public synchronized AbstractClassMetaData getMetaDataForEntityName(String entityName) {
        return null;
    }

    public ClassMetaData readMetaDataForClass(String className) {
        return (ClassMetaData)this.classMetaDataByClass.get(className);
    }

    public AbstractPropertyMetaData readMetaDataForField(String className, String fieldName) {
        ClassMetaData cmd = this.readMetaDataForClass(className);
        return cmd != null ? cmd.getField(fieldName) : null;
    }

    public abstract AbstractClassMetaData getMetaDataForClassInternal(Class var1, ClassLoaderResolver var2);

    public String[] getSubclassesForClass(String className, boolean includeDescendents) {
        HashSet subclassNames = new HashSet();
        this.provideSubclassesForClass(className, includeDescendents, subclassNames);
        if (subclassNames.size() > 0) {
            return subclassNames.toArray(new String[subclassNames.size()]);
        }
        return null;
    }

    private void provideSubclassesForClass(String className, boolean includeDescendents, Collection consumer) {
        Collection cmds = this.classMetaDataByClass.values();
        Iterator cmdIter = cmds.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData cmd;
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            if (!(acmd instanceof ClassMetaData) || (cmd = (ClassMetaData)acmd).getPersistenceCapableSuperclass() == null || !cmd.getPersistenceCapableSuperclass().equals(className) || !consumer.add(cmd.getFullClassName()) || !includeDescendents) continue;
            this.provideSubclassesForClass(cmd.getFullClassName(), includeDescendents, consumer);
        }
    }

    public String[] getClassesImplementingInterface(String interfaceName, ClassLoaderResolver clr) {
        Collection cmds = this.classMetaDataByClass.values();
        Iterator cmdIter = cmds.iterator();
        HashSet classes = new HashSet();
        Class intfClass = clr.classForName(interfaceName);
        boolean isPersistentInterface = false;
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            Class implClass = clr.classForName(acmd.getFullClassName());
            if (acmd instanceof ClassMetaData) {
                if (!acmd.isInitialised()) {
                    acmd.initialise();
                }
                if (!intfClass.isAssignableFrom(implClass) || ((ClassMetaData)acmd).isAbstractPersistenceCapable()) continue;
                classes.add(implClass);
                continue;
            }
            if (!(acmd instanceof InterfaceMetaData) || !intfClass.isAssignableFrom(implClass)) continue;
            isPersistentInterface = true;
        }
        if (isPersistentInterface) {
            classes.add(this.pmfContext.getImplementationCreator().newInstance(intfClass, this, clr).getClass());
            String[] classNames = new String[classes.size()];
            Iterator iter = classes.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        if (classes.size() > 0) {
            TreeSet classesSorted = new TreeSet(new InterfaceClassComparator());
            Iterator classesIter = classes.iterator();
            while (classesIter.hasNext()) {
                classesSorted.add(classesIter.next());
            }
            String[] classNames = new String[classesSorted.size()];
            Iterator iter = classesSorted.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        return null;
    }

    public void addORMDataToClass(Class c, ClassLoaderResolver clr) {
    }

    public ClassMetaData getMetaDataForImplementationOfReference(Class referenceClass, Object implValue, ClassLoaderResolver clr) {
        if (referenceClass == null || !referenceClass.isInterface() && referenceClass != (class$java$lang$Object == null ? (class$java$lang$Object = MetaDataManager.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        ClassMetaData intfMetaData = this.getClassMetaDataForImplementationOfPersistentInterface(referenceClass.getName());
        if (intfMetaData != null) {
            return intfMetaData;
        }
        ClassMetaData cmd = null;
        Set classMetaDataClasses = this.classMetaDataByClass.keySet();
        Iterator classMetaDataClassesIter = classMetaDataClasses.iterator();
        block2: while (classMetaDataClassesIter.hasNext()) {
            String class_name = (String)classMetaDataClassesIter.next();
            AbstractClassMetaData acmd_cls = (AbstractClassMetaData)this.classMetaDataByClass.get(class_name);
            if (!(acmd_cls instanceof ClassMetaData)) continue;
            try {
                Class<?> cls = referenceClass.getClassLoader().loadClass(class_name);
                if (!referenceClass.isAssignableFrom(cls)) continue;
                cmd = (ClassMetaData)acmd_cls;
                if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) {
                    return cmd;
                }
                AbstractClassMetaData cmd_superclass = cmd.getSuperAbstractClassMetaData();
                while (cmd_superclass != null && referenceClass.isAssignableFrom(clr.classForName(((ClassMetaData)cmd_superclass).getFullClassName()))) {
                    cmd = (ClassMetaData)cmd_superclass;
                    if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) continue block2;
                    if ((cmd_superclass = cmd_superclass.getSuperAbstractClassMetaData()) != null) continue;
                }
            }
            catch (Exception e) {}
        }
        return cmd;
    }

    public AbstractPropertyMetaData getMetaDataForField(String className, String fieldName, ClassLoaderResolver clr) {
        if (className == null || fieldName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(className, clr);
        return cmd != null ? cmd.getField(fieldName) : null;
    }

    public AbstractPropertyMetaData getMetaDataForField(Class c, ClassLoaderResolver clr, String field_name) {
        if (c == null || field_name == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(c, clr);
        return cmd != null ? cmd.getField(field_name) : null;
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return (QueryMetaData)this.queryMetaDataByName.get(query_key);
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String seqName) {
        if (seqName == null) {
            return null;
        }
        return (SequenceMetaData)this.sequenceMetaDataByPackageSequence.get(seqName);
    }

    public TableGeneratorMetaData getMetaDataForTableGenerator(ClassLoaderResolver clr, String genName) {
        if (genName == null) {
            return null;
        }
        return (TableGeneratorMetaData)this.tableGeneratorMetaDataByPackageSequence.get(genName);
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        return null;
    }

    public boolean isPersistentInterface(String name) {
        return false;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        return false;
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        return null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return null;
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
    }

    public PersistenceFileMetaData[] parsePersistenceFiles() {
        HashSet<MetaData> metadata = new HashSet<MetaData>();
        try {
            Enumeration<URL> files = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            if (!files.hasMoreElements()) {
                return null;
            }
            this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
            while (files.hasMoreElements()) {
                URL fileURL = files.nextElement();
                MetaData permd = this.metaDataParser.parseMetaDataURL(fileURL, "persistence");
                metadata.add(permd);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return metadata.toArray(new PersistenceFileMetaData[metadata.size()]);
    }

    protected abstract FileMetaData parseFile(URL var1);

    protected abstract void registerFile(String var1, FileMetaData var2);

    protected void registerSequencesForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            SequenceMetaData[] seqmds = pmd.getSequences();
            if (seqmds == null) continue;
            for (int j = 0; j < seqmds.length; ++j) {
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getFullyQualifiedName(), seqmds[j]);
            }
        }
    }

    protected void registerTableGeneratorsForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            TableGeneratorMetaData[] tgmds = pmd.getTableGenerators();
            if (tgmds == null) continue;
            for (int j = 0; j < tgmds.length; ++j) {
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getFullyQualifiedName(), tgmds[j]);
            }
        }
    }

    protected void registerQueriesForFile(FileMetaData filemd) {
        int i;
        QueryMetaData[] queries = filemd.getQueries();
        if (queries != null) {
            for (i = 0; i < queries.length; ++i) {
                this.queryMetaDataByName.put(queries[i].getName(), queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryMetaData[] classQueries = cmd.getQueries();
                if (classQueries == null) continue;
                for (k = 0; k < classQueries.length; ++k) {
                    this.queryMetaDataByName.put(cmd.getFullClassName() + "_" + classQueries[k].getName(), classQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                QueryMetaData[] interfaceQueries = intfmd.getQueries();
                if (interfaceQueries == null) continue;
                for (k = 0; k < interfaceQueries.length; ++k) {
                    this.queryMetaDataByName.put(intfmd.getFullClassName() + "_" + interfaceQueries[k].getName(), interfaceQueries[k]);
                }
            }
        }
    }

    protected void populateFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            AbstractClassMetaData cmd;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                cmd = pmd.getClass(j);
                if (cmd.isPopulated() || cmd.isInitialised()) continue;
                cmd.populate(clr, primary);
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                cmd = pmd.getInterface(j);
                if (cmd.isPopulated() || cmd.isInitialised()) continue;
                cmd.populate(clr, primary);
            }
        }
    }

    protected void initialiseFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                try {
                    this.initialiseClassMetaData(cmd, clr.classForName(cmd.getFullClassName(), primary), clr);
                    continue;
                }
                catch (JDOException jdoex) {
                    throw jdoex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                try {
                    this.initialiseInterfaceMetaData(imd, clr, primary);
                    continue;
                }
                catch (JDOException jdoex) {
                    throw jdoex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseClassMetaData(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        ClassMetaData classMetaData = cmd;
        synchronized (classMetaData) {
            if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE && !ClassUtils.isPersistenceCapableClass(cls)) {
                throw new JDOUserException(LOCALISER.msg("MetaData.Class.NotEnhancedError", cls.getName()));
            }
            if (!cmd.isPopulated() && !cmd.isInitialised()) {
                cmd.populate(clr, cls.getClassLoader());
            }
            if (!cmd.isInitialised()) {
                cmd.initialise();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseInterfaceMetaData(InterfaceMetaData imd, ClassLoaderResolver clr, ClassLoader primary) {
        InterfaceMetaData interfaceMetaData = imd;
        synchronized (interfaceMetaData) {
            if (!imd.isPopulated() && !imd.isInitialised()) {
                imd.populate(clr, primary);
            }
            if (!imd.isInitialised()) {
                imd.initialise();
            }
        }
    }

    protected FileMetaData loadAnnotationsForClass(Class cls, ClassLoaderResolver clr, boolean populate) {
        if (this.annotationManager != null) {
            FileMetaData filemd = new FileMetaData(null, this, null, null);
            filemd.setType(4);
            PackageMetaData pmd = new PackageMetaData(filemd, ClassUtils.getPackageNameForClass(cls), null, null);
            filemd.addPackage(pmd);
            ClassMetaData cmd = this.annotationManager.getMetaDataForClass(cls, pmd, clr);
            if (cmd != null) {
                this.registerFile("annotations:" + cls.getName(), filemd);
                if (populate) {
                    this.populateFileMetaData(filemd, clr, cls.getClassLoader());
                }
                return filemd;
            }
        }
        return null;
    }

    public List getReferencedClassMetaData(AbstractClassMetaData cmd, String dba_vendor_id, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        ArrayList orderedCMDs = new ArrayList();
        HashSet referencedCMDs = new HashSet();
        cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        return orderedCMDs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MetaDataRegisterClassListener
    implements RegisterClassListener {
        private MetaDataRegisterClassListener() {
        }

        public void registerClass(RegisterClassEvent arg0) {
            MetaDataManager.this.getMetaDataForClassInternal(arg0.getRegisteredClass(), MetaDataManager.this.pmfContext.getClassLoaderResolver(arg0.getRegisteredClass().getClassLoader()));
        }
    }

    private class InterfaceClassComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            Class cls1 = (Class)o1;
            Class cls2 = (Class)o2;
            if (cls1.isAssignableFrom(cls2)) {
                return -1;
            }
            if (cls2.isAssignableFrom(cls2)) {
                return 1;
            }
            return 0;
        }
    }
}

