/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.List;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ContainerMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.KeyMetaData;
import org.jpox.metadata.ValueMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class MapMetaData
extends ContainerMetaData {
    protected Boolean embeddedKey;
    protected Boolean embeddedValue;
    protected Boolean serializedKey;
    protected Boolean serializedValue;
    protected String keyType = "java.lang.Object";
    protected String valueType = "java.lang.Object";
    protected AbstractClassMetaData keyClassMetaData;
    protected AbstractClassMetaData valueClassMetaData;
    protected Boolean dependentValue;
    protected Boolean dependentKey;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$lang$Object;

    public MapMetaData(AbstractPropertyMetaData parent, MapMetaData mapmd) {
        super(parent);
        this.embeddedKey = mapmd.embeddedKey;
        this.embeddedValue = mapmd.embeddedValue;
        this.serializedKey = mapmd.serializedKey;
        this.serializedValue = mapmd.serializedValue;
        this.dependentKey = mapmd.dependentKey;
        this.dependentValue = mapmd.dependentValue;
        this.keyType = mapmd.keyType;
        this.valueType = mapmd.valueType;
        this.keyClassMetaData = mapmd.keyClassMetaData;
        this.valueClassMetaData = mapmd.valueClassMetaData;
    }

    public MapMetaData(AbstractPropertyMetaData parent, String keyType, String embeddedKey, String dependentKey, String serializedKey, String valueType, String embeddedValue, String dependentValue, String serializedValue) {
        super(parent);
        if (!StringUtils.isWhitespace(keyType)) {
            this.keyType = ClassUtils.createFullClassName(parent.getAbstractClassMetaData().getPackageName(), keyType);
        }
        if (!StringUtils.isWhitespace(valueType)) {
            this.valueType = ClassUtils.createFullClassName(parent.getAbstractClassMetaData().getPackageName(), valueType);
        }
        if (embeddedKey != null) {
            if (embeddedKey.equalsIgnoreCase("true")) {
                this.embeddedKey = Boolean.TRUE;
            } else if (embeddedKey.equalsIgnoreCase("false")) {
                this.embeddedKey = Boolean.FALSE;
            }
        }
        if (embeddedValue != null) {
            if (embeddedValue.equalsIgnoreCase("true")) {
                this.embeddedValue = Boolean.TRUE;
            } else if (embeddedValue.equalsIgnoreCase("false")) {
                this.embeddedValue = Boolean.FALSE;
            }
        }
        if (dependentValue != null) {
            if (dependentValue.equalsIgnoreCase("true")) {
                this.dependentValue = Boolean.TRUE;
            } else if (dependentValue.equalsIgnoreCase("false")) {
                this.dependentValue = Boolean.FALSE;
            }
        }
        if (dependentKey != null) {
            if (dependentKey.equalsIgnoreCase("true")) {
                this.dependentKey = Boolean.TRUE;
            } else if (dependentKey.equalsIgnoreCase("false")) {
                this.dependentKey = Boolean.FALSE;
            }
        }
        if (serializedKey != null) {
            if (serializedKey.equalsIgnoreCase("true")) {
                this.serializedKey = Boolean.TRUE;
            } else if (serializedKey.equalsIgnoreCase("false")) {
                this.serializedKey = Boolean.FALSE;
            }
        }
        if (serializedValue != null) {
            if (serializedValue.equalsIgnoreCase("true")) {
                this.serializedValue = Boolean.TRUE;
            } else if (serializedValue.equalsIgnoreCase("false")) {
                this.serializedValue = Boolean.FALSE;
            }
        }
    }

    public void populate(ClassLoaderResolver clr) {
        ValueMetaData valuemd;
        KeyMetaData keymd;
        Class field_type;
        if (!(class$java$util$Map == null ? (class$java$util$Map = MapMetaData.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(field_type = this.getAbstractPropertyMetaData().getType())) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.IsNotMapError", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false));
        }
        if (this.keyType == null) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.KeyTypeNotSpecifiedError", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false));
        }
        Class keyTypeClass = null;
        try {
            keyTypeClass = clr.classForName(this.keyType);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                keyTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(this.keyType));
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.KeyTypeNotFoundError", (Object)this.getFieldName(), (Object)this.getAbstractPropertyMetaData().getClassName(false), this.keyType);
            }
        }
        if (!keyTypeClass.getName().equals(this.keyType)) {
            JPOXLogger.METADATA.info(LOCALISER.msg("MetaData.Map.KeyTypeResolved", this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false), this.keyType, keyTypeClass.getName()));
            this.keyType = keyTypeClass.getName();
        }
        if (this.embeddedKey == null) {
            this.embeddedKey = this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(keyTypeClass) ? Boolean.TRUE : ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MapMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(keyTypeClass) || (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(keyTypeClass) || keyTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.embeddedKey == Boolean.FALSE && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MapMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(keyTypeClass) && !keyTypeClass.isInterface() && keyTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.embeddedKey = Boolean.TRUE;
        }
        if ((keymd = ((AbstractPropertyMetaData)this.parent).getKeyMetaData()) != null && keymd.getEmbeddedMetaData() != null) {
            this.embeddedKey = Boolean.TRUE;
        }
        if (this.valueType == null) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.ValueTypeNotSpecifiedError", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false));
        }
        Class valueTypeClass = null;
        try {
            valueTypeClass = clr.classForName(this.valueType);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                valueTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(this.valueType));
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.ValueTypeNotFoundError", (Object)this.getFieldName(), (Object)this.getAbstractPropertyMetaData().getClassName(false), this.valueType);
            }
        }
        if (!valueTypeClass.getName().equals(this.valueType)) {
            JPOXLogger.METADATA.info(LOCALISER.msg("MetaData.Map.ValueTypeResolved", this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false), this.valueType, valueTypeClass.getName()));
            this.valueType = valueTypeClass.getName();
        }
        if (this.embeddedValue == null) {
            this.embeddedValue = this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(valueTypeClass) ? Boolean.TRUE : ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MapMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(valueTypeClass) || (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(valueTypeClass) || valueTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.embeddedValue == Boolean.FALSE && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MapMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(valueTypeClass) && !valueTypeClass.isInterface() && valueTypeClass != (class$java$lang$Object == null ? (class$java$lang$Object = MapMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.embeddedValue = Boolean.TRUE;
        }
        if ((valuemd = ((AbstractPropertyMetaData)this.parent).getValueMetaData()) != null && valuemd.getEmbeddedMetaData() != null) {
            this.embeddedValue = Boolean.TRUE;
        }
        this.keyClassMetaData = this.getAbstractPropertyMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(keyTypeClass, clr);
        this.valueClassMetaData = this.getAbstractPropertyMetaData().getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(valueTypeClass, clr);
        this.setPopulated();
    }

    public String getKeyType() {
        return this.keyType;
    }

    public AbstractClassMetaData getKeyClassMetaData() {
        if (this.keyClassMetaData != null && !this.keyClassMetaData.isInitialised()) {
            this.keyClassMetaData.initialise();
        }
        return this.keyClassMetaData;
    }

    public String getValueType() {
        return this.valueType;
    }

    public AbstractClassMetaData getValueClassMetaData() {
        if (this.valueClassMetaData != null && !this.valueClassMetaData.isInitialised()) {
            this.valueClassMetaData.initialise();
        }
        return this.valueClassMetaData;
    }

    public boolean isEmbeddedKey() {
        if (this.embeddedKey == null) {
            return false;
        }
        return this.embeddedKey;
    }

    public boolean isEmbeddedValue() {
        if (this.embeddedValue == null) {
            return false;
        }
        return this.embeddedValue;
    }

    public boolean isSerializedKey() {
        if (this.serializedKey == null) {
            return false;
        }
        return this.serializedKey;
    }

    public boolean isSerializedValue() {
        if (this.serializedValue == null) {
            return false;
        }
        return this.serializedValue;
    }

    public boolean isDependentKey() {
        if (this.dependentKey == null) {
            return false;
        }
        return this.dependentKey;
    }

    public boolean isDependentValue() {
        if (this.dependentValue == null) {
            return false;
        }
        return this.dependentValue;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData value_cmd;
        AbstractClassMetaData key_cmd = this.getMetaDataManager().getMetaDataForClass(this.keyType, clr);
        if (key_cmd != null) {
            key_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
        if ((value_cmd = this.getMetaDataManager().getMetaDataForClass(this.valueType, clr)) != null) {
            value_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<map key-type=\"").append(this.keyType).append("\" value-type=\"").append(this.valueType).append("\"");
        if (this.embeddedKey != null) {
            sb.append(" embedded-key=\"").append(this.embeddedKey).append("\"");
        }
        if (this.embeddedValue != null) {
            sb.append(" embedded-value=\"").append(this.embeddedValue).append("\"");
        }
        if (this.dependentKey != null) {
            sb.append(" dependent-key=\"").append(this.dependentKey).append("\"");
        }
        if (this.dependentValue != null) {
            sb.append(" dependent-value=\"").append(this.dependentValue).append("\"");
        }
        if (this.serializedKey != null) {
            sb.append(" serialized-key=\"").append(this.serializedKey).append("\"");
        }
        if (this.serializedValue != null) {
            sb.append(" serialized-value=\"").append(this.serializedValue).append("\"");
        }
        sb.append(">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</map>\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

