/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import javax.jdo.JDOFatalUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractElementMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.EmbeddedMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.util.ClassUtils;

public class KeyMetaData
extends AbstractElementMetaData {
    public KeyMetaData(MetaData parent, KeyMetaData kmd) {
        super(parent, kmd);
    }

    public KeyMetaData(MetaData parent, String column, String deleteAction, String updateAction, String indexed, String unique, String mappedBy) {
        super(parent, column, deleteAction, updateAction, indexed, unique, mappedBy);
    }

    public void populate(ClassLoaderResolver clr) {
        AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)this.parent;
        if (fmd.getMap() == null) {
            throw new JDOFatalUserException("The field " + fmd.getFullFieldName() + " is defined with <key>, however no <map> definition was found.");
        }
        String keyType = fmd.getMap().getKeyType();
        Class keyTypeClass = null;
        try {
            keyTypeClass = clr.classForName(keyType);
        }
        catch (ClassNotResolvedException cnre) {
            try {
                keyTypeClass = clr.classForName(ClassUtils.getJavaLangClassForType(keyType), false);
                fmd.getMap().keyType = keyTypeClass.getName();
            }
            catch (ClassNotResolvedException cnre2) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.KeyTypeNotFoundError", (Object)fmd.getFullFieldName(), (Object)fmd.getClassName(false), keyType);
            }
        }
        if (this.embeddedMetaData != null && (keyTypeClass.isInterface() || keyTypeClass.getName().equals("java.lang.Object"))) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Map.KeyTypeReferenceCannotBeEmbedded", (Object)fmd.getFullFieldName(), keyTypeClass.getName());
        }
        if (this.embeddedMetaData == null && ((AbstractPropertyMetaData)this.parent).hasMap() && ((AbstractPropertyMetaData)this.parent).getMap().isEmbeddedKey() && ((AbstractPropertyMetaData)this.parent).getJoinMetaData() != null && ((AbstractPropertyMetaData)this.parent).getMap().getKeyClassMetaData() != null) {
            this.embeddedMetaData = new EmbeddedMetaData(this, null, null, null);
        }
        super.populate(clr);
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<key");
        if (this.mappedBy != null) {
            sb.append(" mapped-by=\"" + this.mappedBy + "\"");
        }
        if (this.column != null) {
            sb.append("\n");
            sb.append(prefix).append("     column=\"" + this.column + "\"");
        }
        sb.append(">\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnMetaData colmd = (ColumnMetaData)this.columns.get(i);
            sb.append(colmd.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        if (this.embeddedMetaData != null) {
            sb.append(this.embeddedMetaData.toString(prefix + indent, indent));
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</key>\n");
        return sb.toString();
    }
}

