/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.IdentityStrategy;

public class IdentityMetaData
extends ExtendableMetaData
implements ColumnMetaDataContainer {
    protected String column;
    protected IdentityStrategy strategy = null;
    protected String sequence;
    final List columns = new ArrayList();
    protected ColumnMetaData[] columnMetaData;

    public IdentityMetaData(AbstractClassMetaData parent, String column, String strategy, String sequence) {
        super(parent);
        if (strategy != null && IdentityStrategy.getIdentityStrategy(strategy) == null) {
            throw new RuntimeException(LOCALISER.msg("MetaData.Identity.StrategyNotSpecifiedError"));
        }
        this.column = column;
        this.sequence = sequence;
        this.strategy = sequence != null && strategy == null ? IdentityStrategy.SEQUENCE : IdentityStrategy.getIdentityStrategy(strategy);
    }

    public void initialise() {
        if (this.columns.size() == 0 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData((ExtendableMetaData)this, this.column);
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (int i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.setInitialised();
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
        this.columnMetaData = new ColumnMetaData[this.columns.size()];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
        }
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public String getColumn() {
        return this.column;
    }

    public IdentityStrategy getStrategyValue() {
        return this.strategy;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        if (this.strategy != null) {
            sb.append(prefix).append("<datastore-identity strategy=\"" + this.strategy + "\"");
        } else {
            sb.append(prefix).append("<datastore-identity");
        }
        if (this.column != null) {
            sb.append("\n").append(prefix).append("        column=\"" + this.column + "\"");
        }
        if (this.sequence != null) {
            sb.append("\n").append(prefix).append("        sequence=\"" + this.sequence + "\"");
        }
        if (this.columnMetaData != null && this.columnMetaData.length > 0 || this.getNoOfExtensions() > 0) {
            sb.append(">\n");
            if (this.columnMetaData != null) {
                for (int i = 0; i < this.columnMetaData.length; ++i) {
                    sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
                }
            }
            sb.append(super.toString(prefix + indent, indent));
            sb.append(prefix).append("</datastore-identity>\n");
        } else {
            sb.append("/>\n");
        }
        return sb.toString();
    }
}

