/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.ForeignKeyAction;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PropertyMetaData;

public class ForeignKeyMetaData
extends ExtendableMetaData
implements ColumnMetaDataContainer {
    protected boolean deferred;
    protected ForeignKeyAction deleteAction;
    protected ForeignKeyAction updateAction;
    protected boolean unique;
    protected String table;
    protected String name;
    protected AbstractPropertyMetaData[] fieldMetaData;
    protected ColumnMetaData[] columnMetaData;
    protected List fields;
    protected List columns;

    public ForeignKeyMetaData(MetaData parent, ForeignKeyMetaData fkmd) {
        block8: {
            int i;
            block7: {
                int i2;
                super(parent);
                this.fields = new ArrayList();
                this.columns = new ArrayList();
                this.name = fkmd.name;
                this.table = fkmd.table;
                this.deferred = fkmd.deferred;
                this.deleteAction = fkmd.deleteAction;
                this.updateAction = fkmd.updateAction;
                this.unique = fkmd.unique;
                if (!fkmd.isInitialised()) break block7;
                if (fkmd.getFieldMetaData() != null) {
                    for (i2 = 0; i2 < fkmd.getFieldMetaData().length; ++i2) {
                        if (fkmd.getFieldMetaData()[i2] instanceof PropertyMetaData) {
                            this.addField(new PropertyMetaData((MetaData)this, (PropertyMetaData)fkmd.getFieldMetaData()[i2]));
                            continue;
                        }
                        this.addField(new FieldMetaData((MetaData)this, fkmd.getFieldMetaData()[i2]));
                    }
                }
                if (fkmd.getColumnMetaData() == null) break block8;
                for (i2 = 0; i2 < fkmd.getColumnMetaData().length; ++i2) {
                    this.addColumn(new ColumnMetaData((ExtendableMetaData)this, fkmd.getColumnMetaData()[i2]));
                }
                break block8;
            }
            for (i = 0; i < fkmd.fields.size(); ++i) {
                if (fkmd.fields.get(i) instanceof PropertyMetaData) {
                    this.addField(new PropertyMetaData((MetaData)this, (PropertyMetaData)fkmd.fields.get(i)));
                    continue;
                }
                this.addField(new FieldMetaData((MetaData)this, (AbstractPropertyMetaData)fkmd.fields.get(i)));
            }
            for (i = 0; i < fkmd.columns.size(); ++i) {
                this.addColumn(new ColumnMetaData((ExtendableMetaData)this, (ColumnMetaData)fkmd.columns.get(i)));
            }
        }
    }

    public ForeignKeyMetaData(String deferred, String delete_action, String update_action, String table, String unique, String name) {
        super(null);
        this.fields = new ArrayList();
        this.columns = new ArrayList();
        if (deferred != null) {
            if (deferred.equalsIgnoreCase("true")) {
                this.deferred = true;
            } else if (deferred.equalsIgnoreCase("false")) {
                this.deferred = false;
            }
        }
        this.deleteAction = ForeignKeyAction.getForeignKeyAction(delete_action);
        this.updateAction = ForeignKeyAction.getForeignKeyAction(update_action);
        this.table = table;
        if (unique != null) {
            if (unique.equalsIgnoreCase("true")) {
                this.unique = true;
            } else if (unique.equalsIgnoreCase("false")) {
                this.unique = false;
            }
        }
        this.name = name;
    }

    public void initialise() {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.fields.size() == 0) {
            this.fieldMetaData = null;
        } else {
            this.fieldMetaData = new AbstractPropertyMetaData[this.fields.size()];
            for (i = 0; i < this.fieldMetaData.length; ++i) {
                this.fieldMetaData[i] = (AbstractPropertyMetaData)this.fields.get(i);
                this.fieldMetaData[i].initialise();
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.columns.clear();
        this.columns = null;
        this.fields.clear();
        this.fields = null;
        this.setInitialised();
    }

    public void addField(AbstractPropertyMetaData fmd) {
        this.fields.add(fmd);
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
    }

    public final AbstractPropertyMetaData[] getFieldMetaData() {
        return this.fieldMetaData;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final boolean isDeferred() {
        return this.deferred;
    }

    public final ForeignKeyAction getDeleteAction() {
        return this.deleteAction;
    }

    public final String getName() {
        return this.name;
    }

    public final String getTable() {
        return this.table;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final ForeignKeyAction getUpdateAction() {
        return this.updateAction;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<foreign-key deferred=\"" + this.deferred + "\"\n");
        sb.append(prefix).append("       unique=\"" + this.unique + "\"");
        if (this.updateAction != null) {
            sb.append("\n").append(prefix).append("       update-action=\"" + this.updateAction + "\"");
        }
        if (this.deleteAction != null) {
            sb.append("\n").append(prefix).append("       delete-action=\"" + this.deleteAction + "\"");
        }
        if (this.table != null) {
            sb.append("\n").append(prefix).append("       table=\"" + this.table + "\"");
        }
        if (this.name != null) {
            sb.append("\n").append(prefix).append("       name=\"" + this.name + "\"");
        }
        sb.append(">\n");
        if (this.fieldMetaData != null) {
            for (i = 0; i < this.fieldMetaData.length; ++i) {
                sb.append(this.fieldMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.columnMetaData != null) {
            for (i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</foreign-key>\n");
        return sb.toString();
    }
}

