/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.Serializable;

public class DiscriminatorStrategy
implements Serializable {
    public static final DiscriminatorStrategy NONE = new DiscriminatorStrategy(0);
    public static final DiscriminatorStrategy VALUE_MAP = new DiscriminatorStrategy(1);
    public static final DiscriminatorStrategy CLASS_NAME = new DiscriminatorStrategy(2);
    private final int typeId;

    private DiscriminatorStrategy(int id) {
        this.typeId = id;
    }

    public boolean equals(Object o) {
        if (o instanceof DiscriminatorStrategy) {
            return ((DiscriminatorStrategy)o).typeId == this.typeId;
        }
        return false;
    }

    public String toString() {
        switch (this.typeId) {
            case 0: {
                return "none";
            }
            case 1: {
                return "value-map";
            }
            case 2: {
                return "class-name";
            }
        }
        return "";
    }

    public int getType() {
        return this.typeId;
    }

    public static DiscriminatorStrategy getDiscriminatorStrategy(String value) {
        if (value == null) {
            return null;
        }
        if (NONE.toString().equals(value)) {
            return NONE;
        }
        if (VALUE_MAP.toString().equals(value)) {
            return VALUE_MAP;
        }
        if (CLASS_NAME.toString().equals(value)) {
            return CLASS_NAME;
        }
        return null;
    }
}

