/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.List;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ContainerMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaDataManager;

public class ArrayMetaData
extends ContainerMetaData {
    protected String elementType;
    protected AbstractClassMetaData elementClassMetaData;
    protected Boolean embeddedElement;
    protected Boolean serializedElement;
    protected Boolean dependentElement;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$java$lang$Object;

    public ArrayMetaData(AbstractPropertyMetaData parent, ArrayMetaData arrmd) {
        super(parent);
        this.embeddedElement = arrmd.embeddedElement;
        this.serializedElement = arrmd.serializedElement;
        this.dependentElement = arrmd.dependentElement;
        this.elementType = arrmd.elementType;
        this.elementClassMetaData = arrmd.elementClassMetaData;
    }

    public ArrayMetaData(AbstractPropertyMetaData parent, String elementType, String embeddedElement, String dependentElement, String serializedElement) {
        super(parent);
        this.elementType = elementType;
        if (embeddedElement != null) {
            if (embeddedElement.equalsIgnoreCase("true")) {
                this.embeddedElement = Boolean.TRUE;
            } else if (embeddedElement.equalsIgnoreCase("false")) {
                this.embeddedElement = Boolean.FALSE;
            }
        }
        if (serializedElement != null) {
            if (serializedElement.equalsIgnoreCase("true")) {
                this.serializedElement = Boolean.TRUE;
            } else if (serializedElement.equalsIgnoreCase("false")) {
                this.serializedElement = Boolean.FALSE;
            }
        }
        if (dependentElement != null) {
            if (dependentElement.equalsIgnoreCase("true")) {
                this.dependentElement = Boolean.TRUE;
            } else if (dependentElement.equalsIgnoreCase("false")) {
                this.dependentElement = Boolean.FALSE;
            }
        }
    }

    public void populate(ClassLoaderResolver clr) {
        String arrayComponentType;
        Class<?> component_type;
        Class field_type = this.getAbstractPropertyMetaData().getType();
        if (!field_type.isArray()) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Array.IsNotArrayError", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getClassName(false));
        }
        if (this.embeddedElement == null) {
            component_type = field_type.getComponentType();
            this.embeddedElement = this.getMetaDataManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(component_type) ? Boolean.TRUE : ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ArrayMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(component_type) || (class$java$lang$Object == null ? (class$java$lang$Object = ArrayMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(component_type) || component_type.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.embeddedElement == Boolean.FALSE && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ArrayMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(component_type = field_type.getComponentType()) && !component_type.isInterface() && component_type != (class$java$lang$Object == null ? (class$java$lang$Object = ArrayMetaData.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.embeddedElement = Boolean.TRUE;
        }
        if (!(this.getAbstractPropertyMetaData().getAbstractClassMetaData().getMetaDataManager().isEnhancing() || this.getAbstractPropertyMetaData().isSerialized() || this.getAbstractPropertyMetaData().getJoinMetaData() != null || (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ArrayMetaData.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(this.getAbstractPropertyMetaData().getType().getComponentType()) || (arrayComponentType = this.getAbstractPropertyMetaData().getType().getComponentType().getName()).equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals("BigDecimal") || arrayComponentType.equals("BigInteger"))) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Array.NonPCWithoutJoin", (Object)this.getFieldName(), this.getAbstractPropertyMetaData().getType().getComponentType().getName());
        }
        MetaDataManager mmgr = this.getAbstractPropertyMetaData().getAbstractClassMetaData().getMetaDataManager();
        if (this.elementType != null) {
            Class elementCls = clr.classForName(this.elementType);
            this.elementClassMetaData = mmgr.getMetaDataForClassInternal(elementCls, clr);
        } else {
            this.elementType = field_type.getComponentType().getName();
            this.elementClassMetaData = mmgr.getMetaDataForClassInternal(field_type.getComponentType(), clr);
        }
        this.setPopulated();
    }

    public String getElementType() {
        return this.elementType;
    }

    public AbstractClassMetaData getElementClassMetaData() {
        if (this.elementClassMetaData != null && !this.elementClassMetaData.isInitialised()) {
            this.elementClassMetaData.initialise();
        }
        return this.elementClassMetaData;
    }

    public boolean isEmbeddedElement() {
        if (this.embeddedElement == null) {
            return false;
        }
        return this.embeddedElement;
    }

    public boolean isSerializedElement() {
        if (this.serializedElement == null) {
            return false;
        }
        return this.serializedElement;
    }

    public boolean isDependentElement() {
        if (this.dependentElement == null) {
            return false;
        }
        return this.dependentElement;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        AbstractClassMetaData element_cmd = this.getMetaDataManager().getMetaDataForClass(this.getAbstractPropertyMetaData().getType().getComponentType(), clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
        }
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<array");
        if (this.elementType != null) {
            sb.append(" element-type=\"").append(this.elementType).append("\"");
        }
        if (this.embeddedElement != null) {
            sb.append(" embedded-element=\"").append(this.embeddedElement).append("\"");
        }
        if (this.serializedElement != null) {
            sb.append(" serialized-element=\"").append(this.serializedElement).append("\"");
        }
        if (this.dependentElement != null) {
            sb.append(" dependent-element=\"").append(this.dependentElement).append("\"");
        }
        if (this.getNoOfExtensions() > 0) {
            sb.append(">\n");
            sb.append(super.toString(prefix + indent, indent));
            sb.append(prefix).append("</array>\n");
        } else {
            sb.append(prefix).append("/>\n");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

