/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.PMFConfiguration;
import org.jpox.PMFContext;
import org.jpox.PersistenceManager;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.store.StoreManager;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.TableInfo;
import org.jpox.util.ClassUtils;
import org.jpox.util.CommandLine;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class SchemaTool
extends PMFConfiguration {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private PMFContext pmfContext = new PMFContext(this);
    private CommandLine cmd = new CommandLine();
    private String[] defaultArgs;
    private boolean verbose;
    private boolean help;
    private String dumpDdl;
    private String mode;
    public static final int SCHEMATOOL_CREATE_MODE = 1;
    public static final int SCHEMATOOL_DELETE_MODE = 2;
    public static final int SCHEMATOOL_VALIDATE_MODE = 3;
    public static final int SCHEMATOOL_DATABASE_INFO_MODE = 4;
    public static final int SCHEMATOOL_SCHEMA_INFO_MODE = 5;
    public static final String SCHEMATOOL_OPTION_MODE = "org.jpox.schemaTool.mode";
    public static final String SCHEMATOOL_OPTION_VERBOSE = "org.jpox.schemaTool.verbose";
    public static final String SCHEMATOOL_OPTION_PROPERTIES_FILE = "org.jpox.schemaTool.propertiesFile";
    public static final String SCHEMATOOL_OPTION_DUMPDDL = "org.jpox.schemaTool.dumpDdl";
    public static final String SCHEMATOOL_OPTION_HELP = "org.jpox.schemaTool.help";

    public SchemaTool() {
        this.cmd.addOption("create", "create", null, LOCALISER.msg("SchemaTool.HelpOption.Create"));
        this.cmd.addOption("delete", "delete", null, LOCALISER.msg("SchemaTool.HelpOption.Delete"));
        this.cmd.addOption("validate", "validate", null, LOCALISER.msg("SchemaTool.HelpOption.Validate"));
        this.cmd.addOption("dbinfo", "dbinfo", null, LOCALISER.msg("SchemaTool.HelpOption.DBInfo"));
        this.cmd.addOption("schemainfo", "schemainfo", null, LOCALISER.msg("SchemaTool.HelpOption.SchemaInfo"));
        this.cmd.addOption("dumpDdl", "dumpDdl", "dumpDdl", LOCALISER.msg("SchemaTool.HelpOption.DumpDdl"));
        this.cmd.addOption("help", "help", null, LOCALISER.msg("SchemaTool.HelpOption.Help"));
        this.cmd.addOption("v", "verbose", null, "verbose output");
        this.cmd.addOption("props", "jpoxproperties", "props", "path to a properties file");
    }

    private static List getClassNamesForFileURLs(URL[] jdoFileURLs, URL[] classFileURLs) throws Exception {
        List classNames = null;
        try {
            classNames = MetaDataUtils.getInstance().getOrderedClassNamesFromFileList(jdoFileURLs, null);
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("SchemaTool.MetaDataParseError");
            JPOXLogger.SCHEMATOOL.error(msg);
            System.err.println(msg);
            JPOXLogger.SCHEMATOOL.error(e);
            throw e;
        }
        if (classFileURLs != null) {
            for (int i = 0; i < classFileURLs.length; ++i) {
                String className = ClassUtils.getClassNameForFileURL(classFileURLs[i]);
                classNames.add(className);
            }
        }
        return classNames;
    }

    public static int createSchemaTables(String[] jdoFiles, String[] classFiles, File propsFile, boolean verbose, String ddlFilename) throws Exception {
        URL[] jdoFileURLs = SchemaTool.transformFilenamesToURLs(jdoFiles);
        URL[] classFileURLs = SchemaTool.transformFilenamesToURLs(classFiles);
        return SchemaTool.createSchemaTables(jdoFileURLs, classFileURLs, propsFile, verbose, ddlFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createSchemaTables(URL[] jdoFileURLs, URL[] classFileURLs, File propsFile, boolean verbose, String ddlFilename) throws Exception {
        List classNames = SchemaTool.getClassNamesForFileURLs(jdoFileURLs, classFileURLs);
        if (classNames != null && classNames.size() > 0) {
            PersistenceManagerFactory pmf = null;
            Properties props = null;
            if (propsFile == null) {
                try {
                    props = SchemaTool.getPropertiesForDatastore(verbose);
                    String autoCreateConstraints = System.getProperty("org.jpox.autoCreateConstraints");
                    if (autoCreateConstraints != null) {
                        SchemaTool.addProperty(props, "org.jpox.autoCreateConstraints", autoCreateConstraints, verbose);
                    } else {
                        SchemaTool.addProperty(props, "org.jpox.autoCreateConstraints", "true", verbose);
                    }
                    String autoCreateColumns = System.getProperty("org.jpox.autoCreateColumns");
                    if (autoCreateColumns != null) {
                        SchemaTool.addProperty(props, "org.jpox.autoCreateColumns", autoCreateColumns, verbose);
                    } else {
                        SchemaTool.addProperty(props, "org.jpox.autoCreateColumns", "false", verbose);
                    }
                    String validateTables = System.getProperty("org.jpox.validateTables");
                    if (validateTables != null) {
                        SchemaTool.addProperty(props, "org.jpox.validateTables", validateTables, verbose);
                    } else {
                        SchemaTool.addProperty(props, "org.jpox.validateTables", "false", verbose);
                    }
                    String validateColumns = System.getProperty("org.jpox.validateColumns");
                    if (validateColumns != null) {
                        SchemaTool.addProperty(props, "org.jpox.validateColumns", validateColumns, verbose);
                    } else {
                        SchemaTool.addProperty(props, "org.jpox.validateColumns", "false", verbose);
                    }
                    String validateConstraints = System.getProperty("org.jpox.validateConstraints");
                    if (validateConstraints != null) {
                        SchemaTool.addProperty(props, "org.jpox.validateConstraints", validateConstraints, verbose);
                    }
                    SchemaTool.addProperty(props, "org.jpox.validateConstraints", "false", verbose);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(e.getMessage());
                    throw e;
                }
            } else {
                props = SchemaTool.getPropertiesFromFile(propsFile);
            }
            if (ddlFilename != null) {
                SchemaTool.addProperty(props, "org.jpox.validateConstraints", "false", verbose);
                SchemaTool.addProperty(props, "org.jpox.validateColumns", "false", verbose);
                SchemaTool.addProperty(props, "org.jpox.validateTables", "false", verbose);
            }
            SchemaTool.addProperty(props, "org.jpox.autoCreateTables", "true", false);
            SchemaTool.addProperty(props, "org.jpox.fixedDatastore", "false", false);
            SchemaTool.addProperty(props, "org.jpox.readOnlyDatastore", "false", false);
            SchemaTool.addProperty(props, "org.jpox.autoStartMechanism", "None", false);
            pmf = JDOHelper.getPersistenceManagerFactory((Map)props);
            if (verbose) {
                System.out.println("");
            }
            PersistenceManager pm = (PersistenceManager)pmf.getPersistenceManager();
            StoreManager storeMgr = pm.getStoreManager();
            OutputStreamWriter ddlFileWriter = null;
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename(ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- JPOX SchemaTool (version " + AbstractPersistenceManagerFactory.getVersionNumber() + ")" + " ran at " + fmt.format(new Date()) + "\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- Schema required for the following classes:-\n");
                Iterator classNameIter = classNames.iterator();
                while (classNameIter.hasNext()) {
                    ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                }
                ddlFileWriter.write("--\n");
            }
            try {
                String[] classNameArray = classNames.toArray(new String[classNames.size()]);
                storeMgr.addClasses(classNameArray, pm.getClassLoaderResolver(), (FileWriter)ddlFileWriter);
            }
            finally {
                if (ddlFileWriter != null) {
                    ddlFileWriter.close();
                }
            }
            return 0;
        }
        String msg = LOCALISER.msg("SchemaTool.NoClassesError");
        JPOXLogger.SCHEMATOOL.error(msg);
        System.err.println(msg);
        throw new Exception(msg);
    }

    public static int deleteSchemaTables(String[] jdoFiles, String[] classFiles, File propsFile, boolean verbose) throws Exception {
        URL[] jdoFileURLs = SchemaTool.transformFilenamesToURLs(jdoFiles);
        URL[] jdoClassFileURLs = SchemaTool.transformFilenamesToURLs(classFiles);
        return SchemaTool.deleteSchemaTables(jdoFileURLs, jdoClassFileURLs, propsFile, verbose);
    }

    public static int deleteSchemaTables(URL[] jdoFileURLs, URL[] classFileURLs, File propsFile, boolean verbose) throws Exception {
        List classNames = SchemaTool.getClassNamesForFileURLs(jdoFileURLs, classFileURLs);
        if (classNames != null && classNames.size() > 0) {
            PersistenceManagerFactory pmf = null;
            Properties props = null;
            if (propsFile == null) {
                try {
                    props = SchemaTool.getPropertiesForDatastore(verbose);
                }
                catch (Exception e) {
                    JPOXLogger.SCHEMATOOL.error(e.getMessage());
                    System.err.println(e.getMessage());
                    throw e;
                }
            } else {
                props = SchemaTool.getPropertiesFromFile(propsFile);
            }
            SchemaTool.addProperty(props, "org.jpox.fixedDatastore", "false", false);
            SchemaTool.addProperty(props, "org.jpox.readOnlyDatastore", "false", false);
            SchemaTool.addProperty(props, "org.jpox.autoStartMechanism", "None", false);
            pmf = JDOHelper.getPersistenceManagerFactory((Map)props);
            if (verbose) {
                System.out.println("");
            }
            PersistenceManager pm = (PersistenceManager)pmf.getPersistenceManager();
            StoreManager storeMgr = pm.getStoreManager();
            String[] classNameArray = classNames.toArray(new String[classNames.size()]);
            storeMgr.addClasses(classNameArray, pm.getClassLoaderResolver(), null);
            storeMgr.removeAllClasses(pm.getClassLoaderResolver());
            return 0;
        }
        String msg = LOCALISER.msg("SchemaTool.NoClassesError");
        JPOXLogger.SCHEMATOOL.info(msg);
        System.err.println(msg);
        throw new Exception(msg);
    }

    public static int validateSchemaTables(String[] jdoFiles, String[] classFiles, File propsFile, boolean verbose) throws Exception {
        URL[] jdoFileURLs = SchemaTool.transformFilenamesToURLs(jdoFiles);
        URL[] jdoClassFileURLs = SchemaTool.transformFilenamesToURLs(classFiles);
        return SchemaTool.validateSchemaTables(jdoFileURLs, jdoClassFileURLs, propsFile, verbose);
    }

    public static int validateSchemaTables(URL[] jdoFileURLs, URL[] classFileURLs, File propsFile, boolean verbose) throws Exception {
        List classNames = SchemaTool.getClassNamesForFileURLs(jdoFileURLs, classFileURLs);
        if (classNames != null && classNames.size() > 0) {
            PersistenceManagerFactory pmf = null;
            Properties props = null;
            if (propsFile == null) {
                try {
                    props = SchemaTool.getPropertiesForDatastore(verbose);
                }
                catch (Exception e) {
                    JPOXLogger.SCHEMATOOL.error(e.getMessage());
                    System.err.println(e.getMessage());
                    throw e;
                }
            } else {
                props = SchemaTool.getPropertiesFromFile(propsFile);
            }
            SchemaTool.addProperty(props, "org.jpox.validateTables", "true", verbose);
            SchemaTool.addProperty(props, "org.jpox.validateColumns", "true", verbose);
            SchemaTool.addProperty(props, "org.jpox.validateConstraints", " true", verbose);
            SchemaTool.addProperty(props, "org.jpox.autoStartMechanism", "None", false);
            pmf = JDOHelper.getPersistenceManagerFactory((Map)props);
            if (verbose) {
                System.out.println("");
            }
            PersistenceManager pm = (PersistenceManager)pmf.getPersistenceManager();
            StoreManager storeMgr = pm.getStoreManager();
            String[] classNameArray = classNames.toArray(new String[classNames.size()]);
            storeMgr.addClasses(classNameArray, pm.getClassLoaderResolver(), null);
            return 0;
        }
        String msg = LOCALISER.msg("SchemaTool.NoClassesError");
        JPOXLogger.SCHEMATOOL.error(msg);
        System.err.println(msg);
        throw new Exception(msg);
    }

    public static int outputDBInfo(File propsFile, boolean verbose) throws Exception {
        PersistenceManagerFactory pmf = null;
        Properties props = null;
        if (propsFile == null) {
            try {
                props = SchemaTool.getPropertiesForDatastore(verbose);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                throw e;
            }
        } else {
            props = SchemaTool.getPropertiesFromFile(propsFile);
        }
        SchemaTool.addProperty(props, "org.jpox.autoStartMechanism", "None", false);
        pmf = JDOHelper.getPersistenceManagerFactory((Map)props);
        if (verbose) {
            System.out.println("");
        }
        RDBMSAdapter dba = (RDBMSAdapter)((PersistenceManager)pmf.getPersistenceManager()).getStoreManager().getDatastoreAdapter();
        String msg = dba.toString();
        JPOXLogger.SCHEMATOOL.info(msg);
        System.out.println(msg);
        System.out.println();
        msg = LOCALISER.msg("SchemaTool.DatabaseTypeInfo");
        JPOXLogger.SCHEMATOOL.info(msg);
        System.out.println(msg);
        Iterator typeInfosIter = dba.iteratorTypeInfo();
        while (typeInfosIter.hasNext()) {
            Object typeInfo = typeInfosIter.next();
            JPOXLogger.SCHEMATOOL.info(typeInfo);
            System.out.println(typeInfo);
        }
        System.out.println("");
        msg = LOCALISER.msg("SchemaTool.DatabaseKeywords");
        JPOXLogger.SCHEMATOOL.info(msg);
        System.out.println(msg);
        Iterator reservedWordsIter = dba.iteratorReservedWords();
        while (reservedWordsIter.hasNext()) {
            Object words = reservedWordsIter.next();
            JPOXLogger.SCHEMATOOL.info(words);
            System.out.println(words);
        }
        System.out.println("");
        return 0;
    }

    public static int outputSchemaInfo(File propsFile, boolean verbose) throws Exception {
        PersistenceManagerFactory pmf = null;
        Properties props = null;
        if (propsFile == null) {
            try {
                props = SchemaTool.getPropertiesForDatastore(verbose);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                throw e;
            }
        } else {
            props = SchemaTool.getPropertiesFromFile(propsFile);
        }
        SchemaTool.addProperty(props, "org.jpox.autoStartMechanism", "None", false);
        pmf = JDOHelper.getPersistenceManagerFactory((Map)props);
        if (verbose) {
            System.out.println("");
        }
        RDBMSAdapter dba = (RDBMSAdapter)((PersistenceManager)pmf.getPersistenceManager()).getStoreManager().getDatastoreAdapter();
        String msg = dba.toString();
        JPOXLogger.SCHEMATOOL.info(msg);
        System.out.println(msg);
        System.out.println();
        JPOXLogger.SCHEMATOOL.info("TABLES");
        Iterator itTables = ((RDBMSManager)((PersistenceManager)pmf.getPersistenceManager()).getStoreManager()).getTableInfo(null).iterator();
        while (itTables.hasNext()) {
            TableInfo ti = (TableInfo)itTables.next();
            JPOXLogger.SCHEMATOOL.info(ti);
            System.out.println(ti);
            Iterator itColumns = ((RDBMSManager)((PersistenceManager)pmf.getPersistenceManager()).getStoreManager()).getColumnInfo(ti.getTableSchem(), ti.getTableName()).iterator();
            while (itColumns.hasNext()) {
                ColumnInfo ci = (ColumnInfo)itColumns.next();
                JPOXLogger.SCHEMATOOL.info(ci);
                System.out.println(ci);
            }
        }
        System.out.println("");
        return 0;
    }

    public static Properties getPropertiesForDatastore(boolean verbose) throws Exception {
        Properties props = new Properties();
        if (System.getProperty("javax.jdo.option.ConnectionDriverName") == null || System.getProperty("javax.jdo.option.ConnectionURL") == null) {
            File file = new File(System.getProperty("user.home") + "/.jdo/PMFProperties.properties");
            if (file.exists()) {
                props.load(new FileInputStream(file));
            } else {
                throw new Exception(LOCALISER.msg("SchemaTool.DatabaseDriverNotSpecifiedError"));
            }
        }
        if (verbose) {
            String msg = LOCALISER.msg("SchemaTool.Properties");
            JPOXLogger.SCHEMATOOL.info(msg);
            System.out.println(msg);
        }
        SchemaTool.addProperty(props, "javax.jdo.PersistenceManagerFactoryClass", "org.jpox.PersistenceManagerFactoryImpl", verbose);
        SchemaTool.addProperty(props, "javax.jdo.option.ConnectionDriverName", System.getProperty("javax.jdo.option.ConnectionDriverName"), verbose);
        SchemaTool.addProperty(props, "javax.jdo.option.ConnectionURL", System.getProperty("javax.jdo.option.ConnectionURL"), verbose);
        SchemaTool.addProperty(props, "javax.jdo.option.ConnectionUserName", System.getProperty("javax.jdo.option.ConnectionUserName"), verbose);
        SchemaTool.addProperty(props, "javax.jdo.option.ConnectionPassword", System.getProperty("javax.jdo.option.ConnectionPassword"), false);
        SchemaTool.addProperty(props, "javax.jdo.option.Mapping", System.getProperty("javax.jdo.option.Mapping"), verbose);
        return props;
    }

    public static Properties getPropertiesFromFile(File propsFile) {
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private static void addProperty(Properties props, String name, String value, boolean verbose) {
        if (name == null || value == null) {
            return;
        }
        props.setProperty(name, value);
        if (verbose) {
            String msg = LOCALISER.msg("SchemaTool.Property", name, value);
            JPOXLogger.SCHEMATOOL.info(msg);
            System.out.println(msg);
        }
    }

    public static void main(String[] args) throws Exception {
        String msg;
        SchemaTool tool = new SchemaTool();
        tool.setCommandLineArgs(args);
        if (tool.isHelp()) {
            System.out.println(LOCALISER.msg("SchemaTool.HelpTitle"));
            System.out.println(LOCALISER.msg("SchemaTool.HelpCommand"));
            System.out.println(LOCALISER.msg("SchemaTool.HelpOptions"));
            System.out.println(tool.cmd.toString());
            System.out.println(LOCALISER.msg("SchemaTool.HelpJDOFiles"));
            System.exit(0);
        }
        int mode = 1;
        if (tool.getMode() != null) {
            if (tool.getMode().equals("create")) {
                mode = 1;
                System.out.println(LOCALISER.msg("SchemaTool.Title.SchemaCreation", AbstractPersistenceManagerFactory.getVersionNumber()));
            } else if (tool.getMode().equals("delete")) {
                mode = 2;
                System.out.println(LOCALISER.msg("SchemaTool.Title.SchemaDeletion", AbstractPersistenceManagerFactory.getVersionNumber()));
            } else if (tool.getMode().equals("validate")) {
                mode = 3;
                System.out.println(LOCALISER.msg("SchemaTool.Title.SchemaValidation", AbstractPersistenceManagerFactory.getVersionNumber()));
            } else if (tool.getMode().equals("dbinfo")) {
                mode = 4;
                System.out.println(LOCALISER.msg("SchemaTool.Title.DBInfo", AbstractPersistenceManagerFactory.getVersionNumber()));
            } else if (tool.getMode().equals("schemainfo")) {
                mode = 5;
                System.out.println(LOCALISER.msg("SchemaTool.Title.SchemaInfo", AbstractPersistenceManagerFactory.getVersionNumber()));
            }
        }
        System.out.println();
        if (tool.isVerbose()) {
            msg = LOCALISER.msg("SchemaTool.Classpath");
            JPOXLogger.SCHEMATOOL.info(msg);
            System.out.println(msg);
            StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
            while (tokeniser.hasMoreTokens()) {
                String entry = LOCALISER.msg("SchemaTool.Classpath.Entry", tokeniser.nextToken());
                JPOXLogger.SCHEMATOOL.info(entry);
                System.out.println(entry);
            }
            System.out.println();
            if (tool.getPropertiesFile() != null) {
                System.out.println(LOCALISER.msg("SchemaTool.PropertyFile", tool.getPropertiesFile()));
                System.out.println();
            }
            if (tool.getDumpDdl() != null) {
                System.out.println(LOCALISER.msg("SchemaTool.OutputDDL", tool.getDumpDdl()));
                System.out.println();
            }
            System.out.println(LOCALISER.msg("SchemaTool.InputJdoFiles"));
            for (int i = 0; i < tool.getDefaultArgs().length; ++i) {
                String jdo_file = tool.getDefaultArgs()[i];
                System.out.println(">> " + jdo_file);
            }
            System.out.println();
        }
        if (mode != 5 && mode != 4 && tool.getDefaultArgs().length == 0) {
            msg = LOCALISER.msg("SchemaTool.NoMetaDataFilesError");
            JPOXLogger.SCHEMATOOL.error(msg);
            System.err.println(msg);
            System.exit(3);
        }
        String ddlFilename = tool.getDumpDdl();
        String[] inputFiles = tool.getDefaultArgs();
        String[] jdoFiles = null;
        String[] classFiles = null;
        if (inputFiles != null) {
            int i;
            int numberOfJDOFiles = 0;
            int numberOfClassFiles = 0;
            for (int i2 = 0; i2 < inputFiles.length; ++i2) {
                if (inputFiles[i2].endsWith(".class")) {
                    ++numberOfClassFiles;
                    continue;
                }
                ++numberOfJDOFiles;
            }
            jdoFiles = new String[numberOfJDOFiles];
            int num = 0;
            for (i = 0; i < inputFiles.length; ++i) {
                if (inputFiles[i].endsWith(".class")) continue;
                jdoFiles[num++] = inputFiles[i];
            }
            classFiles = new String[numberOfClassFiles];
            num = 0;
            for (i = 0; i < inputFiles.length; ++i) {
                if (!inputFiles[i].endsWith(".class")) continue;
                classFiles[num++] = inputFiles[i];
            }
        }
        int code = 0;
        try {
            if (mode == 1) {
                code = SchemaTool.createSchemaTables(jdoFiles, classFiles, tool.getPropertiesFile(), tool.isVerbose(), ddlFilename);
            } else if (mode == 2) {
                code = SchemaTool.deleteSchemaTables(jdoFiles, classFiles, tool.getPropertiesFile(), tool.isVerbose());
            } else if (mode == 3) {
                code = SchemaTool.validateSchemaTables(jdoFiles, classFiles, tool.getPropertiesFile(), tool.isVerbose());
            } else if (mode == 4) {
                code = SchemaTool.outputDBInfo(tool.getPropertiesFile(), tool.isVerbose());
            } else if (mode == 5) {
                code = SchemaTool.outputSchemaInfo(tool.getPropertiesFile(), tool.isVerbose());
            }
            if (code == 0) {
                String msg2 = LOCALISER.msg("SchemaTool.Success");
                JPOXLogger.SCHEMATOOL.info(msg2);
                System.out.println(msg2);
            }
        }
        catch (Exception e) {
            String msg3 = LOCALISER.msg("SchemaTool.Error", e.getMessage());
            System.err.println(msg3);
            JPOXLogger.SCHEMATOOL.error(msg3, e);
            code = 2;
        }
        System.exit(code);
    }

    private static URL[] transformFilenamesToURLs(String[] filenames) throws MalformedURLException {
        URL[] urls = new URL[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            urls[i] = new URL("file:" + filenames[i]);
        }
        return urls;
    }

    public void setCommandLineArgs(String[] args) {
        this.cmd.parse(args);
        this.defaultArgs = this.cmd.getDefaultArgs();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.cmd.hasOption("create")) {
            map.put(SCHEMATOOL_OPTION_MODE, "create");
        } else if (this.cmd.hasOption("delete")) {
            map.put(SCHEMATOOL_OPTION_MODE, "delete");
        } else if (this.cmd.hasOption("validate")) {
            map.put(SCHEMATOOL_OPTION_MODE, "validate");
        } else if (this.cmd.hasOption("dbinfo")) {
            map.put(SCHEMATOOL_OPTION_MODE, "dbinfo");
        } else if (this.cmd.hasOption("schemainfo")) {
            map.put(SCHEMATOOL_OPTION_MODE, "schemainfo");
        }
        if (this.cmd.hasOption("help")) {
            map.put(SCHEMATOOL_OPTION_HELP, Boolean.TRUE.toString());
        }
        if (this.cmd.hasOption("dumpDdl")) {
            map.put(SCHEMATOOL_OPTION_DUMPDDL, this.cmd.getOptionArg("dumpDdl"));
        }
        if (this.cmd.hasOption("props")) {
            map.put("org.jpox.propertiesFile", this.cmd.getOptionArg("props"));
        }
        if (this.cmd.hasOption("v")) {
            map.put(SCHEMATOOL_OPTION_VERBOSE, Boolean.TRUE.toString());
        }
        this.setOptions(map);
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String[] getDefaultArgs() {
        return this.defaultArgs;
    }

    public PMFContext getPmfContext() {
        return this.pmfContext;
    }

    public String getDumpDdl() {
        return this.dumpDdl;
    }

    public void setDumpDdl(String dumpDdl) {
        this.dumpDdl = dumpDdl;
    }

    protected Map initPropertySetters() {
        Map map = super.initPropertySetters();
        map.put(SCHEMATOOL_OPTION_DUMPDDL, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((SchemaTool)configuration).setDumpDdl(s);
            }
        });
        map.put(SCHEMATOOL_OPTION_HELP, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((SchemaTool)configuration).setHelp(Boolean.valueOf(s));
            }
        });
        map.put(SCHEMATOOL_OPTION_MODE, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((SchemaTool)configuration).setMode(s);
            }
        });
        map.put(SCHEMATOOL_OPTION_VERBOSE, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((SchemaTool)configuration).setVerbose(Boolean.valueOf(s));
            }
        });
        return map;
    }
}

