/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOFatalException;
import javax.jdo.JDOFatalUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.ImplementationCreator;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.PMFConfiguration;
import org.jpox.TypeManager;
import org.jpox.api.ApiAdapter;
import org.jpox.api.ApiAdapterFactory;
import org.jpox.management.ManagementManager;
import org.jpox.metadata.JDOMetaDataManager;
import org.jpox.metadata.JPAMetaDataManager;
import org.jpox.metadata.MetaDataManager;
import org.jpox.plugin.Extension;
import org.jpox.plugin.PluginManager;
import org.jpox.store.StoreManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class PMFContext {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private ImplementationCreator ic;
    private Map storeMgrs = new HashMap();
    private MetaDataManager metaDataManager = null;
    private final PMFConfiguration pmfConfiguration;
    private ManagementManager mgmtManager = null;
    private final PluginManager pluginManager;
    private final TypeManager typeManager;
    private ApiAdapter apiAdapter;
    private String apiName = "JDO";
    private Map classLoaderResolverMap = new HashMap();
    private String classLoaderResolverClassName = null;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$jpox$AbstractPersistenceManagerFactory;

    public PMFContext(PMFConfiguration pmfConfiguration) {
        this.pmfConfiguration = pmfConfiguration;
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver(this.getClass().getClassLoader());
        this.pluginManager = new PluginManager(this.pmfConfiguration, clr);
        this.pluginManager.registerExtensionPoints();
        this.pluginManager.registerExtensions();
        this.typeManager = new TypeManager(this.pluginManager, this.getClassLoaderResolver(null));
        ApiAdapterFactory.getInstance().initializeApiAdapterExtensions(this.getClassLoaderResolver(null), this.pluginManager);
        this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(this.apiName);
    }

    public synchronized void close() {
        Iterator it = this.storeMgrs.values().iterator();
        while (it.hasNext()) {
            ((StoreManager)it.next()).close();
        }
        this.storeMgrs.clear();
        this.storeMgrs = null;
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.mgmtManager != null) {
            this.mgmtManager.close();
            this.mgmtManager = null;
        }
        this.classLoaderResolverMap.clear();
        this.classLoaderResolverMap = null;
        this.classLoaderResolverClassName = null;
    }

    public ManagementManager getManagement() {
        if (this.mgmtManager == null) {
            this.mgmtManager = new ManagementManager(this);
        }
        return this.mgmtManager;
    }

    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String clrName = this.pmfConfiguration.getClassLoaderResolverName();
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.jpox.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new JDOFatalUserException(LOCALISER.msg("ClassLoaderResolver.PluginNotFound", clrName));
        }
        String key = this.classLoaderResolverClassName;
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if ((clr = (ClassLoaderResolver)this.classLoaderResolverMap.get(key)) == null) {
            try {
                Class<?> cls = Class.forName(this.classLoaderResolverClassName);
                Class[] ctrArgs = null;
                Object[] ctrParams = null;
                if (primaryLoader != null) {
                    ctrArgs = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PMFContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
                    ctrParams = new Object[]{primaryLoader};
                }
                Constructor<?> ctor = cls.getConstructor(ctrArgs);
                clr = (ClassLoaderResolver)ctor.newInstance(ctrParams);
            }
            catch (ClassNotFoundException cnfe) {
                throw new JDOFatalUserException(LOCALISER.msg("ClassLoaderResolver.PluginClassNotFound", this.classLoaderResolverClassName), (Throwable)cnfe);
            }
            catch (Exception e) {
                throw new JDOFatalUserException(LOCALISER.msg("ClassLoaderResolver.Error", this.classLoaderResolverClassName), (Throwable)e);
            }
            this.classLoaderResolverMap.put(key, clr);
        }
        return clr;
    }

    public ImplementationCreator getImplementationCreator() {
        if (this.ic == null) {
            try {
                Class<?> cls = null;
                if (this.pmfConfiguration.getImplementationCreatorName() != null) {
                    cls = Class.forName(this.pmfConfiguration.getImplementationCreatorName(), true, (class$org$jpox$AbstractPersistenceManagerFactory == null ? (class$org$jpox$AbstractPersistenceManagerFactory = PMFContext.class$("org.jpox.AbstractPersistenceManagerFactory")) : class$org$jpox$AbstractPersistenceManagerFactory).getClassLoader());
                    this.ic = (ImplementationCreator)cls.newInstance();
                }
                if (this.ic == null) {
                    Extension[] exts = this.getPluginManager().getExtensionPoint("org.jpox.implementation_creator").getExtensions();
                    for (int i = 0; this.ic == null && i < exts.length; ++i) {
                        for (int j = 0; this.ic == null && j < exts[i].getConfigurationElements().length; ++j) {
                            cls = Class.forName(exts[i].getConfigurationElements()[j].getAttribute("class-name"), true, (class$org$jpox$AbstractPersistenceManagerFactory == null ? PMFContext.class$("org.jpox.AbstractPersistenceManagerFactory") : class$org$jpox$AbstractPersistenceManagerFactory).getClassLoader());
                            this.ic = (ImplementationCreator)cls.newInstance();
                        }
                    }
                }
                if (JPOXLogger.GENERAL.isDebugEnabled()) {
                    if (this.ic == null) {
                        JPOXLogger.GENERAL.debug(LOCALISER.msg("PMF.ImplementationCreatorNotConfigured"));
                    } else {
                        JPOXLogger.GENERAL.debug(LOCALISER.msg("PMF.ImplementationCreatorInUse", cls.getName()));
                    }
                }
            }
            catch (InstantiationException e) {
                throw new JDOFatalException(e.toString(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new JDOFatalException(e.toString(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new JDOFatalException(LOCALISER.msg("PMF.ImplementationCreatorNotFound", this.pmfConfiguration.getImplementationCreatorName()), (Throwable)e);
            }
        }
        return this.ic;
    }

    public MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            this.metaDataManager = this.apiName.equalsIgnoreCase("JPA") ? new JPAMetaDataManager(this) : new JDOMetaDataManager(this);
        }
        return this.metaDataManager;
    }

    public Map getStoreMgrs() {
        return this.storeMgrs;
    }

    public PMFConfiguration getPmfConfiguration() {
        return this.pmfConfiguration;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    public String getApi() {
        return this.apiName;
    }

    public void setApi(String name) {
        this.apiName = name;
        ApiAdapter adapter = ApiAdapterFactory.getInstance().getApiAdapter(name);
        if (adapter != null) {
            this.apiAdapter = adapter;
        } else {
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.ApiAdapterNotFound", name));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

