/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class PMFConfiguration {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    public static final String JDO_DATASTORE_DRIVERNAME_PROPERTY = "javax.jdo.option.ConnectionDriverName";
    public static final String JDO_DATASTORE_URL_PROPERTY = "javax.jdo.option.ConnectionURL";
    public static final String JDO_DATASTORE_USERNAME_PROPERTY = "javax.jdo.option.ConnectionUserName";
    public static final String JDO_DATASTORE_PASSWORD_PROPERTY = "javax.jdo.option.ConnectionPassword";
    public static final String JDO_CONNECTION_FACTORY_NAME_PROPERTY = "javax.jdo.option.ConnectionFactoryName";
    public static final String JDO_CONNECTION_FACTORY2_NAME_PROPERTY = "javax.jdo.option.ConnectionFactory2Name";
    public static final String JDO_CONNECTION_FACTORY_PROPERTY = "javax.jdo.option.ConnectionFactory";
    public static final String JDO_CONNECTION_FACTORY2_PROPERTY = "javax.jdo.option.ConnectionFactory2";
    public static final String JDO_IGNORECACHE_PROPERTY = "javax.jdo.option.IgnoreCache";
    public static final String JDO_OPTIMISTIC_PROPERTY = "javax.jdo.option.Optimistic";
    public static final String JDO_MULTITHREADED_PROPERTY = "javax.jdo.option.Multithreaded";
    public static final String JDO_RETAINVALUES_PROPERTY = "javax.jdo.option.RetainValues";
    public static final String JDO_RESTOREVALUES_PROPERTY = "javax.jdo.option.RestoreValues";
    public static final String JDO_NONTRANSACTIONAL_READ_PROPERTY = "javax.jdo.option.NontransactionalRead";
    public static final String JDO_NONTRANSACTIONAL_WRITE_PROPERTY = "javax.jdo.option.NontransactionalWrite";
    public static final String JDO_MAPPING_PROPERTY = "javax.jdo.option.Mapping";
    public static final String JDO_MAPPING_CATALOG_PROPERTY = "javax.jdo.mapping.Catalog";
    public static final String JDO_MAPPING_SCHEMA_PROPERTY = "javax.jdo.mapping.Schema";
    public static final String JDO_DETACHALLONCOMMIT_PROPERTY = "javax.jdo.option.DetachAllOnCommit";
    public static final String JDO_TRANSACTION_TYPE_PROPERTY = "javax.jdo.option.TransactionType";
    public static final String PERSISTENCE_UNIT_NAME = "org.jpox.persistenceUnitName";
    public static final String CLASS_LOADER_RESOLVER_NAME_PROPERTY = "org.jpox.classLoaderResolverName";
    public static final String IMPLEMENTATION_CREATOR_NAME_PROPERTY = "org.jpox.implementationCreatorName";
    public static final String ATTACH_SAME_DATASTORE_PROPERTY = "org.jpox.attachSameDatastore";
    public static final String DETACH_ON_CLOSE_PROPERTY = "org.jpox.DetachOnClose";
    public static final String DATASTORE_ADAPTER_CLASSNAME_PROPERTY = "org.jpox.datastoreAdapterClassName";
    public static final String CHECK_EXIST_TABLES_VIEWS_PROPERTY = "org.jpox.rdbms.CheckExistTablesOrViews";
    public static final String STATEMENT_BATCH_LIMIT_PROPERTY = "org.jpox.rdbms.statementBatchLimit";
    public static final String VALIDATE_TABLES_PROPERTY = "org.jpox.validateTables";
    public static final String VALIDATE_COLUMNS_PROPERTY = "org.jpox.validateColumns";
    public static final String VALIDATE_CONSTRAINTS_PROPERTY = "org.jpox.validateConstraints";
    public static final String AUTO_CREATE_WARN_ON_ERROR_PROPERTY = "org.jpox.autoCreateWarnOnError";
    public static final String AUTO_CREATE_SCHEMA_PROPERTY = "org.jpox.autoCreateSchema";
    public static final String AUTO_CREATE_TABLES_PROPERTY = "org.jpox.autoCreateTables";
    public static final String AUTO_CREATE_COLUMNS_PROPERTY = "org.jpox.autoCreateColumns";
    public static final String AUTO_CREATE_CONSTRAINTS_PROPERTY = "org.jpox.autoCreateConstraints";
    public static final String INITILIAZE_PRIMARY_KEY_COLUMN_INFO = "org.jpox.initializePrimaryKeyColumnInfo";
    public static final String READ_ONLY_SCHEMA_PROPERTY = "org.jpox.readOnlySchema";
    public static final String FIXED_SCHEMA_PROPERTY = "org.jpox.fixedSchema";
    public static final String READ_ONLY_DATASTORE_PROPERTY = "org.jpox.readOnlyDatastore";
    public static final String FIXED_DATASTORE_PROPERTY = "org.jpox.fixedDatastore";
    public static final String FOREIGN_KEY_CREATE_MODE_PROPERTY = "org.jpox.foreignKeyCreateMode";
    public static final String FOREIGN_KEY_AUTO_MODE = "AUTO";
    public static final String FOREIGN_KEY_STRICT_MODE = "STRICT";
    public static final String DELETION_POLICY_PROPERTY = "org.jpox.deletionPolicy";
    public static final String TRANSACTION_ISOLATION_PROPERTY = "org.jpox.transactionIsolation";
    public static final String POID_TRANSACTION_ISOLATION_PROPERTY = "org.jpox.poid.transactionIsolation";
    public static final String POID_TRANSACTION_ATTRIBUTE_PROPERTY = "org.jpox.poid.transactionAttribute";
    public static final String AUTO_START_MECHANISM_PROPERTY = "org.jpox.autoStartMechanism";
    public static final String AUTO_START_MECHANISM_MODE_PROPERTY = "org.jpox.autoStartMechanismMode";
    public static final String AUTO_START_MECHANISM_XML_FILE_PROPERTY = "org.jpox.autoStartMechanismXmlFile";
    public static final String AUTO_START_CLASS_NAMES_PROPERTY = "org.jpox.autoStartClassNames";
    public static final String CONNECTION_POOLING_TYPE_PROPERTY = "org.jpox.connectionPoolingType";
    public static final String CONNECTION_POOLING_CONFIGURATION_FILE_PROPERTY = "org.jpox.connectionPoolingConfigurationFile";
    public static final String CACHE_LEVEL_1_TYPE_PROPERTY = "org.jpox.cache.level1.type";
    public static final String CACHE_LEVEL_2_PROPERTY = "org.jpox.cache.level2";
    public static final String CACHE_LEVEL_2_TYPE_PROPERTY = "org.jpox.cache.level2.type";
    public static final String CACHE_LEVEL_2_CACHE_NAME_PROPERTY = "org.jpox.cache.level2.cacheName";
    public static final String CACHE_LEVEL_2_CONFIGURATION_FILE_PROPERTY = "org.jpox.cache.level2.configurationFile";
    public static final String CACHE_COLLECTIONS_PROPERTY = "org.jpox.cache.collections";
    public static final String CACHE_COLLECTIONS_LAZY_PROPERTY = "org.jpox.cache.collections.lazy";
    public static final String METADATA_JDO_FILE_EXTENSION_PROPERTY = "org.jpox.metadata.jdoFileExtension";
    public static final String METADATA_ORM_FILE_EXTENSION_PROPERTY = "org.jpox.metadata.ormFileExtension";
    public static final String METADATA_JDOQUERY_FILE_EXTENSION_PROPERTY = "org.jpox.metadata.jdoqueryFileExtension";
    public static final String METADATA_VALIDATE_PROPERTY = "org.jpox.metadata.validate";
    public static final String USE_UPDATE_LOCK_PROPERTY = "org.jpox.useUpdateLock";
    public static final String DEFAULT_INHERITANCE_STRATEGY_PROPERTY = "org.jpox.rdbms.defaultInheritanceStrategy";
    public static final String DATASTORE_DELAY_OPERATIONS_UNTIL_COMMIT_PROPERTY = "org.jpox.delayDatastoreOperationsUntilCommit";
    public static final String DATASTORE_CLASS_ADDITION_MAX_RETRIES_PROPERTY = "org.jpox.store.classAdditionMaxRetries";
    public static final String ADD_UNIQUE_CONSTRAINT_MAP_INVERSE_PROPERTY = "org.jpox.rdbms.uniqueConstraints.mapInverse";
    public static final String QUERY_USE_FETCH_PLAN_PROPERTY = "org.jpox.query.useFetchPlan";
    public static final String QUERY_TIMEOUT_PROPERTY = "org.jpox.query.timeout";
    public static final String QUERY_FETCH_SIZE_PROPERTY = "org.jpox.query.fetchSize";
    public static final String QUERY_FETCH_DIRECTION_PROPERTY = "org.jpox.query.fetchDirection";
    public static final String QUERY_RESULT_SET_TYPE_PROPERTY = "org.jpox.query.resultSetType";
    public static final String QUERY_RESULT_SET_CONCURRENCY_PROPERTY = "org.jpox.query.resultSetConcurrency";
    public static final String QUERY_USE_INNER_JOINS_ONLY_PROPERTY = "org.jpox.jdoql.useInnerJoinsOnly";
    public static final String QUERY_ALLOW_ALL_SQL_STATEMENTS = "org.jpox.query.allowAllSQLStatements";
    public static final String STRING_DEFAULT_LENGTH_PROPERTY = "org.jpox.rdbms.stringDefaultLength";
    public static final String DATE_TIMEZONE_PROPERTY = "org.jpox.rdbms.dateTimezone";
    public static final String PERSISTENCE_BY_REACHABILITY_AT_COMMIT = "org.jpox.persistenceByReachabilityAtCommit";
    public static final String MAX_FETCH_DEPTH_PROPERTY = "org.jpox.maxFetchDepth";
    public static final String IDENTIFIER_FACTORY_PROPERTY = "org.jpox.identifierFactory";
    public static final String IDENTIFIER_CASE_PROPERTY = "org.jpox.identifier.case";
    public static final String IDENTIFIER_WORD_SEPARATOR_PROPERTY = "org.jpox.identifier.wordSeparator";
    public static final String IDENTIFIER_TABLE_PREFIX_PROPERTY = "org.jpox.identifier.tablePrefix";
    public static final String IDENTIFIER_TABLE_SUFFIX_PROPERTY = "org.jpox.identifier.tableSuffix";
    public static final String PROPERTIES_FILE = "org.jpox.propertiesFile";
    public static final String PLUGIN_REGISTRY_CLASS_NAME = "org.jpox.plugin.pluginRegistryClassName";
    private final Map PROPERTY_SETTERS = this.initPropertySetters();
    private transient Map options;
    private Calendar dateTimezoneCalendar = null;
    private TimeZone DATE_TIMEZONE;
    private String driverName = null;
    private String url = null;
    private String userName = null;
    private String password = null;
    private Object connectionFactory = null;
    private String connectionFactoryName = null;
    private Object connectionFactory2 = null;
    private String connectionFactory2Name = null;
    private boolean multithreaded = false;
    private boolean optimistic = false;
    private boolean retainValues = false;
    private boolean restoreValues = false;
    private boolean nontransactionalRead = false;
    private boolean nontransactionalWrite = false;
    private boolean ignoreCache = false;
    private boolean detachAllOnCommit = false;
    private String catalogName = null;
    private String schemaName = null;
    private String mapping = null;
    private String transactionType = null;
    private String persistenceUnitName = null;
    private String datastoreAdapterClassName = null;
    private boolean useUpdateLock = false;
    private boolean datastoreDelayOperationsEnabled = false;
    private int datastoreClassAdditionMaxRetries = 3;
    private boolean uniqueConstraintsMapInverse = true;
    private String defaultInheritanceStrategy = "JDO2";
    private String identifierFactory = "jpox";
    private String identifierCase = "UpperCase";
    private String identifierWordSeparator = null;
    private String identifierTablePrefix = null;
    private String identifierTableSuffix = null;
    private boolean queryUseFetchPlan = true;
    private int queryTimeout = 0;
    private int queryFetchSize = 0;
    private String queryFetchDirection = "forward";
    private String queryResultSetType = "forward-only";
    private String queryResultSetConcurrency = "read-only";
    private boolean queryAllowAllSQLStatements = false;
    private boolean queryUseInnerJoinsOnly = false;
    private static final int JDO2_STRING_DEFAULT_LENGTH = 256;
    private int stringDefaultLength = 256;
    private String dateTimezone = "UTC";
    private boolean detachOnClose = false;
    private boolean attachSameDatastore = false;
    private boolean persistenceByReachabilityAtCommit = true;
    private int maxFetchDepth = 1;
    private String classLoaderResolverName = "jdo";
    private String implementationCreatorName = null;
    private boolean checkExistTablesOrViews = true;
    private boolean validateTables = true;
    private boolean validateColumns = true;
    private boolean validateConstraints = true;
    private boolean autoCreateTables = false;
    private boolean autoCreateColumns = false;
    private boolean autoCreateConstraints = false;
    private boolean autoCreateWarnOnError = false;
    private boolean initializePrimaryKeyColumnInfo = false;
    private int statementBatchLimit = -1;
    private boolean readOnlyDatastore = false;
    private boolean fixedDatastore = false;
    private String foreignKeyCreateMode = "AUTO";
    private String deletionPolicy = "JDO2";
    private String autoStartMechanism = "SchemaTable";
    private String autoStartMechanismXmlFile = "jpoxAutoStart.xml";
    private String autoStartMechanismMode = "Quiet";
    private String autoStartClassNames = null;
    private int isolationLevel = 2;
    private int poidIsolationLevel = 2;
    private String poidTransactionAttribute = "New";
    private String persistentIdGenerator = "org.jpox.poid.DefaultIdentifierGenerator";
    private String connectionPoolingType = "None";
    private String connectionPoolingConfigurationFile = null;
    private boolean jdoCacheCollections = true;
    private Boolean jdoCacheCollectionsLazy;
    private String jdoCacheLevel1Type = "weak";
    private boolean jdoCacheLevel2 = false;
    private String jdoCacheLevel2Type = "default";
    private String jdoCacheLevel2CacheName = null;
    private String jdoCacheLevel2ConfigurationFile = null;
    private String jdoMetaDataFileExtension = "jdo";
    private String ormMetaDataFileExtension = "orm";
    private String jdoqueryMetaDataFileExtension = "jdoquery";
    private boolean metadataValidate = true;
    private File propertiesFile = null;
    private String pluginRegistryClassName = null;
    protected transient boolean configurable = true;

    public PMFConfiguration() {
        try {
            String queryFetchSizeString;
            String extension;
            String fkCreateMode;
            this.datastoreAdapterClassName = System.getProperty(DATASTORE_ADAPTER_CLASSNAME_PROPERTY);
            this.validateTables = new Boolean(System.getProperty(VALIDATE_TABLES_PROPERTY, "true"));
            this.validateColumns = new Boolean(System.getProperty(VALIDATE_COLUMNS_PROPERTY, "true"));
            this.validateConstraints = new Boolean(System.getProperty(VALIDATE_CONSTRAINTS_PROPERTY, "true"));
            this.initializePrimaryKeyColumnInfo = new Boolean(System.getProperty(INITILIAZE_PRIMARY_KEY_COLUMN_INFO, "false"));
            if (!this.validateTables) {
                this.validateColumns = false;
            }
            this.autoCreateTables = new Boolean(System.getProperty(AUTO_CREATE_TABLES_PROPERTY, "false"));
            this.autoCreateColumns = new Boolean(System.getProperty(AUTO_CREATE_COLUMNS_PROPERTY, "false"));
            this.autoCreateConstraints = new Boolean(System.getProperty(AUTO_CREATE_CONSTRAINTS_PROPERTY, "false"));
            this.setAutoCreateSchema(new Boolean(System.getProperty(AUTO_CREATE_SCHEMA_PROPERTY, "false")));
            this.autoCreateWarnOnError = new Boolean(System.getProperty(AUTO_CREATE_WARN_ON_ERROR_PROPERTY, "false"));
            boolean val = new Boolean(System.getProperty(READ_ONLY_SCHEMA_PROPERTY));
            if (val) {
                this.setReadOnlySchema(val);
            }
            if (val = new Boolean(System.getProperty(FIXED_SCHEMA_PROPERTY)).booleanValue()) {
                this.setFixedSchema(val);
            }
            this.readOnlyDatastore = new Boolean(System.getProperty(READ_ONLY_DATASTORE_PROPERTY, "false"));
            this.setReadOnlyDatastore(this.readOnlyDatastore);
            this.setFixedDatastore(new Boolean(System.getProperty(FIXED_DATASTORE_PROPERTY, "false")));
            String datastoreClassAdditionMaxRetriesString = System.getProperty(DATASTORE_CLASS_ADDITION_MAX_RETRIES_PROPERTY);
            if (datastoreClassAdditionMaxRetriesString != null) {
                try {
                    this.datastoreClassAdditionMaxRetries = new Integer(datastoreClassAdditionMaxRetriesString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this.mapping = System.getProperty(JDO_MAPPING_PROPERTY);
            this.catalogName = System.getProperty(JDO_MAPPING_CATALOG_PROPERTY);
            this.schemaName = System.getProperty(JDO_MAPPING_SCHEMA_PROPERTY);
            this.transactionType = System.getProperty(JDO_TRANSACTION_TYPE_PROPERTY);
            this.persistenceUnitName = System.getProperty(PERSISTENCE_UNIT_NAME);
            if (this.readOnlyDatastore || this.fixedDatastore) {
                if (this.autoCreateTables) {
                    JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateTables"));
                    this.autoCreateTables = false;
                }
                if (this.autoCreateColumns) {
                    JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateColumns"));
                    this.autoCreateColumns = false;
                }
                if (this.autoCreateConstraints) {
                    JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateConstraints"));
                    this.autoCreateConstraints = false;
                }
            }
            this.foreignKeyCreateMode = (fkCreateMode = System.getProperty(FOREIGN_KEY_CREATE_MODE_PROPERTY)) != null && fkCreateMode.equals(FOREIGN_KEY_AUTO_MODE) ? FOREIGN_KEY_AUTO_MODE : (fkCreateMode != null && fkCreateMode.equals(FOREIGN_KEY_STRICT_MODE) ? FOREIGN_KEY_STRICT_MODE : FOREIGN_KEY_AUTO_MODE);
            this.deletionPolicy = System.getProperty(DELETION_POLICY_PROPERTY, "JDO2");
            this.identifierFactory = System.getProperty(IDENTIFIER_FACTORY_PROPERTY, "jpox");
            this.identifierCase = System.getProperty(IDENTIFIER_CASE_PROPERTY, "UpperCase");
            if (System.getProperty(IDENTIFIER_WORD_SEPARATOR_PROPERTY) != null) {
                this.setIdentifierWordSeparator(System.getProperty(IDENTIFIER_WORD_SEPARATOR_PROPERTY));
            }
            if (System.getProperty(IDENTIFIER_TABLE_PREFIX_PROPERTY) != null) {
                this.setIdentifierTablePrefix(System.getProperty(IDENTIFIER_TABLE_PREFIX_PROPERTY));
            }
            if (System.getProperty(IDENTIFIER_TABLE_SUFFIX_PROPERTY) != null) {
                this.setIdentifierTableSuffix(System.getProperty(IDENTIFIER_TABLE_SUFFIX_PROPERTY));
            }
            this.classLoaderResolverName = System.getProperty(CLASS_LOADER_RESOLVER_NAME_PROPERTY, "jdo");
            this.connectionPoolingType = System.getProperty(CONNECTION_POOLING_TYPE_PROPERTY, "None");
            this.connectionPoolingConfigurationFile = System.getProperty(CONNECTION_POOLING_CONFIGURATION_FILE_PROPERTY);
            this.defaultInheritanceStrategy = System.getProperty(DEFAULT_INHERITANCE_STRATEGY_PROPERTY, "JDO2");
            this.autoStartMechanism = System.getProperty(AUTO_START_MECHANISM_PROPERTY, "SchemaTable");
            this.autoStartMechanismXmlFile = System.getProperty(AUTO_START_MECHANISM_XML_FILE_PROPERTY, "jpoxAutoStart.xml");
            this.autoStartMechanismMode = System.getProperty(AUTO_START_MECHANISM_MODE_PROPERTY, "Quiet");
            this.autoStartClassNames = System.getProperty(AUTO_START_CLASS_NAMES_PROPERTY);
            this.poidTransactionAttribute = System.getProperty(POID_TRANSACTION_ATTRIBUTE_PROPERTY, "New");
            if (System.getProperty(IDENTIFIER_CASE_PROPERTY) != null) {
                this.setIdentifierCase(System.getProperty(IDENTIFIER_CASE_PROPERTY));
            }
            if (!StringUtils.isWhitespace(extension = System.getProperty(METADATA_JDO_FILE_EXTENSION_PROPERTY))) {
                this.jdoMetaDataFileExtension = extension;
            }
            if (!StringUtils.isWhitespace(extension = System.getProperty(METADATA_ORM_FILE_EXTENSION_PROPERTY))) {
                this.ormMetaDataFileExtension = extension;
            }
            if (!StringUtils.isWhitespace(extension = System.getProperty(METADATA_JDOQUERY_FILE_EXTENSION_PROPERTY))) {
                this.jdoqueryMetaDataFileExtension = extension;
            }
            this.metadataValidate = new Boolean(System.getProperty(METADATA_VALIDATE_PROPERTY, "true"));
            this.jdoCacheCollections = new Boolean(System.getProperty(CACHE_COLLECTIONS_PROPERTY, "true"));
            if (System.getProperty(CACHE_COLLECTIONS_LAZY_PROPERTY) != null) {
                this.jdoCacheCollectionsLazy = new Boolean(System.getProperty(CACHE_COLLECTIONS_LAZY_PROPERTY));
            }
            this.jdoCacheLevel1Type = System.getProperty(CACHE_LEVEL_1_TYPE_PROPERTY, "weak");
            this.jdoCacheLevel2 = new Boolean(System.getProperty(CACHE_LEVEL_2_PROPERTY, "false"));
            this.jdoCacheLevel2Type = System.getProperty(CACHE_LEVEL_2_TYPE_PROPERTY, "default");
            this.jdoCacheLevel2CacheName = System.getProperty(CACHE_LEVEL_2_CACHE_NAME_PROPERTY);
            this.jdoCacheLevel2ConfigurationFile = System.getProperty(CACHE_LEVEL_2_CONFIGURATION_FILE_PROPERTY);
            this.queryUseFetchPlan = new Boolean(System.getProperty(QUERY_USE_FETCH_PLAN_PROPERTY, "true"));
            String queryTimeoutString = System.getProperty(QUERY_TIMEOUT_PROPERTY);
            if (queryTimeoutString != null) {
                try {
                    this.queryTimeout = new Integer(queryTimeoutString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((queryFetchSizeString = System.getProperty(QUERY_FETCH_SIZE_PROPERTY)) != null) {
                try {
                    this.queryFetchSize = new Integer(queryFetchSizeString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this.queryFetchDirection = System.getProperty(QUERY_FETCH_DIRECTION_PROPERTY, "forward");
            this.queryResultSetType = System.getProperty(QUERY_RESULT_SET_TYPE_PROPERTY, "forward-only");
            this.queryResultSetConcurrency = System.getProperty(QUERY_RESULT_SET_CONCURRENCY_PROPERTY, "read-only");
            this.queryAllowAllSQLStatements = new Boolean(System.getProperty(QUERY_ALLOW_ALL_SQL_STATEMENTS, "false"));
            this.queryUseInnerJoinsOnly = new Boolean(System.getProperty(QUERY_USE_INNER_JOINS_ONLY_PROPERTY, "false"));
            String stringLengthTemp = System.getProperty(STRING_DEFAULT_LENGTH_PROPERTY);
            if (stringLengthTemp != null) {
                try {
                    this.stringDefaultLength = new Integer(stringLengthTemp);
                }
                catch (NumberFormatException nfe) {
                    this.stringDefaultLength = 256;
                }
            }
            this.dateTimezone = System.getProperty(DATE_TIMEZONE_PROPERTY, "UTC");
            this.DATE_TIMEZONE = TimeZone.getTimeZone(this.dateTimezone);
            if (this.DATE_TIMEZONE == null) {
                this.DATE_TIMEZONE = TimeZone.getTimeZone("UTC");
            }
            this.setPropertiesFile(System.getProperty(PROPERTIES_FILE));
        }
        catch (Exception e) {
            JPOXLogger.GENERAL.error(e);
        }
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PMFConfiguration)) {
            return false;
        }
        PMFConfiguration pmfConfiguration = (PMFConfiguration)obj;
        boolean isEquals = true;
        isEquals &= this.equalsVariable(this.driverName, pmfConfiguration.driverName);
        isEquals &= this.equalsVariable(this.url, pmfConfiguration.url);
        isEquals &= this.equalsVariable(this.userName, pmfConfiguration.userName);
        isEquals &= this.equalsVariable(this.password, pmfConfiguration.password);
        isEquals &= this.equalsVariable(this.connectionFactory, pmfConfiguration.connectionFactory);
        isEquals &= this.equalsVariable(this.connectionFactoryName, pmfConfiguration.connectionFactoryName);
        isEquals &= this.equalsVariable(this.connectionFactory2, pmfConfiguration.connectionFactory2);
        isEquals &= this.equalsVariable(this.connectionFactory2Name, pmfConfiguration.connectionFactory2Name);
        isEquals &= this.equalsVariable(this.mapping, pmfConfiguration.mapping);
        isEquals &= this.equalsVariable(this.catalogName, pmfConfiguration.catalogName);
        isEquals &= this.equalsVariable(this.schemaName, pmfConfiguration.schemaName);
        isEquals &= this.equalsVariable(this.transactionType, pmfConfiguration.transactionType);
        isEquals &= this.equalsVariable(this.persistenceUnitName, pmfConfiguration.persistenceUnitName);
        isEquals &= this.equalsVariable(this.jdoCacheLevel1Type, pmfConfiguration.jdoCacheLevel1Type);
        isEquals &= this.equalsVariable(this.jdoCacheLevel2Type, pmfConfiguration.jdoCacheLevel2Type);
        isEquals &= this.equalsVariable(this.jdoCacheLevel2CacheName, pmfConfiguration.jdoCacheLevel2CacheName);
        isEquals &= this.equalsVariable(this.jdoCacheLevel2ConfigurationFile, pmfConfiguration.jdoCacheLevel2ConfigurationFile);
        isEquals &= this.jdoCacheLevel2 == pmfConfiguration.jdoCacheLevel2;
        isEquals &= this.jdoCacheCollections == pmfConfiguration.jdoCacheCollections;
        isEquals &= this.jdoCacheCollectionsLazy == pmfConfiguration.jdoCacheCollectionsLazy;
        isEquals &= this.equalsVariable(this.datastoreAdapterClassName, pmfConfiguration.datastoreAdapterClassName);
        isEquals &= this.equalsVariable(this.persistentIdGenerator, pmfConfiguration.persistentIdGenerator);
        isEquals &= this.equalsVariable(this.autoStartMechanism, pmfConfiguration.autoStartMechanism);
        isEquals &= this.equalsVariable(this.autoStartMechanismXmlFile, pmfConfiguration.autoStartMechanismXmlFile);
        isEquals &= this.equalsVariable(this.autoStartMechanismMode, pmfConfiguration.autoStartMechanismMode);
        isEquals &= this.equalsVariable(this.autoStartClassNames, pmfConfiguration.autoStartClassNames);
        isEquals &= this.equalsVariable(this.poidTransactionAttribute, pmfConfiguration.poidTransactionAttribute);
        isEquals &= this.checkExistTablesOrViews == pmfConfiguration.checkExistTablesOrViews;
        isEquals &= this.equalsVariable(this.defaultInheritanceStrategy, pmfConfiguration.defaultInheritanceStrategy);
        isEquals &= this.stringDefaultLength == pmfConfiguration.stringDefaultLength;
        isEquals &= this.equalsVariable(this.dateTimezone, pmfConfiguration.dateTimezone);
        isEquals &= this.statementBatchLimit == pmfConfiguration.statementBatchLimit;
        isEquals &= this.equalsVariable(this.jdoMetaDataFileExtension, pmfConfiguration.jdoMetaDataFileExtension);
        isEquals &= this.equalsVariable(this.ormMetaDataFileExtension, pmfConfiguration.ormMetaDataFileExtension);
        isEquals &= this.equalsVariable(this.jdoqueryMetaDataFileExtension, pmfConfiguration.jdoqueryMetaDataFileExtension);
        isEquals &= this.metadataValidate == pmfConfiguration.metadataValidate;
        isEquals &= this.queryUseFetchPlan == pmfConfiguration.queryUseFetchPlan;
        isEquals &= this.queryAllowAllSQLStatements == pmfConfiguration.queryAllowAllSQLStatements;
        isEquals &= this.queryTimeout == pmfConfiguration.queryTimeout;
        isEquals &= this.queryFetchSize == pmfConfiguration.queryFetchSize;
        isEquals &= this.equalsVariable(this.queryFetchDirection, pmfConfiguration.queryFetchDirection);
        isEquals &= this.equalsVariable(this.queryResultSetConcurrency, pmfConfiguration.queryResultSetConcurrency);
        isEquals &= this.equalsVariable(this.queryResultSetType, pmfConfiguration.queryResultSetType);
        isEquals &= this.queryUseInnerJoinsOnly == pmfConfiguration.queryUseInnerJoinsOnly;
        isEquals &= this.persistenceByReachabilityAtCommit == pmfConfiguration.persistenceByReachabilityAtCommit;
        isEquals &= this.maxFetchDepth == pmfConfiguration.maxFetchDepth;
        isEquals &= this.equalsVariable(this.classLoaderResolverName, pmfConfiguration.classLoaderResolverName);
        isEquals &= this.equalsVariable(this.implementationCreatorName, pmfConfiguration.implementationCreatorName);
        isEquals &= this.equalsVariable(this.connectionPoolingType, pmfConfiguration.connectionPoolingType);
        isEquals &= this.equalsVariable(this.connectionPoolingConfigurationFile, pmfConfiguration.connectionPoolingConfigurationFile);
        isEquals &= this.datastoreDelayOperationsEnabled == pmfConfiguration.datastoreDelayOperationsEnabled;
        isEquals &= this.datastoreClassAdditionMaxRetries == pmfConfiguration.datastoreClassAdditionMaxRetries;
        isEquals &= this.isolationLevel == pmfConfiguration.isolationLevel;
        isEquals &= this.poidIsolationLevel == pmfConfiguration.poidIsolationLevel;
        isEquals &= this.multithreaded == pmfConfiguration.multithreaded;
        isEquals &= this.optimistic == pmfConfiguration.optimistic;
        isEquals &= this.retainValues == pmfConfiguration.retainValues;
        isEquals &= this.restoreValues == pmfConfiguration.restoreValues;
        isEquals &= this.nontransactionalRead == pmfConfiguration.nontransactionalRead;
        isEquals &= this.nontransactionalWrite == pmfConfiguration.nontransactionalWrite;
        isEquals &= this.ignoreCache == pmfConfiguration.ignoreCache;
        isEquals &= this.detachOnClose == pmfConfiguration.detachOnClose;
        isEquals &= this.detachAllOnCommit == pmfConfiguration.detachAllOnCommit;
        isEquals &= this.attachSameDatastore == pmfConfiguration.attachSameDatastore;
        isEquals &= this.validateTables == pmfConfiguration.validateTables;
        isEquals &= this.validateColumns == pmfConfiguration.validateColumns;
        isEquals &= this.validateConstraints == pmfConfiguration.validateConstraints;
        isEquals &= this.autoCreateTables == pmfConfiguration.autoCreateTables;
        isEquals &= this.autoCreateColumns == pmfConfiguration.autoCreateColumns;
        isEquals &= this.autoCreateConstraints == pmfConfiguration.autoCreateConstraints;
        isEquals &= this.autoCreateWarnOnError == pmfConfiguration.autoCreateWarnOnError;
        isEquals &= this.initializePrimaryKeyColumnInfo == pmfConfiguration.initializePrimaryKeyColumnInfo;
        isEquals &= this.readOnlyDatastore == pmfConfiguration.readOnlyDatastore;
        isEquals &= this.fixedDatastore == pmfConfiguration.fixedDatastore;
        isEquals &= this.foreignKeyCreateMode == pmfConfiguration.foreignKeyCreateMode;
        isEquals &= this.deletionPolicy == pmfConfiguration.deletionPolicy;
        isEquals &= this.uniqueConstraintsMapInverse == pmfConfiguration.uniqueConstraintsMapInverse;
        return isEquals &= this.propertiesFile == pmfConfiguration.propertiesFile;
    }

    private boolean equalsVariable(Object var1, Object var2) {
        return !(var1 == null ? var2 != null : !var1.equals(var2));
    }

    public synchronized void setConnectionUserName(String userName) {
        this.assertConfigurable();
        this.userName = userName;
    }

    public String getConnectionUserName() {
        return this.userName;
    }

    public synchronized void setConnectionPassword(String password) {
        this.assertConfigurable();
        this.password = password;
    }

    public synchronized void setConnectionURL(String url) {
        this.assertConfigurable();
        this.url = url;
    }

    public String getConnectionURL() {
        return this.url;
    }

    public synchronized void setConnectionDriverName(String driverName) {
        this.assertConfigurable();
        this.driverName = driverName;
    }

    public String getConnectionDriverName() {
        return this.driverName;
    }

    public String getConnectionPassword() {
        return this.password;
    }

    public synchronized void setConnectionFactoryName(String connectionFactoryName) {
        this.assertConfigurable();
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public synchronized void setConnectionFactory(Object connectionFactory) {
        this.assertConfigurable();
        this.connectionFactory = connectionFactory;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public synchronized void setConnectionFactory2Name(String connectionFactoryName) {
        this.assertConfigurable();
        this.connectionFactory2Name = connectionFactoryName;
    }

    public String getConnectionFactory2Name() {
        return this.connectionFactory2Name;
    }

    public synchronized void setConnectionFactory2(Object connectionFactory) {
        this.assertConfigurable();
        this.connectionFactory2 = connectionFactory;
    }

    public Object getConnectionFactory2() {
        return this.connectionFactory2;
    }

    public synchronized void setMultithreaded(boolean flag) {
        this.assertConfigurable();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        return this.multithreaded;
    }

    public synchronized void setOptimistic(boolean flag) {
        this.assertConfigurable();
        this.optimistic = flag;
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    public synchronized void setRetainValues(boolean flag) {
        this.assertConfigurable();
        this.retainValues = flag;
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    public synchronized void setRestoreValues(boolean flag) {
        this.assertConfigurable();
        this.restoreValues = flag;
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    public synchronized void setNontransactionalRead(boolean flag) {
        this.assertConfigurable();
        this.nontransactionalRead = flag;
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public synchronized void setNontransactionalWrite(boolean flag) {
        if (flag) {
            throw new JDOUnsupportedOptionException("nontransactionalWrite is not supported by JPOX");
        }
        this.assertConfigurable();
        this.nontransactionalWrite = flag;
    }

    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    public synchronized void setIgnoreCache(boolean flag) {
        this.assertConfigurable();
        this.ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public synchronized void setDetachAllOnCommit(boolean flag) {
        this.assertConfigurable();
        this.detachAllOnCommit = flag;
    }

    public boolean getDetachAllOnCommit() {
        return this.detachAllOnCommit;
    }

    public synchronized void setMapping(String mapping) {
        this.assertConfigurable();
        this.mapping = mapping;
    }

    public String getMapping() {
        return this.mapping;
    }

    public synchronized void setCatalog(String catalog) {
        this.assertConfigurable();
        this.catalogName = catalog;
    }

    public String getCatalog() {
        return this.catalogName;
    }

    public synchronized void setSchema(String schema) {
        this.assertConfigurable();
        this.schemaName = schema;
    }

    public String getSchema() {
        return this.schemaName;
    }

    public synchronized void setTransactionType(String type) {
        this.assertConfigurable();
        if (type == null) {
            return;
        }
        if (!type.equalsIgnoreCase("JTA") && !type.equalsIgnoreCase("ResourceLocal")) {
            throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", JDO_TRANSACTION_TYPE_PROPERTY, type));
        }
        this.transactionType = type;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public synchronized void setAttachSameDatastore(boolean flag) {
        this.assertConfigurable();
        this.attachSameDatastore = flag;
    }

    public boolean getAttachSameDatastore() {
        return this.attachSameDatastore;
    }

    public synchronized void setDetachOnClose(boolean flag) {
        this.assertConfigurable();
        this.detachOnClose = flag;
    }

    public boolean getDetachOnClose() {
        return this.detachOnClose;
    }

    public synchronized void setPersistenceUnitName(String name) {
        this.assertConfigurable();
        this.persistenceUnitName = name;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public synchronized void setDatastoreAdapterClassName(String adapterClassName) {
        this.assertConfigurable();
        this.datastoreAdapterClassName = adapterClassName;
    }

    public String getDatastoreAdapterClassName() {
        return this.datastoreAdapterClassName;
    }

    public synchronized void setConnectionPoolingType(String type) {
        this.assertConfigurable();
        if (type == null) {
            type = "None";
        }
        this.connectionPoolingType = type;
    }

    public String getConnectionPoolingType() {
        return this.connectionPoolingType;
    }

    public synchronized void setConnectionPoolingConfigurationFile(String file) {
        this.assertConfigurable();
        this.connectionPoolingConfigurationFile = file;
    }

    public String getConnectionPoolingConfigurationFile() {
        return this.connectionPoolingConfigurationFile;
    }

    public synchronized void setStatementBatchLimit(int limit) {
        this.assertConfigurable();
        this.statementBatchLimit = limit;
    }

    public int getStatementBatchLimit() {
        return this.statementBatchLimit;
    }

    public synchronized void setCheckExistTablesOrViews(boolean flag) {
        this.assertConfigurable();
        this.checkExistTablesOrViews = flag;
    }

    public boolean getCheckExistTablesOrViews() {
        return this.checkExistTablesOrViews;
    }

    public synchronized void setValidateTables(boolean flag) {
        this.assertConfigurable();
        this.validateTables = flag;
        if (!this.validateTables) {
            this.setValidateColumns(false);
        }
    }

    public boolean getValidateTables() {
        return this.validateTables;
    }

    public synchronized void setInitializePrimaryKeyColumnInfo(boolean flag) {
        this.assertConfigurable();
        this.initializePrimaryKeyColumnInfo = flag;
    }

    public boolean getInitializePrimaryKeyColumnInfo() {
        return this.initializePrimaryKeyColumnInfo;
    }

    public synchronized void setValidateColumns(boolean flag) {
        this.assertConfigurable();
        this.validateColumns = flag;
    }

    public boolean getValidateColumns() {
        return this.validateColumns;
    }

    public synchronized void setValidateConstraints(boolean flag) {
        this.assertConfigurable();
        this.validateConstraints = flag;
    }

    public boolean getValidateConstraints() {
        return this.validateConstraints;
    }

    public synchronized void setReadOnlySchema(boolean flag) {
        throw new JDOUserException("org.jpox.readOnlySchema is deprecated, replaced by org.jpox.readOnlyDatastore");
    }

    public synchronized void setFixedSchema(boolean flag) {
        throw new JDOUserException("org.jpox.fixedSchema is deprecated, replaced by org.jpox.fixedDatastore");
    }

    public synchronized void setReadOnlyDatastore(boolean flag) {
        this.assertConfigurable();
        this.readOnlyDatastore = flag;
        if (flag) {
            this.setAutoCreateTables(false);
            this.setAutoCreateColumns(false);
            this.setAutoCreateConstraints(false);
        }
    }

    public boolean getReadOnlyDatastore() {
        return this.readOnlyDatastore;
    }

    public synchronized void setFixedDatastore(boolean flag) {
        this.assertConfigurable();
        this.fixedDatastore = flag;
        if (flag) {
            this.setAutoCreateTables(false);
            this.setAutoCreateColumns(false);
            this.setAutoCreateConstraints(false);
        }
    }

    public boolean getFixedDatastore() {
        return this.fixedDatastore;
    }

    public synchronized void setForeignKeyCreateMode(String mode) {
        this.assertConfigurable();
        if (mode.equals(FOREIGN_KEY_AUTO_MODE) || mode.equals(FOREIGN_KEY_STRICT_MODE)) {
            this.foreignKeyCreateMode = mode;
        }
    }

    public String getForeignKeyCreateMode() {
        return this.foreignKeyCreateMode;
    }

    public synchronized void setDeletionPolicy(String policy) {
        this.assertConfigurable();
        if (policy.equals("JPOX") || policy.equals("JDO2")) {
            this.deletionPolicy = policy;
        }
    }

    public String getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public synchronized void setIdentifierFactory(String factory) {
        this.assertConfigurable();
        this.identifierFactory = factory;
    }

    public String getIdentifierFactory() {
        return this.identifierFactory;
    }

    public synchronized void setIdentifierCase(String idCase) {
        this.assertConfigurable();
        if (idCase.equalsIgnoreCase("UpperCase") || idCase.equalsIgnoreCase("LowerCase") || idCase.equalsIgnoreCase("PreserveCase")) {
            this.identifierCase = idCase;
        }
    }

    public String getIdentifierCase() {
        return this.identifierCase;
    }

    public synchronized void setIdentifierWordSeparator(String word) {
        this.assertConfigurable();
        this.identifierWordSeparator = word;
    }

    public String getIdentifierWordSeparator() {
        return this.identifierWordSeparator;
    }

    public synchronized void setIdentifierTablePrefix(String prefix) {
        this.assertConfigurable();
        this.identifierTablePrefix = prefix;
    }

    public String getIdentifierTablePrefix() {
        return this.identifierTablePrefix;
    }

    public synchronized void setIdentifierTableSuffix(String suffix) {
        this.assertConfigurable();
        this.identifierTableSuffix = suffix;
    }

    public String getIdentifierTableSuffix() {
        return this.identifierTableSuffix;
    }

    public synchronized void setUniqueConstraintsMapInverse(boolean flag) {
        this.assertConfigurable();
        this.uniqueConstraintsMapInverse = flag;
    }

    public boolean getUniqueConstraintsMapInverse() {
        return this.uniqueConstraintsMapInverse;
    }

    public boolean getUseUpdateLock() {
        return this.useUpdateLock;
    }

    public synchronized void setUseUpdateLock(boolean flag) {
        this.assertConfigurable();
        this.useUpdateLock = flag;
    }

    public boolean getDatastoreDelayOperationsEnabled() {
        return this.datastoreDelayOperationsEnabled;
    }

    public synchronized void setDatastoreDelayOperationsEnabled(boolean flag) {
        this.assertConfigurable();
        this.datastoreDelayOperationsEnabled = flag;
    }

    public int getDatastoreClassAdditionMaxRetries() {
        return this.datastoreClassAdditionMaxRetries;
    }

    public void setDatastoreClassAdditionMaxRetries(int max) {
        this.datastoreClassAdditionMaxRetries = max;
    }

    public boolean getPersistenceByReachabilityAtCommit() {
        return this.persistenceByReachabilityAtCommit;
    }

    public synchronized void setPersistenceByReachabilityAtCommit(boolean flag) {
        this.assertConfigurable();
        this.persistenceByReachabilityAtCommit = flag;
    }

    public int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public synchronized void setMaxFetchDepth(int value) {
        this.assertConfigurable();
        this.maxFetchDepth = value;
    }

    public String getClassLoaderResolverName() {
        return this.classLoaderResolverName;
    }

    public synchronized void setClassLoaderResolverName(String clrName) {
        this.assertConfigurable();
        this.classLoaderResolverName = clrName;
    }

    public String getImplementationCreatorName() {
        return this.implementationCreatorName;
    }

    public synchronized void setImplementationCreatorName(String implCreatorName) {
        this.assertConfigurable();
        this.implementationCreatorName = implCreatorName;
    }

    public String getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    public synchronized void setDefaultInheritanceStrategy(String strategy) {
        this.assertConfigurable();
        if (strategy == null) {
            return;
        }
        if (!strategy.equalsIgnoreCase("JDO2") && !strategy.equalsIgnoreCase("JPOX")) {
            return;
        }
        this.defaultInheritanceStrategy = strategy;
    }

    public synchronized void setAutoCreateSchema(boolean flag) {
        this.assertConfigurable();
        if (flag) {
            this.setAutoCreateTables(true);
            this.setAutoCreateConstraints(true);
        }
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateSchema"));
        }
    }

    public boolean getAutoCreateSchema() {
        return this.autoCreateTables && this.autoCreateConstraints;
    }

    public synchronized void setAutoCreateTables(boolean flag) {
        this.assertConfigurable();
        this.autoCreateTables = flag;
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            this.autoCreateTables = false;
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateTables"));
        }
    }

    public boolean getAutoCreateTables() {
        return this.autoCreateTables;
    }

    public synchronized void setAutoCreateColumns(boolean flag) {
        this.assertConfigurable();
        this.autoCreateColumns = flag;
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            this.autoCreateTables = false;
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateColumns"));
        }
    }

    public boolean getAutoCreateColumns() {
        return this.autoCreateColumns;
    }

    public synchronized void setAutoCreateConstraints(boolean flag) {
        this.assertConfigurable();
        this.autoCreateConstraints = flag;
        if ((this.readOnlyDatastore || this.fixedDatastore) && flag) {
            this.autoCreateConstraints = false;
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyUnusableForSchema", "autoCreateConstraints"));
        }
    }

    public boolean getAutoCreateConstraints() {
        return this.autoCreateConstraints;
    }

    public synchronized void setAutoCreateWarnOnError(boolean flag) {
        this.assertConfigurable();
        this.autoCreateWarnOnError = flag;
    }

    public boolean getAutoCreateWarnOnError() {
        return this.autoCreateWarnOnError;
    }

    public String getAutoStartMechanism() {
        if (this.autoStartMechanism == null) {
            return "None";
        }
        return this.autoStartMechanism;
    }

    public synchronized void setAutoStartMechanism(String mechanism) {
        this.assertConfigurable();
        this.autoStartMechanism = mechanism;
    }

    public String getAutoStartMechanismXmlFile() {
        return this.autoStartMechanismXmlFile;
    }

    public synchronized void setAutoStartMechanismXmlFile(String xmlFile) {
        this.autoStartMechanismXmlFile = xmlFile;
    }

    public String getAutoStartMechanismMode() {
        if (this.autoStartMechanismMode != null && this.autoStartMechanismMode.equalsIgnoreCase("Checked")) {
            return "Checked";
        }
        if (this.autoStartMechanismMode != null && this.autoStartMechanismMode.equalsIgnoreCase("Ignored")) {
            return "Ignored";
        }
        return "Quiet";
    }

    public synchronized void setAutoStartMechanismMode(String mode) {
        this.assertConfigurable();
        if (!(mode.equals("Checked") || mode.equals("Ignored") || mode.equals("Quiet"))) {
            throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", AUTO_START_MECHANISM_MODE_PROPERTY, mode));
        }
        this.autoStartMechanismMode = mode;
    }

    public String getAutoStartClassNames() {
        return this.autoStartClassNames;
    }

    public synchronized void setAutoStartClassNames(String classNames) {
        this.autoStartClassNames = classNames;
    }

    public int getPoidTransactionIsolationLevel() {
        return this.poidIsolationLevel;
    }

    protected synchronized void setPoidTransactionIsolation(String isolationLevelName) {
        String iln = isolationLevelName.trim().replace(' ', '_').toUpperCase();
        this.poidIsolationLevel = JDBCUtils.getJDBCIsolationLevelForName(iln);
        if (this.poidIsolationLevel < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", POID_TRANSACTION_ISOLATION_PROPERTY, isolationLevelName));
        }
    }

    public synchronized void setPoidTransactionIsolation(int isolationLevel) {
        switch (isolationLevel) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", POID_TRANSACTION_ISOLATION_PROPERTY, "" + isolationLevel));
            }
        }
        this.poidIsolationLevel = isolationLevel;
    }

    public String getPoidTransactionAttribute() {
        return this.poidTransactionAttribute;
    }

    public void setPoidTransactionAttribute(String poidTransactionAttribute) {
        if (poidTransactionAttribute == null) {
            throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", POID_TRANSACTION_ATTRIBUTE_PROPERTY, poidTransactionAttribute));
        }
        if (!poidTransactionAttribute.equals("New") && !poidTransactionAttribute.equals("UsePM")) {
            throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", POID_TRANSACTION_ATTRIBUTE_PROPERTY, poidTransactionAttribute));
        }
        this.poidTransactionAttribute = poidTransactionAttribute;
    }

    public boolean getQueryUseFetchPlan() {
        return this.queryUseFetchPlan;
    }

    public void setQueryUseFetchPlan(boolean useFetchPlan) {
        this.queryUseFetchPlan = useFetchPlan;
    }

    public boolean isQueryAllowAllSQLStatements() {
        return this.queryAllowAllSQLStatements;
    }

    public void setQueryAllowAllSQLStatements(boolean allow) {
        this.queryAllowAllSQLStatements = allow;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int timeout) {
        this.queryTimeout = timeout;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setQueryFetchSize(int size) {
        this.queryFetchSize = size;
    }

    public String getQueryFetchDirection() {
        return this.queryFetchDirection;
    }

    public void setQueryFetchDirection(String dir) {
        if (!(dir != null && dir.equals("forward") && dir.equals("reverse") && dir.equals("unknown"))) {
            return;
        }
        this.queryFetchDirection = dir;
    }

    public String getQueryResultSetType() {
        return this.queryResultSetType;
    }

    public void setQueryResultSetType(String type) {
        if (type == null || !type.equals("forward-only") && !type.equals("scroll-sensitive") && !type.equals("scroll-insensitive")) {
            return;
        }
        this.queryResultSetType = type;
    }

    public String getQueryResultSetConcurrency() {
        return this.queryResultSetConcurrency;
    }

    public void setQueryResultSetConcurrency(String concur) {
        if (concur == null || !concur.equals("read-only") && !concur.equals("updateable")) {
            return;
        }
        this.queryResultSetConcurrency = concur;
    }

    public boolean getQueryUseInnerJoinsOnly() {
        return this.queryUseInnerJoinsOnly;
    }

    public void setQueryUseInnerJoinsOnly(boolean useInner) {
        this.queryUseInnerJoinsOnly = useInner;
    }

    public int getStringDefaultLength() {
        return this.stringDefaultLength;
    }

    public void setStringDefaultLength(int len) {
        this.stringDefaultLength = len;
    }

    public String getDateTimezone() {
        return this.dateTimezone;
    }

    public void setDateTimezone(String timezone) {
        this.dateTimezone = timezone;
        if (timezone != null && !timezone.equals("JDK_DEFAULT_TIMEZONE")) {
            this.DATE_TIMEZONE = TimeZone.getTimeZone(timezone);
            if (this.DATE_TIMEZONE == null) {
                this.DATE_TIMEZONE = TimeZone.getTimeZone("UTC");
            }
        }
    }

    public Calendar getCalendarForDateTimezone() {
        if (this.dateTimezoneCalendar == null && !this.dateTimezone.equals("JDK_DEFAULT_TIMEZONE")) {
            this.dateTimezoneCalendar = new GregorianCalendar(this.DATE_TIMEZONE);
        }
        return this.dateTimezoneCalendar;
    }

    public boolean getJdoCacheCollections() {
        return this.jdoCacheCollections;
    }

    public synchronized void setJdoCacheCollections(boolean cache) {
        this.assertConfigurable();
        this.jdoCacheCollections = cache;
    }

    public Boolean getJdoCacheCollectionsLazy() {
        return this.jdoCacheCollectionsLazy;
    }

    public synchronized void setJdoCacheCollectionsLazy(Boolean lazy) {
        this.assertConfigurable();
        if (lazy != null) {
            this.jdoCacheCollectionsLazy = lazy;
        }
    }

    public String getJdoCacheLevel1Type() {
        return this.jdoCacheLevel1Type;
    }

    public synchronized void setJdoCacheLevel1Type(String type) {
        this.assertConfigurable();
        this.jdoCacheLevel1Type = type;
    }

    public boolean getJdoCacheLevel2() {
        return this.jdoCacheLevel2;
    }

    public synchronized void setJdoCacheLevel2(boolean cache) {
        this.assertConfigurable();
        this.jdoCacheLevel2 = cache;
    }

    public String getJdoCacheLevel2Type() {
        return this.jdoCacheLevel2Type;
    }

    public synchronized void setJdoCacheLevel2Type(String type) {
        this.assertConfigurable();
        this.jdoCacheLevel2Type = type;
    }

    public String getJdoCacheLevel2CacheName() {
        return this.jdoCacheLevel2CacheName;
    }

    public synchronized void setJdoCacheLevel2CacheName(String name) {
        this.assertConfigurable();
        this.jdoCacheLevel2CacheName = name;
    }

    public String getJdoCacheLevel2ConfigurationFile() {
        return this.jdoCacheLevel2ConfigurationFile;
    }

    public synchronized void setJdoCacheLevel2ConfigurationFile(String confFile) {
        this.assertConfigurable();
        this.jdoCacheLevel2ConfigurationFile = confFile;
    }

    protected synchronized void setTransactionIsolation(String isolationLevelName) {
        this.assertConfigurable();
        String iln = isolationLevelName.trim().replace(' ', '_').toUpperCase();
        this.isolationLevel = JDBCUtils.getJDBCIsolationLevelForName(iln);
        if (this.isolationLevel < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", TRANSACTION_ISOLATION_PROPERTY, isolationLevelName));
        }
    }

    public synchronized void setTransactionIsolation(int isolationLevel) {
        this.assertConfigurable();
        switch (isolationLevel) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(LOCALISER.msg("PMF.PropertyValueInvalid", TRANSACTION_ISOLATION_PROPERTY, "" + isolationLevel));
            }
        }
        this.isolationLevel = isolationLevel;
    }

    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    public synchronized void setPropertiesFile(String value) {
        this.assertConfigurable();
        if (value == null) {
            return;
        }
        if (this.propertiesFile != null) {
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.PropertyFileAlreadyLoaded", this.propertiesFile, value));
            return;
        }
        Properties props = new Properties();
        File file = new File(value);
        if (file.exists()) {
            this.propertiesFile = file;
            try {
                props.load(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                this.propertiesFile = null;
                throw new JDOFatalUserException(LOCALISER.msg("PMF.PropertyFileLoadError", value), (Throwable)e);
            }
            catch (IOException e) {
                this.propertiesFile = null;
                throw new JDOFatalUserException(LOCALISER.msg("PMF.PropertyFileLoadError", value), (Throwable)e);
            }
        }
        this.setOptions(props);
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public String getJdoMetaDataFileExtension() {
        return this.jdoMetaDataFileExtension;
    }

    public void setJdoMetaDataFileExtension(String metadataFileExtension) {
        this.jdoMetaDataFileExtension = metadataFileExtension;
    }

    public String getOrmMetaDataFileExtension() {
        return this.ormMetaDataFileExtension;
    }

    public void setOrmMetaDataFileExtension(String metadataFileExtension) {
        this.ormMetaDataFileExtension = metadataFileExtension;
    }

    public String getJdoqueryMetaDataFileExtension() {
        return this.jdoqueryMetaDataFileExtension;
    }

    public void setJdoqueryMetaDataFileExtension(String metadataFileExtension) {
        this.jdoqueryMetaDataFileExtension = metadataFileExtension;
    }

    public boolean getMetaDataValidate() {
        return this.metadataValidate;
    }

    public void setMetaDataValidate(boolean validate) {
        this.metadataValidate = validate;
    }

    public String getPluginRegistryClassName() {
        return this.pluginRegistryClassName;
    }

    public void setPluginRegistryClassName(String pluginRegistryClassName) {
        this.pluginRegistryClassName = pluginRegistryClassName;
    }

    protected void assertConfigurable() {
        if (!this.configurable) {
            throw new JDOUserException(LOCALISER.msg("PMF.NotConfigurableAfterGeneration"));
        }
    }

    protected Map initPropertySetters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(JDO_OPTIMISTIC_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setOptimistic(Boolean.valueOf(s));
            }
        });
        map.put(JDO_RETAINVALUES_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setRetainValues(Boolean.valueOf(s));
            }
        });
        map.put(JDO_RESTOREVALUES_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setRestoreValues(Boolean.valueOf(s));
            }
        });
        map.put(JDO_IGNORECACHE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setIgnoreCache(Boolean.valueOf(s));
            }
        });
        map.put(JDO_DETACHALLONCOMMIT_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDetachAllOnCommit(Boolean.valueOf(s));
            }
        });
        map.put(JDO_NONTRANSACTIONAL_READ_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setNontransactionalRead(Boolean.valueOf(s));
            }
        });
        map.put(JDO_NONTRANSACTIONAL_WRITE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setNontransactionalWrite(Boolean.valueOf(s));
            }
        });
        map.put(JDO_MULTITHREADED_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setMultithreaded(Boolean.valueOf(s));
            }
        });
        map.put(JDO_DATASTORE_USERNAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionUserName(s);
            }
        });
        map.put(JDO_DATASTORE_PASSWORD_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionPassword(s);
            }
        });
        map.put(JDO_DATASTORE_DRIVERNAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionDriverName(s);
            }
        });
        map.put(JDO_DATASTORE_URL_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionURL(s);
            }
        });
        map.put(JDO_CONNECTION_FACTORY_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionFactoryName(s);
            }
        });
        map.put(JDO_CONNECTION_FACTORY2_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionFactory2Name(s);
            }
        });
        map.put(JDO_CONNECTION_FACTORY_PROPERTY, new ObjectPropertySetter(){

            public void set(PMFConfiguration configuration, Object obj) {
                configuration.setConnectionFactory(obj);
            }
        });
        map.put(JDO_CONNECTION_FACTORY2_PROPERTY, new ObjectPropertySetter(){

            public void set(PMFConfiguration configuration, Object obj) {
                configuration.setConnectionFactory2(obj);
            }
        });
        map.put(JDO_MAPPING_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setMapping(s);
            }
        });
        map.put(JDO_MAPPING_CATALOG_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setCatalog(s);
            }
        });
        map.put(JDO_MAPPING_SCHEMA_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setSchema(s);
            }
        });
        map.put(JDO_TRANSACTION_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setTransactionType(s);
            }
        });
        map.put(PERSISTENCE_UNIT_NAME, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setPersistenceUnitName(s);
            }
        });
        map.put(ATTACH_SAME_DATASTORE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAttachSameDatastore(Boolean.valueOf(s));
            }
        });
        map.put(DETACH_ON_CLOSE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDetachOnClose(Boolean.valueOf(s));
            }
        });
        map.put(DATASTORE_ADAPTER_CLASSNAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDatastoreAdapterClassName(s);
            }
        });
        map.put(STATEMENT_BATCH_LIMIT_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setStatementBatchLimit(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(CHECK_EXIST_TABLES_VIEWS_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setCheckExistTablesOrViews(Boolean.valueOf(s));
            }
        });
        map.put(VALIDATE_TABLES_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setValidateTables(Boolean.valueOf(s));
            }
        });
        map.put(VALIDATE_COLUMNS_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setValidateColumns(Boolean.valueOf(s));
            }
        });
        map.put(ADD_UNIQUE_CONSTRAINT_MAP_INVERSE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setUniqueConstraintsMapInverse(Boolean.valueOf(s));
            }
        });
        map.put(VALIDATE_CONSTRAINTS_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setValidateConstraints(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_SCHEMA_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoCreateSchema(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_TABLES_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoCreateTables(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_COLUMNS_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoCreateColumns(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_CONSTRAINTS_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoCreateConstraints(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_CREATE_WARN_ON_ERROR_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoCreateWarnOnError(Boolean.valueOf(s));
            }
        });
        map.put(INITILIAZE_PRIMARY_KEY_COLUMN_INFO, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setInitializePrimaryKeyColumnInfo(Boolean.valueOf(s));
            }
        });
        map.put(AUTO_START_MECHANISM_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoStartMechanism(s);
            }
        });
        map.put(AUTO_START_MECHANISM_XML_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoStartMechanismXmlFile(s);
            }
        });
        map.put(AUTO_START_MECHANISM_MODE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoStartMechanismMode(s);
            }
        });
        map.put(AUTO_START_CLASS_NAMES_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setAutoStartClassNames(s);
            }
        });
        map.put(READ_ONLY_SCHEMA_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setReadOnlySchema(Boolean.valueOf(s));
            }
        });
        map.put(FIXED_SCHEMA_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setFixedSchema(Boolean.valueOf(s));
            }
        });
        map.put(READ_ONLY_DATASTORE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setReadOnlyDatastore(Boolean.valueOf(s));
            }
        });
        map.put(FIXED_DATASTORE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setFixedDatastore(Boolean.valueOf(s));
            }
        });
        map.put(FOREIGN_KEY_CREATE_MODE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setForeignKeyCreateMode(s);
            }
        });
        map.put(DELETION_POLICY_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDeletionPolicy(s);
            }
        });
        map.put(IDENTIFIER_FACTORY_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setIdentifierFactory(s);
            }
        });
        map.put(IDENTIFIER_CASE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setIdentifierCase(s);
            }
        });
        map.put(IDENTIFIER_WORD_SEPARATOR_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setIdentifierWordSeparator(s);
            }
        });
        map.put(IDENTIFIER_TABLE_PREFIX_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setIdentifierTablePrefix(s);
            }
        });
        map.put(IDENTIFIER_TABLE_SUFFIX_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setIdentifierTableSuffix(s);
            }
        });
        map.put(CONNECTION_POOLING_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionPoolingType(s);
            }
        });
        map.put(CONNECTION_POOLING_CONFIGURATION_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setConnectionPoolingConfigurationFile(s);
            }
        });
        map.put(DEFAULT_INHERITANCE_STRATEGY_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDefaultInheritanceStrategy(s);
            }
        });
        map.put(USE_UPDATE_LOCK_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setUseUpdateLock(Boolean.valueOf(s));
            }
        });
        map.put(DATASTORE_DELAY_OPERATIONS_UNTIL_COMMIT_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDatastoreDelayOperationsEnabled(Boolean.valueOf(s));
            }
        });
        map.put(DATASTORE_CLASS_ADDITION_MAX_RETRIES_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setDatastoreClassAdditionMaxRetries(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(TRANSACTION_ISOLATION_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setTransactionIsolation(s);
            }
        });
        map.put(POID_TRANSACTION_ATTRIBUTE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setPoidTransactionAttribute(s);
            }
        });
        map.put(POID_TRANSACTION_ISOLATION_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setPoidTransactionIsolation(s);
            }
        });
        map.put(PERSISTENCE_BY_REACHABILITY_AT_COMMIT, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setPersistenceByReachabilityAtCommit(Boolean.valueOf(s));
            }
        });
        map.put(MAX_FETCH_DEPTH_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setMaxFetchDepth(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(CLASS_LOADER_RESOLVER_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setClassLoaderResolverName(s);
            }
        });
        map.put(IMPLEMENTATION_CREATOR_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setImplementationCreatorName(s);
            }
        });
        map.put(QUERY_USE_FETCH_PLAN_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    boolean use = new Boolean(s);
                    configuration.setQueryUseFetchPlan(use);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_TIMEOUT_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setQueryTimeout(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_FETCH_SIZE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setQueryFetchSize(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(QUERY_FETCH_DIRECTION_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setQueryFetchDirection(s);
            }
        });
        map.put(QUERY_RESULT_SET_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setQueryResultSetType(s);
            }
        });
        map.put(QUERY_RESULT_SET_CONCURRENCY_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setQueryResultSetConcurrency(s);
            }
        });
        map.put(QUERY_USE_INNER_JOINS_ONLY_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setQueryUseInnerJoinsOnly(Boolean.valueOf(s));
            }
        });
        map.put(QUERY_ALLOW_ALL_SQL_STATEMENTS, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    boolean allow = new Boolean(s);
                    configuration.setQueryAllowAllSQLStatements(allow);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(STRING_DEFAULT_LENGTH_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                try {
                    int len = new Integer(s);
                    configuration.setStringDefaultLength(len);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        map.put(DATE_TIMEZONE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setDateTimezone(s);
            }
        });
        map.put(CACHE_COLLECTIONS_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoCacheCollections(Boolean.valueOf(s));
            }
        });
        map.put(CACHE_COLLECTIONS_LAZY_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                boolean lazy = Boolean.valueOf(s);
                if (lazy) {
                    configuration.setJdoCacheCollectionsLazy(Boolean.TRUE);
                } else {
                    configuration.setJdoCacheCollectionsLazy(Boolean.FALSE);
                }
            }
        });
        map.put(CACHE_LEVEL_1_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoCacheLevel1Type(s);
            }
        });
        map.put(CACHE_LEVEL_2_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoCacheLevel2(Boolean.valueOf(s));
            }
        });
        map.put(CACHE_LEVEL_2_TYPE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoCacheLevel2Type(s);
            }
        });
        map.put(CACHE_LEVEL_2_CACHE_NAME_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoCacheLevel2CacheName(s);
            }
        });
        map.put(CACHE_LEVEL_2_CONFIGURATION_FILE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoCacheLevel2ConfigurationFile(s);
            }
        });
        map.put(METADATA_JDO_FILE_EXTENSION_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoMetaDataFileExtension(s);
            }
        });
        map.put(METADATA_ORM_FILE_EXTENSION_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setOrmMetaDataFileExtension(s);
            }
        });
        map.put(METADATA_JDOQUERY_FILE_EXTENSION_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setJdoqueryMetaDataFileExtension(s);
            }
        });
        map.put(METADATA_VALIDATE_PROPERTY, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setMetaDataValidate(Boolean.valueOf(s));
            }
        });
        map.put(PROPERTIES_FILE, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setPropertiesFile(s);
            }
        });
        map.put(PLUGIN_REGISTRY_CLASS_NAME, new StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                configuration.setPluginRegistryClassName(s);
            }
        });
        return map;
    }

    protected void setOptions(Properties props) {
        this.options = props;
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            StringPropertySetter setter = (StringPropertySetter)this.PROPERTY_SETTERS.get(prop);
            if (prop != null && setter != null) {
                String value = props.getProperty(prop);
                setter.set(this, value);
                continue;
            }
            if (prop == null || setter != null || prop.equals("javax.jdo.PersistenceManagerFactoryClass")) continue;
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.UnknownProperty", prop));
        }
    }

    protected void setOptions(Map props) {
        this.options = props;
        Set keys = props.keySet();
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            Object setter;
            Object keyObj = keyIter.next();
            if (!(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            Object valueObj = props.get(keyObj);
            if (valueObj instanceof String) {
                setter = (StringPropertySetter)this.PROPERTY_SETTERS.get(key);
                if (key != null && setter != null) {
                    setter.set(this, (String)valueObj);
                    continue;
                }
                if (key == null || setter != null || key.equals("javax.jdo.PersistenceManagerFactoryClass")) continue;
                JPOXLogger.JDO.warn(LOCALISER.msg("PMF.UnknownProperty", key));
                continue;
            }
            setter = (ObjectPropertySetter)this.PROPERTY_SETTERS.get(key);
            if (key != null && setter != null) {
                setter.set(this, valueObj);
                continue;
            }
            if (key == null || setter != null || key.equals("javax.jdo.PersistenceManagerFactoryClass")) continue;
            JPOXLogger.JDO.warn(LOCALISER.msg("PMF.UnknownProperty", key));
        }
    }

    protected Map getOptions() {
        return this.options;
    }

    protected static interface ObjectPropertySetter {
        public void set(PMFConfiguration var1, Object var2);
    }

    protected static interface StringPropertySetter {
        public void set(PMFConfiguration var1, String var2);
    }
}

