/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.SoftValueMap;
import org.jpox.util.WeakValueMap;

public class JDOClassLoaderResolver
implements ClassLoaderResolver {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected final ClassLoader pmContextLoader;
    protected int pmContextLoaderHashCode = 0;
    protected ClassLoader registeredLoader;
    protected int registeredLoaderHashCode = 0;
    protected Map loadedClasses = new WeakValueMap();
    protected Map unloadedClasses = new WeakValueMap();
    protected Map resources = new SoftValueMap();
    ThreadLocal primary = new ThreadLocal();
    static /* synthetic */ Class class$java$lang$String;

    public JDOClassLoaderResolver(ClassLoader pmLoader) {
        this.pmContextLoader = pmLoader;
        if (this.pmContextLoader != null) {
            this.pmContextLoaderHashCode = this.pmContextLoader.hashCode();
        }
    }

    public JDOClassLoaderResolver() {
        this.pmContextLoader = null;
    }

    public Class classForName(String name, ClassLoader primary) {
        if (name == null) {
            String msg = LOCALISER.msg("ClassLoader.ClassNotFound", name);
            throw new ClassNotResolvedException(msg);
        }
        if (name.equals(ClassNameConstants.BYTE)) {
            return Byte.TYPE;
        }
        if (name.equals(ClassNameConstants.CHAR)) {
            return Character.TYPE;
        }
        if (name.equals(ClassNameConstants.INT)) {
            return Integer.TYPE;
        }
        if (name.equals(ClassNameConstants.LONG)) {
            return Long.TYPE;
        }
        if (name.equals(ClassNameConstants.DOUBLE)) {
            return Double.TYPE;
        }
        if (name.equals(ClassNameConstants.FLOAT)) {
            return Float.TYPE;
        }
        if (name.equals(ClassNameConstants.SHORT)) {
            return Short.TYPE;
        }
        if (name.equals(ClassNameConstants.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (name.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return class$java$lang$String == null ? (class$java$lang$String = JDOClassLoaderResolver.class$("java.lang.String")) : class$java$lang$String;
        }
        String cacheKey = this.newCacheKey(name, primary);
        Class cls = (Class)this.loadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        cls = (Class)this.unloadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        if (cls == null) {
            cls = this.classOrNull(name, primary);
        }
        if (cls == null && this.primary.get() != null) {
            cls = this.classOrNull(name, (ClassLoader)this.primary.get());
        }
        if (cls == null) {
            cls = this.classOrNull(name, Thread.currentThread().getContextClassLoader());
        }
        if (cls == null) {
            cls = this.classOrNull(name, this.pmContextLoader);
        }
        if (cls == null && this.registeredLoader != null) {
            cls = this.classOrNull(name, this.registeredLoader);
        }
        if (cls == null) {
            String msg = LOCALISER.msg("ClassLoader.ClassNotFound", name);
            throw new ClassNotResolvedException(msg);
        }
        this.unloadedClasses.put(cacheKey, cls);
        return cls;
    }

    private Class classForNameWithInitialize(String name, ClassLoader primary) {
        if (name == null) {
            String msg = LOCALISER.msg("ClassLoader.ClassNotFound", name);
            throw new ClassNotResolvedException(msg);
        }
        if (name.equals(ClassNameConstants.BYTE)) {
            return Byte.TYPE;
        }
        if (name.equals(ClassNameConstants.CHAR)) {
            return Character.TYPE;
        }
        if (name.equals(ClassNameConstants.INT)) {
            return Integer.TYPE;
        }
        if (name.equals(ClassNameConstants.LONG)) {
            return Long.TYPE;
        }
        if (name.equals(ClassNameConstants.DOUBLE)) {
            return Double.TYPE;
        }
        if (name.equals(ClassNameConstants.FLOAT)) {
            return Float.TYPE;
        }
        if (name.equals(ClassNameConstants.SHORT)) {
            return Short.TYPE;
        }
        if (name.equals(ClassNameConstants.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (name.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return class$java$lang$String == null ? (class$java$lang$String = JDOClassLoaderResolver.class$("java.lang.String")) : class$java$lang$String;
        }
        String cacheKey = this.newCacheKey(name, primary);
        Class cls = (Class)this.loadedClasses.get(cacheKey);
        if (cls != null) {
            return cls;
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, primary);
        }
        if (cls == null && this.primary.get() != null) {
            cls = this.ClassOrNullWithInitialize(name, (ClassLoader)this.primary.get());
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, Thread.currentThread().getContextClassLoader());
        }
        if (cls == null) {
            cls = this.ClassOrNullWithInitialize(name, this.pmContextLoader);
        }
        if (cls == null && this.registeredLoader != null) {
            cls = this.ClassOrNullWithInitialize(name, this.registeredLoader);
        }
        if (cls == null) {
            String msg = LOCALISER.msg("ClassLoader.ClassNotFound", name);
            throw new ClassNotResolvedException(msg);
        }
        this.loadedClasses.put(cacheKey, cls);
        return cls;
    }

    private String newCacheKey(String prefix, ClassLoader primary) {
        int h = 3;
        if (primary != null) {
            h ^= primary.hashCode();
        }
        h ^= Thread.currentThread().getContextClassLoader().hashCode();
        h ^= this.pmContextLoaderHashCode;
        return prefix + (h ^= this.registeredLoaderHashCode);
    }

    public Class classForName(String name, ClassLoader primary, boolean initialize) {
        if (initialize) {
            return this.classForNameWithInitialize(name, primary);
        }
        return this.classForName(name, primary);
    }

    public Class classForName(String name) {
        return this.classForName(name, null);
    }

    public Class classForName(String name, boolean initialize) {
        return this.classForName(name, null, initialize);
    }

    public boolean isAssignableFrom(String class_name_1, String class_name_2) {
        if (class_name_1 == null || class_name_2 == null) {
            return false;
        }
        if (class_name_1.equals(class_name_2)) {
            return true;
        }
        Class class_1 = this.classForName(class_name_1);
        Class class_2 = this.classForName(class_name_2);
        return class_1.isAssignableFrom(class_2);
    }

    public boolean isAssignableFrom(String class_name_1, Class class_2) {
        if (class_name_1 == null || class_2 == null) {
            return false;
        }
        if (class_name_1.equals(class_2.getName())) {
            return true;
        }
        try {
            Class<?> class_1 = null;
            class_1 = class_2.getClassLoader() != null ? class_2.getClassLoader().loadClass(class_name_1) : Class.forName(class_name_1);
            return class_1.isAssignableFrom(class_2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAssignableFrom(Class class_1, String class_name_2) {
        if (class_1 == null || class_name_2 == null) {
            return false;
        }
        if (class_1.getName().equals(class_name_2)) {
            return true;
        }
        try {
            Class<?> class_2 = null;
            class_2 = class_1.getClassLoader() != null ? class_1.getClassLoader().loadClass(class_name_2) : Class.forName(class_name_2);
            return class_1.isAssignableFrom(class_2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Class classOrNull(String name, ClassLoader loader) {
        Throwable thr = null;
        try {
            return loader == null ? null : loader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            thr = cnfe;
        }
        catch (NoClassDefFoundError ncdfe) {
            thr = ncdfe;
        }
        if (thr != null && JPOXLogger.CLASSLOADING.isDebugEnabled()) {
            if (JavaUtils.isJRE1_4OrAbove()) {
                StackTraceElement[] traceElements = thr.getStackTrace();
                StackTraceElement element = null;
                int i = 0;
                boolean processingClassLoaderResolverCalls = false;
                while (element == null) {
                    if (processingClassLoaderResolverCalls && traceElements[i].getClassName().indexOf(this.getClass().getName()) < 0) {
                        element = traceElements[i];
                    } else if (traceElements[i].getClassName().startsWith("org.jpox")) {
                        processingClassLoaderResolverCalls = true;
                    }
                    ++i;
                }
                JPOXLogger.CLASSLOADING.debug(LOCALISER.msg("ClassLoaderResolver.ClassNotFound", name, element.getClassName() + "." + element.getMethodName(), "" + element.getLineNumber()));
            } else {
                JPOXLogger.CLASSLOADING.debug(LOCALISER.msg("ClassLoaderResolver.ClassNotFoundSimple", name));
            }
        }
        return null;
    }

    private Class ClassOrNullWithInitialize(String name, ClassLoader loader) {
        try {
            return loader == null ? null : Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    public void registerClassLoader(ClassLoader loader) {
        this.registeredLoader = loader;
        this.registeredLoaderHashCode = loader.hashCode();
    }

    public Enumeration getResources(String resourceName, ClassLoader primary) throws IOException {
        Enumeration<URL> primaryResourceEnum;
        ArrayList<URL> list = new ArrayList<URL>();
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (primary != null) {
            primaryResourceEnum = primary.getResources(resourceName);
            while (primaryResourceEnum.hasMoreElements()) {
                list.add(primaryResourceEnum.nextElement());
            }
        }
        if (this.primary.get() != null) {
            primaryResourceEnum = ((ClassLoader)this.primary.get()).getResources(resourceName);
            while (primaryResourceEnum.hasMoreElements()) {
                list.add(primaryResourceEnum.nextElement());
            }
        }
        Enumeration<URL> resourceEnum = Thread.currentThread().getContextClassLoader().getResources(resourceName);
        while (resourceEnum.hasMoreElements()) {
            list.add(resourceEnum.nextElement());
        }
        if (this.pmContextLoader != null) {
            Enumeration<URL> pmResourceEnum = this.pmContextLoader.getResources(resourceName);
            while (pmResourceEnum.hasMoreElements()) {
                list.add(pmResourceEnum.nextElement());
            }
        }
        if (this.registeredLoader != null) {
            Enumeration<URL> loaderResourceEnum = this.registeredLoader.getResources(resourceName);
            while (loaderResourceEnum.hasMoreElements()) {
                list.add(loaderResourceEnum.nextElement());
            }
        }
        return Collections.enumeration(list);
    }

    public URL getResource(String resourceName, ClassLoader primary) {
        URL url = null;
        url = (URL)this.resources.get(resourceName);
        if (url != null) {
            return url;
        }
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (primary != null && (url = primary.getResource(resourceName)) != null) {
            this.resources.put(resourceName, url);
            return url;
        }
        if (this.primary.get() != null && (url = ((ClassLoader)this.primary.get()).getResource(resourceName)) != null) {
            this.resources.put(resourceName, url);
            return url;
        }
        url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url != null) {
            this.resources.put(resourceName, url);
            return url;
        }
        if (this.pmContextLoader != null) {
            url = this.pmContextLoader.getResource(resourceName);
        }
        if (url != null) {
            this.resources.put(resourceName, url);
            return url;
        }
        if (this.registeredLoader != null) {
            url = this.registeredLoader.getResource(resourceName);
        }
        if (url != null) {
            this.resources.put(resourceName, url);
        }
        return url;
    }

    public void setPrimary(ClassLoader primary) {
        this.primary.set(primary);
    }

    public void unsetPrimary() {
        this.primary.set(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

