/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.FetchPlan;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.util.Localiser;

public class FetchPlanImpl
implements FetchPlan,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    public static final String NONE = "none";
    final Set groups = new HashSet();
    int fetchSize = 0;
    int detachmentOptions = 1;
    final transient Map managedClass = new HashMap();
    int maxFetchDepth = 1;
    Class[] detachmentRootClasses = null;
    Collection detachmentRoots = null;

    public FetchPlanImpl() {
        this.groups.add("default");
    }

    public FetchPlanForClass manageFetchPlanForClass(AbstractClassMetaData cmd) {
        FetchPlanForClass fetchPlanForClass = (FetchPlanForClass)this.managedClass.get(cmd);
        if (fetchPlanForClass == null) {
            fetchPlanForClass = new FetchPlanForClass(cmd, this);
            this.managedClass.put(cmd, fetchPlanForClass);
        }
        return fetchPlanForClass;
    }

    private void markDirty() {
        Iterator it = this.managedClass.values().iterator();
        while (it.hasNext()) {
            ((FetchPlanForClass)it.next()).markDirty();
        }
    }

    public synchronized FetchPlanForClass getFetchPlanForClass(AbstractClassMetaData cmd) {
        return (FetchPlanForClass)this.managedClass.get(cmd);
    }

    public synchronized FetchPlan addGroup(String fetchGroupName) {
        if (fetchGroupName != null && this.groups.add(fetchGroupName)) {
            this.markDirty();
        }
        return this;
    }

    public synchronized FetchPlan removeGroup(String fetchGroupName) {
        if (this.groups.remove(fetchGroupName)) {
            this.markDirty();
        }
        return this;
    }

    public synchronized FetchPlan clearGroups() {
        this.groups.clear();
        this.markDirty();
        return this;
    }

    public synchronized Set getGroups() {
        return Collections.unmodifiableSet(new HashSet(this.groups));
    }

    public synchronized FetchPlan setGroups(Collection fetchGroupNames) {
        if (fetchGroupNames == null) {
            return this;
        }
        HashSet g = new HashSet(fetchGroupNames);
        this.groups.clear();
        this.groups.addAll(g);
        this.markDirty();
        return this;
    }

    public synchronized FetchPlan setGroups(String[] fetchGroupNames) {
        this.groups.clear();
        if (fetchGroupNames != null && fetchGroupNames.length > 0) {
            for (int i = 0; i < fetchGroupNames.length; ++i) {
                this.groups.add(fetchGroupNames[i]);
            }
        }
        this.markDirty();
        return this;
    }

    public synchronized FetchPlan setGroup(String fetchGroupName) {
        this.groups.clear();
        if (fetchGroupName != null) {
            this.groups.add(fetchGroupName);
        }
        this.markDirty();
        return this;
    }

    public FetchPlan setDetachmentRoots(Collection roots) {
        if (this.detachmentRootClasses != null || this.detachmentRoots != null) {
            throw new JDOUserException(LOCALISER.msg("FetchPlan.DetachmentRootsNotChangeableBeforeCommit"));
        }
        if (roots == null) {
            this.detachmentRoots = null;
        }
        this.detachmentRoots = new ArrayList();
        this.detachmentRoots.addAll(roots);
        return this;
    }

    public Collection getDetachmentRoots() {
        if (this.detachmentRoots == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.detachmentRoots);
    }

    public FetchPlan setDetachmentRootClasses(Class[] rootClasses) {
        if (this.detachmentRootClasses != null || this.detachmentRoots != null) {
            throw new JDOUserException(LOCALISER.msg("FetchPlan.DetachmentRootsNotChangeableBeforeCommit"));
        }
        if (rootClasses == null) {
            this.detachmentRootClasses = null;
            return this;
        }
        this.detachmentRootClasses = new Class[rootClasses.length];
        for (int i = 0; i < rootClasses.length; ++i) {
            this.detachmentRootClasses[i] = rootClasses[i];
        }
        return this;
    }

    public Class[] getDetachmentRootClasses() {
        if (this.detachmentRootClasses == null) {
            return new Class[0];
        }
        return this.detachmentRootClasses;
    }

    void resetDetachmentRoots() {
        this.detachmentRootClasses = null;
        this.detachmentRoots = null;
    }

    public synchronized FetchPlan setMaxFetchDepth(int max) {
        if (max == 0) {
            throw new JDOUserException(LOCALISER.msg("FetchPlan.MaxFetchDepthInvalid", max));
        }
        this.maxFetchDepth = max;
        return this;
    }

    public synchronized int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public synchronized FetchPlan setFetchSize(int fetchSize) {
        if (fetchSize != -1 && fetchSize != 0 && fetchSize < 0) {
            return this;
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public synchronized int getFetchSize() {
        return this.fetchSize;
    }

    public int getDetachmentOptions() {
        return this.detachmentOptions;
    }

    public FetchPlan setDetachmentOptions(int options) {
        this.detachmentOptions = options;
        return this;
    }

    public String toString() {
        return this.groups.toString();
    }

    public synchronized FetchPlan getCopy() {
        FetchPlanImpl fp = new FetchPlanImpl();
        fp.maxFetchDepth = this.maxFetchDepth;
        fp.groups.remove("default");
        fp.groups.addAll(this.groups);
        Iterator it = this.managedClass.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            AbstractClassMetaData cmd = (AbstractClassMetaData)entry.getKey();
            FetchPlanForClass fpcls = (FetchPlanForClass)entry.getValue();
            fp.managedClass.put(cmd, fpcls.getCopy(fp));
        }
        fp.fetchSize = this.fetchSize;
        return fp;
    }

    public class FetchPlanForClass {
        final FetchPlanImpl plan;
        final AbstractClassMetaData cmd;
        int[] fieldsInActualFetchPlan;
        boolean dirty = true;
        Map fetchGroupsByFieldNumber = new HashMap();

        public FetchPlanForClass(AbstractClassMetaData cmd, FetchPlanImpl fetchPlan) {
            this.cmd = cmd;
            this.plan = fetchPlan;
        }

        public final FetchPlan getFetchPlan() {
            return this.plan;
        }

        public final AbstractClassMetaData getAbstractClassMetaData() {
            return this.cmd;
        }

        void markDirty() {
            this.dirty = true;
        }

        FetchPlanForClass getCopy(FetchPlanImpl impl) {
            FetchPlanForClass fp = new FetchPlanForClass(this.cmd, impl);
            if (this.fieldsInActualFetchPlan != null) {
                fp.fieldsInActualFetchPlan = new int[this.fieldsInActualFetchPlan.length];
                for (int i = 0; i < fp.fieldsInActualFetchPlan.length; ++i) {
                    fp.fieldsInActualFetchPlan[i] = this.fieldsInActualFetchPlan[i];
                }
            }
            fp.dirty = this.dirty;
            return fp;
        }

        public int[] getFieldsInActualFetchPlan() {
            if (this.dirty) {
                this.dirty = false;
                BitSet fieldsNumber = this.getFieldsInActualFetchPlanByBitSet();
                int countFieldsInFP = 0;
                for (int i = 0; i < fieldsNumber.length(); ++i) {
                    if (!fieldsNumber.get(i)) continue;
                    ++countFieldsInFP;
                }
                this.fieldsInActualFetchPlan = new int[countFieldsInFP];
                int nextField = 0;
                for (int i = 0; i < fieldsNumber.length(); ++i) {
                    if (!fieldsNumber.get(i)) continue;
                    this.fieldsInActualFetchPlan[nextField++] = i;
                }
            }
            return this.fieldsInActualFetchPlan;
        }

        public int getMaxRecursionDepthForFieldInCurrentFetchPlan(int fieldNumber) {
            HashSet currentGroupNames = new HashSet(this.plan.getGroups());
            FetchGroupMetaData[] fgmds = this.cmd.getFetchGroupMetaData(currentGroupNames);
            Set fetchGroupsContainingField = this.getFetchGroupsForFieldAbsoluteNumber(fgmds, fieldNumber);
            int recursionDepth = this.cmd.getManagedFieldAbsolute(fieldNumber).getRecursionDepth();
            if (recursionDepth == 0) {
                recursionDepth = 1;
            }
            String fieldName = this.cmd.getManagedFieldAbsolute(fieldNumber).getName();
            Iterator iter = fetchGroupsContainingField.iterator();
            while (iter.hasNext()) {
                FetchGroupMetaData fgmd = (FetchGroupMetaData)iter.next();
                AbstractPropertyMetaData[] fmds = fgmd.getFieldMetaData();
                for (int i = 0; i < fmds.length; ++i) {
                    AbstractPropertyMetaData fmd = fmds[i];
                    if (!fmd.getName().equals(fieldName) || fmd.getRecursionDepth() == 0) continue;
                    recursionDepth = fmd.getRecursionDepth();
                }
            }
            return recursionDepth;
        }

        public BitSet getFieldsInActualFetchPlanByBitSet() {
            return this.getFieldsInActualFetchPlanByBitSet(this.cmd);
        }

        private BitSet getFieldsInActualFetchPlanByBitSet(AbstractClassMetaData cmd) {
            BitSet bitSet = this.plan.getFetchPlanForClass(cmd).getFieldsAbsoluteNumber(cmd.getFetchGroupMetaData());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                this.plan.manageFetchPlanForClass(cmd.getSuperAbstractClassMetaData());
                bitSet.or(this.plan.getFetchPlanForClass(cmd.getSuperAbstractClassMetaData()).getFieldsInActualFetchPlanByBitSet(cmd.getSuperAbstractClassMetaData()));
            } else {
                this.setNoneFieldNumbers(bitSet);
            }
            return bitSet;
        }

        private BitSet getFieldsAbsoluteNumber(FetchGroupMetaData[] fgmds) {
            BitSet fieldsNumber = new BitSet(0);
            if (fgmds != null) {
                for (int i = 0; i < fgmds.length; ++i) {
                    if (!this.plan.groups.contains(fgmds[i].getName())) continue;
                    fieldsNumber.or(this.getFieldsAbsoluteNumberInFetchGroup(fgmds[i]));
                }
            }
            if (this.plan.groups.contains("default")) {
                this.setDefaultFieldNumbers(fieldsNumber);
            }
            if (this.plan.groups.contains("all")) {
                this.setAllFieldNumbers(fieldsNumber);
            }
            if (this.plan.groups.contains(FetchPlanImpl.NONE)) {
                this.setNoneFieldNumbers(fieldsNumber);
            }
            return fieldsNumber;
        }

        private void setDefaultFieldNumbers(BitSet fieldsNumber) {
            for (int i = 0; i < this.cmd.getDefaultFetchGroupFieldNumbers().length; ++i) {
                fieldsNumber.set(this.cmd.getDefaultFetchGroupFieldNumbers()[i]);
            }
        }

        private void setAllFieldNumbers(BitSet fieldsNumber) {
            for (int i = 0; i < this.cmd.getNoOfManagedFields(); ++i) {
                if (this.cmd.getManagedField(i).getPersistenceModifier() == FieldPersistenceModifier.NONE) continue;
                fieldsNumber.set(this.cmd.getAbsoluteFieldNumberForRelativeFieldNumber(i));
            }
        }

        private void setNoneFieldNumbers(BitSet fieldsNumber) {
            for (int i = 0; i < this.cmd.getNoOfManagedFields(); ++i) {
                AbstractPropertyMetaData fmd = this.cmd.getField(i);
                if (!fmd.isPrimaryKey()) continue;
                fieldsNumber.set(fmd.getAbsoluteFieldNumber());
            }
        }

        private BitSet getFieldsAbsoluteNumberInFetchGroup(FetchGroupMetaData fgmd) {
            int i;
            BitSet fieldsNumber = new BitSet(0);
            for (i = 0; i < fgmd.getFieldMetaData().length; ++i) {
                int fieldNumber = this.getFieldNumber(this.cmd, fgmd.getFieldMetaData()[i].getName());
                if (fieldNumber == -1) {
                    throw new JDOFatalUserException(LOCALISER.msg("FetchPlan.FetchGroupFieldNotFound", fgmd.getFieldMetaData()[i].getName(), fgmd.getName(), this.cmd.getFullClassName()));
                }
                fieldsNumber.set(fieldNumber);
            }
            for (i = 0; i < fgmd.getFetchGroupMetaData().length; ++i) {
                String nestedGroupName = fgmd.getFetchGroupMetaData()[i].getName();
                if (nestedGroupName.equals("default")) {
                    this.setDefaultFieldNumbers(fieldsNumber);
                    continue;
                }
                if (nestedGroupName.equals("all")) {
                    this.setAllFieldNumbers(fieldsNumber);
                    continue;
                }
                if (nestedGroupName.equals(FetchPlanImpl.NONE)) {
                    this.setNoneFieldNumbers(fieldsNumber);
                    continue;
                }
                FetchGroupMetaData nestedFGMD = this.getFetchGroupMetaData(this.cmd, nestedGroupName);
                if (nestedFGMD == null) {
                    throw new JDOFatalUserException(LOCALISER.msg("FetchPlan.NestedFetchGroupNotFound", fgmd.getFetchGroupMetaData()[i].getName(), fgmd.getName(), this.cmd.getFullClassName()));
                }
                fieldsNumber.or(this.getFieldsAbsoluteNumberInFetchGroup(nestedFGMD));
            }
            return fieldsNumber;
        }

        private FetchGroupMetaData getFetchGroupMetaData(AbstractClassMetaData cmd, String fetchGroupName) {
            FetchGroupMetaData nestedFGMD = null;
            nestedFGMD = cmd.getFetchGroupMetaData(fetchGroupName);
            return nestedFGMD;
        }

        private int getFieldNumber(AbstractClassMetaData cmd, String fieldName) {
            int fieldNumber = cmd.getFieldNumberAbsolute(fieldName);
            if (fieldNumber == -1 && cmd.getPersistenceCapableSuperclass() != null) {
                fieldNumber = this.getFieldNumber(cmd.getSuperAbstractClassMetaData(), fieldName);
            }
            return fieldNumber;
        }

        private Set getFetchGroupsForFieldAbsoluteNumber(FetchGroupMetaData[] fgmds, int absoluteFieldNumber) {
            HashSet<FetchGroupMetaData> fetchGroups = new HashSet<FetchGroupMetaData>();
            if (fgmds != null) {
                for (int i = 0; i < fgmds.length; ++i) {
                    int j;
                    for (j = 0; j < fgmds[i].getFieldMetaData().length; ++j) {
                        if (!fgmds[i].getFieldMetaData()[j].getName().equals(this.cmd.getManagedFieldAbsolute(absoluteFieldNumber).getName())) continue;
                        fetchGroups.add(fgmds[i]);
                    }
                    for (j = 0; j < fgmds[i].getFetchGroupMetaData().length; ++j) {
                        fetchGroups.addAll(this.getFetchGroupsForFieldAbsoluteNumber(fgmds[i].getFetchGroupMetaData(), absoluteFieldNumber));
                    }
                }
            }
            return fetchGroups;
        }

        public boolean isToCallPostLoadFetchPlan(boolean[] loadedFields) {
            int[] fieldsInActualFetchPlan = this.getFieldsInActualFetchPlan();
            for (int i = 0; i < fieldsInActualFetchPlan.length; ++i) {
                int fieldNumber = fieldsInActualFetchPlan[i];
                if (loadedFields[fieldNumber]) continue;
                if (this.cmd.getManagedFieldAbsolute(fieldNumber).isDefaultFetchGroup() && FetchPlanImpl.this.groups.contains("default")) {
                    return true;
                }
                Integer fieldNumberInteger = new Integer(fieldNumber);
                Set fetchGroups = (Set)this.fetchGroupsByFieldNumber.get(fieldNumberInteger);
                if (fetchGroups == null) {
                    fetchGroups = this.getFetchGroupsForFieldAbsoluteNumber(this.cmd.getFetchGroupMetaData(), fieldNumber);
                    this.fetchGroupsByFieldNumber.put(fieldNumberInteger, fetchGroups);
                }
                Iterator it = fetchGroups.iterator();
                while (it.hasNext()) {
                    FetchGroupMetaData fgmd = (FetchGroupMetaData)it.next();
                    if (!fgmd.getPostLoad().booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

