/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.JDOPermission;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jpox.AbstractPersistenceManager;
import org.jpox.ImplementationCreator;
import org.jpox.LifecycleListenerForClass;
import org.jpox.PMFConfiguration;
import org.jpox.PMFContext;
import org.jpox.PersistenceManager;
import org.jpox.cache.Level2Cache;
import org.jpox.cache.NullLevel2Cache;
import org.jpox.datasource.DriverManagerDataSource;
import org.jpox.exceptions.ConnectionFactoryNotFoundException;
import org.jpox.exceptions.UnsupportedConnectionFactoryException;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public abstract class AbstractPersistenceManagerFactory
extends PMFConfiguration {
    private static final String VERSION_NUMBER_PROPERTY = "VersionNumber";
    private static final String VENDOR_NAME_PROPERTY = "VendorName";
    private static final String VENDOR_NAME = "JPOX";
    private static String jpoxVersion = null;
    private static String jpoxVendor = null;
    private transient DataSource[] tds = null;
    private transient DataSource[] ntds = null;
    private Set pmCache = new HashSet();
    protected PMFContext pmfContext = new PMFContext(this);
    protected Level2Cache cache;
    protected List lifecycleListeners;
    private boolean closed;
    private Map sequenceByFactoryClass;
    private static final String[] OPTION_ARRAY = new String[]{"javax.jdo.option.TransientTransactional", "javax.jdo.option.NontransactionalRead", "javax.jdo.option.RetainValues", "javax.jdo.option.Optimistic", "javax.jdo.option.ApplicationIdentity", "javax.jdo.option.DatastoreIdentity", "javax.jdo.option.ArrayList", "javax.jdo.option.LinkedList", "javax.jdo.option.TreeSet", "javax.jdo.option.TreeMap", "javax.jdo.option.Vector", "javax.jdo.option.List", "javax.jdo.option.Stack", "javax.jdo.option.Map", "javax.jdo.option.HashMap", "javax.jdo.option.Hashtable", "javax.jdo.option.SortedSet", "javax.jdo.option.SortedMap", "javax.jdo.option.Array", "javax.jdo.option.NullCollection", "javax.jdo.option.BinaryCompatibility", "javax.jdo.option.GetDataStoreConnection", "javax.jdo.option.GetJDBCConnection", "javax.jdo.query.SQL", "javax.jdo.option.UnconstrainedQueryVariables", "javax.jdo.option.version.DateTime", "javax.jdo.option.PreDirtyEvent", "javax.jdo.option.mapping.HeterogeneousObjectType", "javax.jdo.option.mapping.HeterogeneousInterfaceType", "javax.jdo.option.mapping.JoinedTablePerClass", "javax.jdo.option.mapping.JoinedTablePerConcreteClass", "javax.jdo.option.mapping.NonJoinedTablePerConcreteClass", "javax.jdo.query.JDOQL", "javax.jdo.query.JPOXSQL"};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jpox$ClassLoaderResolver;
    static /* synthetic */ Class class$java$util$Properties;

    public AbstractPersistenceManagerFactory() {
        if (!ClassUtils.hasJDO2JarInClasspath()) {
            throw new JDOFatalUserException(LOCALISER.msg("PMF.JDO2Inaccessible"));
        }
    }

    public ImplementationCreator getImplementationCreator() {
        return this.getPMFContext().getImplementationCreator();
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOUserException(LOCALISER.msg("PMF.PMFIsClosed"));
        }
    }

    private DataSource lookupDataSource(String name) {
        Object obj;
        try {
            obj = new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw new ConnectionFactoryNotFoundException(name, e);
        }
        if (!(obj instanceof DataSource)) {
            throw new UnsupportedConnectionFactoryException(obj);
        }
        return (DataSource)obj;
    }

    protected void freezeConfiguration() {
        if (this.configurable) {
            int i;
            if (this.getConnectionFactory() != null) {
                if (!(this.getConnectionFactory() instanceof DataSource)) {
                    throw new UnsupportedConnectionFactoryException(this.getConnectionFactory());
                }
                this.tds = new DataSource[1];
                this.tds[0] = (DataSource)this.getConnectionFactory();
            } else if (this.getConnectionFactoryName() != null) {
                String[] connectionFactoryNames = StringUtils.split(this.getConnectionFactoryName(), ",");
                this.tds = new DataSource[connectionFactoryNames.length];
                for (i = 0; i < connectionFactoryNames.length; ++i) {
                    this.tds[i] = this.lookupDataSource(connectionFactoryNames[i]);
                }
            } else {
                this.tds = new DataSource[1];
                String poolingType = this.getConnectionPoolingType();
                if (poolingType != null && !poolingType.equalsIgnoreCase("None")) {
                    try {
                        Object dataSourceFactory = this.pmfContext.getPluginManager().createExecutableExtension("org.jpox.datasource", "name", poolingType, "class-name", null, null);
                        if (dataSourceFactory == null) {
                            throw new JDOFatalUserException(LOCALISER.msg("DataSource.ConnectionPoolPluginNotFound", poolingType));
                        }
                        Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManagerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManagerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManagerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManagerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AbstractPersistenceManagerFactory.class$("java.lang.String")) : class$java$lang$String, class$org$jpox$ClassLoaderResolver == null ? (class$org$jpox$ClassLoaderResolver = AbstractPersistenceManagerFactory.class$("org.jpox.ClassLoaderResolver")) : class$org$jpox$ClassLoaderResolver};
                        Object[] args = new Object[]{this.getConnectionDriverName(), this.getConnectionURL(), this.getConnectionUserName(), this.getConnectionPassword(), this.getConnectionPoolingConfigurationFile(), this.pmfContext.getClassLoaderResolver(null)};
                        Method m = dataSourceFactory.getClass().getMethod("makePooledDataSource", argTypes);
                        this.tds[0] = (DataSource)m.invoke(dataSourceFactory, args);
                        this.setConnectionUserName(null);
                        this.setConnectionPassword(null);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new JDOFatalUserException(LOCALISER.msg("DataSource.ConnectionPoolPluginNotFound", poolingType), (Throwable)cnfe);
                    }
                    catch (Exception e) {
                        if (e instanceof InvocationTargetException) {
                            InvocationTargetException ite = (InvocationTargetException)e;
                            JPOXLogger.JDO.error(ite.getTargetException());
                            throw new JDOFatalInternalException(LOCALISER.msg("DataSource.ConnectionPoolPluginError", poolingType, ite.getTargetException().getMessage()), ite.getTargetException());
                        }
                        JPOXLogger.JDO.error(e);
                        throw new JDOFatalInternalException(LOCALISER.msg("DataSource.ConnectionPoolPluginError", poolingType, e.getMessage()), (Throwable)e);
                    }
                } else {
                    this.tds[0] = new DriverManagerDataSource(this.getConnectionDriverName(), this.getConnectionURL(), this.getPMFContext().getClassLoaderResolver(null));
                }
            }
            if (this.getConnectionFactory2() != null) {
                if (!(this.getConnectionFactory2() instanceof DataSource)) {
                    throw new UnsupportedConnectionFactoryException(this.getConnectionFactory2());
                }
                this.ntds = new DataSource[1];
                this.ntds[0] = (DataSource)this.getConnectionFactory2();
            } else if (this.getConnectionFactory2Name() != null) {
                String[] connectionFactory2Names = StringUtils.split(this.getConnectionFactory2Name(), ",");
                this.ntds = new DataSource[connectionFactory2Names.length];
                for (i = 0; i < connectionFactory2Names.length; ++i) {
                    this.ntds[i] = this.lookupDataSource(connectionFactory2Names[i]);
                }
            } else {
                this.ntds = this.tds;
            }
            this.initialiseLevel2Cache();
            this.configurable = false;
            JPOXLogger.JDO.info(LOCALISER.msg("PMF.Version", AbstractPersistenceManagerFactory.getVendorName(), AbstractPersistenceManagerFactory.getVersionNumber()));
            JPOXLogger.JDO.info(LOCALISER.msg("PMF.Initialised", this.getConnectionURL(), this.getConnectionDriverName(), this.getConnectionUserName()));
            if (JPOXLogger.JDO.isDebugEnabled()) {
                JPOXLogger.JDO.debug("================ PMF Configuration ================");
                JPOXLogger.JDO.debug("JDK : " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
                if (this.getPersistenceUnitName() != null) {
                    JPOXLogger.JDO.debug("Persistence-Unit : " + this.getPersistenceUnitName());
                }
                JPOXLogger.JDO.debug("JDO Standard Options : " + (this.getMultithreaded() ? "multithreaded" : "singlethreaded") + (this.getRetainValues() ? ", retainValues" : "") + (this.getRestoreValues() ? ", restoreValues" : "") + (this.getNontransactionalRead() ? ", nontransactionalRead" : "") + (this.getNontransactionalWrite() ? ", nontransactionalWrite" : "") + (this.getIgnoreCache() ? ", ignoreCache" : ""));
                JPOXLogger.JDO.debug("Persistence Options :" + (this.getPersistenceByReachabilityAtCommit() ? " reachability-at-commit" : "") + (this.getDetachAllOnCommit() ? " detach-all-on-commit" : "") + (this.getDetachOnClose() ? " detach-on-close" : "") + " deletion-policy=" + this.getDeletionPolicy());
                StringBuffer autoCreateOptions = null;
                if (this.getAutoCreateTables() || this.getAutoCreateColumns() || this.getAutoCreateConstraints()) {
                    autoCreateOptions = new StringBuffer();
                    boolean first = true;
                    if (this.getAutoCreateTables()) {
                        if (!first) {
                            autoCreateOptions.append(",");
                        }
                        autoCreateOptions.append("Tables");
                        first = false;
                    }
                    if (this.getAutoCreateColumns()) {
                        if (!first) {
                            autoCreateOptions.append(",");
                        }
                        autoCreateOptions.append("Columns");
                        first = false;
                    }
                    if (this.getAutoCreateConstraints()) {
                        if (!first) {
                            autoCreateOptions.append(",");
                        }
                        autoCreateOptions.append("Constraints");
                        first = false;
                    }
                }
                StringBuffer validateOptions = null;
                if (this.getValidateTables() || this.getValidateColumns() || this.getValidateConstraints()) {
                    validateOptions = new StringBuffer();
                    boolean first = true;
                    if (this.getValidateTables()) {
                        validateOptions.append("Tables");
                        first = false;
                    }
                    if (this.getValidateColumns()) {
                        if (!first) {
                            validateOptions.append(",");
                        }
                        validateOptions.append("Columns");
                        first = false;
                    }
                    if (this.getValidateConstraints()) {
                        if (!first) {
                            validateOptions.append(",");
                        }
                        validateOptions.append("Constraints");
                        boolean bl = false;
                    }
                }
                JPOXLogger.JDO.debug("Datastore : AutoCreate(" + (autoCreateOptions != null ? autoCreateOptions.toString() : "None") + ")" + ", Validate(" + (validateOptions != null ? validateOptions.toString() : "None") + ")" + (this.getReadOnlyDatastore() ? ", READONLY" : "") + (this.getFixedDatastore() ? ", FIXED" : "") + (this.getUseUpdateLock() ? ", useUpdateLock" : "") + (this.getCheckExistTablesOrViews() ? ", CheckTableViewExistence" : "") + ", foreignKeyCreateMode=" + this.getForeignKeyCreateMode());
                JPOXLogger.JDO.debug("Datastore Identifiers : Factory=\"" + this.getIdentifierFactory() + "\"" + (this.getCatalog() != null ? " catalog=" + this.getCatalog() : "") + (this.getSchema() != null ? " schema=" + this.getSchema() : ""));
                JPOXLogger.JDO.debug("MetaData : XML Validation=" + this.getMetaDataValidate() + ", File Suffixes (JDO = " + this.getJdoMetaDataFileExtension() + ", ORM = " + this.getOrmMetaDataFileExtension() + ", JDOQUERY = " + this.getJdoqueryMetaDataFileExtension() + ")" + ", ORM Mapping name=" + (this.getMapping() != null ? this.getMapping() : "(none)"));
                if (this.getDatastoreAdapterClassName() != null) {
                    JPOXLogger.JDO.debug("Datastore Adapter : class " + this.getDatastoreAdapterClassName());
                }
                JPOXLogger.JDO.debug("Datastore Connection Pooling : " + this.getConnectionPoolingType());
                JPOXLogger.JDO.debug("Types Control : stringDefaultLength=" + this.getStringDefaultLength() + ", dateTimezone=" + this.getDateTimezone());
                JPOXLogger.JDO.debug("Initialisation : mechanism=" + this.getAutoStartMechanism() + ", mode=" + this.getAutoStartMechanismMode() + (this.getAutoStartClassNames() != null ? ", classes=" + this.getAutoStartClassNames() : ""));
                JPOXLogger.JDO.debug("Transactions : type=" + this.getTransactionType() + ", mode=" + (this.getOptimistic() ? "optimistic" : "pessimistic") + ", isolation=" + JDBCUtils.getNameForJDBCIsolationLevel(this.getTransactionIsolation()) + "  POID - isolation=" + JDBCUtils.getNameForJDBCIsolationLevel(this.getPoidTransactionIsolationLevel()) + ", connection=" + (this.getPoidTransactionAttribute().equalsIgnoreCase("New") ? "New" : "PM"));
                JPOXLogger.JDO.debug("ClassLoading : " + this.getClassLoaderResolverName());
                JPOXLogger.JDO.debug("Cache : Level1 (" + this.getJdoCacheLevel1Type() + ")" + (this.getJdoCacheLevel2() ? ", Level2 (" + this.getJdoCacheLevel2Type() + ")" : "") + (this.getJdoCacheCollections() ? ", Collections/Maps " : ""));
                JPOXLogger.JDO.debug("Queries : fetchSize=" + this.getQueryFetchSize() + ", fetchDirection=" + this.getQueryFetchDirection() + ", resultSetType=" + this.getQueryResultSetType() + ", resultSetConcurrency=" + this.getQueryResultSetConcurrency());
                JPOXLogger.JDO.debug("===================================================");
            }
        }
    }

    protected void initialiseLevel2Cache() {
        if (this.getJdoCacheLevel2()) {
            String level2Type = this.getJdoCacheLevel2Type();
            String level2ClassName = this.pmfContext.getPluginManager().getAttributeValueForExtension("org.jpox.cache_level2", "name", level2Type, "class-name");
            if (level2ClassName == null) {
                throw new JDOFatalUserException(LOCALISER.msg("Cache.Level2.PluginNotFound", level2Type));
            }
            try {
                Properties cacheProps = new Properties();
                if (this.getJdoCacheLevel2CacheName() != null) {
                    cacheProps.put("CacheName", this.getJdoCacheLevel2CacheName());
                }
                if (this.getJdoCacheLevel2ConfigurationFile() != null) {
                    cacheProps.put("ConfigurationFile", this.getJdoCacheLevel2ConfigurationFile());
                }
                Class<?> level2CacheClass = Class.forName(level2ClassName);
                Class[] ctrArgsClasses = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = AbstractPersistenceManagerFactory.class$("java.util.Properties")) : class$java$util$Properties};
                Object[] ctrArgs = new Object[]{cacheProps};
                Constructor<?> ctr = level2CacheClass.getConstructor(ctrArgsClasses);
                this.cache = (Level2Cache)ctr.newInstance(ctrArgs);
                JPOXLogger.CACHE.info(LOCALISER.msg("Cache.Level2.Initialised", level2ClassName));
            }
            catch (Exception e) {
                throw new JDOFatalUserException(LOCALISER.msg("Cache.Level2.PluginClassNotFound", level2Type, level2ClassName), (Throwable)e);
            }
        } else {
            this.cache = new NullLevel2Cache();
        }
    }

    public synchronized DataSource[] getTransactionalDataSource() {
        this.freezeConfiguration();
        return this.tds;
    }

    public synchronized DataSource[] getNontransactionalDataSource() {
        this.freezeConfiguration();
        return this.ntds;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(VENDOR_NAME_PROPERTY, AbstractPersistenceManagerFactory.getVendorName());
        props.setProperty(VERSION_NUMBER_PROPERTY, AbstractPersistenceManagerFactory.getVersionNumber());
        return props;
    }

    public static String getVersionNumber() {
        if (jpoxVersion != null) {
            return jpoxVersion;
        }
        String version = "Unknown";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.JPOXVersion");
            try {
                version = bundle.getString("jpox.version");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVersion = version;
        return jpoxVersion;
    }

    public static String getVendorName() {
        if (jpoxVendor != null) {
            return jpoxVendor;
        }
        String vendor = VENDOR_NAME;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.JPOXVersion");
            try {
                vendor = bundle.getString("jpox.vendor");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVendor = vendor;
        return jpoxVendor;
    }

    public Collection supportedOptions() {
        return Collections.unmodifiableList(Arrays.asList(OPTION_ARRAY));
    }

    protected Set getPmCache() {
        return this.pmCache;
    }

    public void releasePersistenceManager(PersistenceManager pm) {
        this.getPmCache().remove(pm);
    }

    public synchronized void close() {
        this.assertIsOpen();
        SecurityManager secmgr = System.getSecurityManager();
        if (secmgr != null) {
            secmgr.checkPermission((Permission)JDOPermission.CLOSE_PERSISTENCE_MANAGER_FACTORY);
        }
        Iterator pms = new HashSet(this.getPmCache()).iterator();
        HashSet<JDOUserException> exceptions = new HashSet<JDOUserException>();
        while (pms.hasNext()) {
            try {
                ((AbstractPersistenceManager)pms.next()).close();
            }
            catch (JDOUserException ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PMF.CloseError"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (this.getJdoCacheLevel2() && this.cache != null) {
            this.cache.clear();
            JPOXLogger.CACHE.info(LOCALISER.msg("Cache.Level2.Cleared"));
        }
        if (this.sequenceByFactoryClass != null) {
            this.sequenceByFactoryClass.clear();
        }
        this.pmfContext.close();
        this.pmfContext = null;
        this.ntds = null;
        this.tds = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public PMFContext getPMFContext() {
        return this.pmfContext;
    }

    public PMFConfiguration getPMFConfiguration() {
        return this;
    }

    public DataStoreCache getDataStoreCache() {
        this.freezeConfiguration();
        return this.cache;
    }

    public List getLifecycleListenerSpecifications() {
        return this.lifecycleListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        Set set = this.pmCache;
        synchronized (set) {
            Iterator pms = this.getPmCache().iterator();
            while (pms.hasNext()) {
                AbstractPersistenceManager pm = (AbstractPersistenceManager)pms.next();
                pm.addInstanceLifecycleListener(listener, classes);
            }
        }
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new ArrayList(5);
        }
        this.lifecycleListeners.add(new LifecycleListenerForClass(listener, classes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        if (listener == null || this.lifecycleListeners == null) {
            return;
        }
        Set set = this.pmCache;
        synchronized (set) {
            Iterator pms = this.getPmCache().iterator();
            while (pms.hasNext()) {
                AbstractPersistenceManager pm = (AbstractPersistenceManager)pms.next();
                pm.removeInstanceLifecycleListener(listener);
            }
        }
        Iterator iter = this.lifecycleListeners.iterator();
        while (iter.hasNext()) {
            LifecycleListenerForClass classListener = (LifecycleListenerForClass)iter.next();
            if (classListener.getListener() != listener) continue;
            iter.remove();
        }
    }

    void addSequenceForFactoryClass(String factoryClassName, Sequence sequence) {
        if (this.sequenceByFactoryClass == null) {
            this.sequenceByFactoryClass = new HashMap();
        }
        this.sequenceByFactoryClass.put(factoryClassName, sequence);
    }

    Sequence getSequenceForFactoryClass(String factoryClassName) {
        if (this.sequenceByFactoryClass == null) {
            return null;
        }
        return (Sequence)this.sequenceByFactoryClass.get(factoryClassName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

