/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.contextualizer;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.contextualizer.Contextualizer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class DefaultContextualizer
extends AbstractLogEnabled
implements Contextualizer,
Contextualizable,
Initializable {
    private Map contextValues;
    private boolean addAllSystemProperties;
    private List definedSystemProperties;
    private PlexusContainer plexusContainer;

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    public void initialize() throws InitializationException {
        String value;
        String key;
        if (this.addAllSystemProperties) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("adding all system properties in context");
            }
            Properties systemProperties = System.getProperties();
            Enumeration<Object> keys = systemProperties.keys();
            while (keys.hasMoreElements()) {
                String key2 = (String)keys.nextElement();
                String value2 = systemProperties.getProperty(key2);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("add sysprops " + key2 + " : " + value2);
                }
                this.plexusContainer.getContext().put((Object)key2, (Object)value2);
            }
        }
        if (this.contextValues != null) {
            Iterator keys = this.contextValues.keySet().iterator();
            while (keys.hasNext()) {
                key = (String)keys.next();
                value = (String)this.contextValues.get(key);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("add user value " + key + " : " + value);
                }
                this.plexusContainer.getContext().put((Object)key, (Object)value);
            }
        }
        if (this.definedSystemProperties != null) {
            Iterator iterator = this.definedSystemProperties.iterator();
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                value = System.getProperty(key);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("add sysprops " + key + " : " + value);
                }
                this.plexusContainer.getContext().put((Object)key, (Object)value);
            }
        }
    }

    public Map getContextValues() {
        return this.contextValues;
    }

    public void setContextValues(Map contextValues) {
        this.contextValues = contextValues;
    }

    public boolean isAddAllSystemProperties() {
        return this.addAllSystemProperties;
    }

    public void setAddAllSystemProperties(boolean addAllSystemProperties) {
        this.addAllSystemProperties = addAllSystemProperties;
    }

    public List getDefinedSystemProperties() {
        return this.definedSystemProperties;
    }

    public void setDefinedSystemProperties(List definedSystemProperties) {
        this.definedSystemProperties = definedSystemProperties;
    }
}

