/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.services;

import java.util.Date;
import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.marmotta.commons.sesame.filter.AllOfFilter;
import org.apache.marmotta.commons.sesame.filter.SesameFilter;
import org.apache.marmotta.commons.sesame.filter.statement.StatementFilter;
import org.apache.marmotta.kiwi.transactions.api.TransactionalSail;
import org.apache.marmotta.kiwi.transactions.wrapper.TransactionalSailWrapper;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.kiwi.versioning.repository.SnapshotRepositoryConnection;
import org.apache.marmotta.kiwi.versioning.sail.KiWiVersioningSail;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.api.triplestore.TransactionalSailProvider;
import org.apache.marmotta.platform.core.events.ConfigurationChangedEvent;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;

@ApplicationScoped
public class VersioningSailProvider
implements TransactionalSailProvider {
    public static final String VERSIONING_ENABLED = "versioning.enabled";
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;
    @Inject
    @Named(value="versioning")
    private Instance<StatementFilter> filters;
    private KiWiVersioningSail sail;

    public String getName() {
        return "Versioning";
    }

    public boolean isEnabled() {
        return this.configurationService.getBooleanConfiguration(VERSIONING_ENABLED, true);
    }

    public void configurationChanged(@Observes ConfigurationChangedEvent e) {
        if (e.containsChangedKey(VERSIONING_ENABLED)) {
            this.sesameService.shutdown();
            this.sesameService.initialise();
        }
    }

    public TransactionalSailWrapper createSail(TransactionalSail parent) {
        HashSet<Object> sFilters = new HashSet<Object>();
        StatementFilter filterCached = new StatementFilter(){

            public boolean accept(Statement object) {
                return object.getContext() == null || !VersioningSailProvider.this.configurationService.getCacheContext().equals(object.getContext().stringValue());
            }
        };
        sFilters.add(filterCached);
        StatementFilter filterInferred = new StatementFilter(){

            public boolean accept(Statement object) {
                return object.getContext() == null || !VersioningSailProvider.this.configurationService.getInferredContext().equals(object.getContext().stringValue());
            }
        };
        sFilters.add(filterInferred);
        StatementFilter filterEnhancing = new StatementFilter(){

            public boolean accept(Statement object) {
                return object.getContext() == null || !VersioningSailProvider.this.configurationService.getEnhancerContex().equals(object.getContext().stringValue());
            }
        };
        sFilters.add(filterEnhancing);
        for (StatementFilter f : this.filters) {
            this.log.info("Auto-Registering filter {}", (Object)f.getClass().getSimpleName());
            sFilters.add(f);
        }
        this.sail = new KiWiVersioningSail(parent, (SesameFilter)new AllOfFilter(sFilters));
        return this.sail;
    }

    public SnapshotRepositoryConnection getSnapshot(Date snapshotDate) throws RepositoryException {
        try {
            return new SnapshotRepositoryConnection(this.sesameService.getRepository(), this.sail.getSnapshot(snapshotDate));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Version> listVersions() throws SailException {
        return this.sail.listVersions();
    }

    public RepositoryResult<Version> listVersions(Date from, Date to) throws SailException {
        return this.sail.listVersions(from, to);
    }

    public RepositoryResult<Version> listVersions(Resource r) throws SailException {
        return this.sail.listVersions(r);
    }

    public RepositoryResult<Version> listVersions(Resource r, Date from, Date to) throws SailException {
        return this.sail.listVersions(r, from, to);
    }

    public Version getVersion(Long id) throws SailException {
        return this.sail.getVersion(id);
    }

    public Version getLatestVersion(Resource r, Date date) throws SailException {
        return this.sail.getLatestVersion(r, date);
    }
}

