/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.marmotta.commons.http.ContentType;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.versioning.io.VersionSerializer;
import org.apache.marmotta.platform.versioning.utils.MementoUtils;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

@ApplicationScoped
public class LinkVersionSerializer
implements VersionSerializer {
    @Inject
    ConfigurationService configurationService;
    private static final List<ContentType> contentTypes = new ArrayList(){
        {
            this.add(new ContentType("application", "link-format"));
        }
    };

    @Override
    public ContentType getContentType() {
        return new ContentType("application", "link-format");
    }

    @Override
    public List<ContentType> getContentTypes() {
        return contentTypes;
    }

    @Override
    public void write(Resource original, RepositoryResult<Version> versions, OutputStream out) throws IOException {
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));
            w.append("<");
            w.append(original.toString());
            w.append(">;rel=\"original\",");
            w.newLine();
            boolean first = true;
            while (versions.hasNext()) {
                Version v = (Version)versions.next();
                w.append("<");
                w.append(MementoUtils.resourceURI(original.toString(), v.getCommitTime(), this.configurationService.getBaseUri()).toString());
                w.append(">; rel=\"");
                if (first && versions.hasNext()) {
                    w.append("first memento");
                } else if (!versions.hasNext()) {
                    w.append("last memento");
                } else {
                    w.append("memento");
                }
                w.append("\"; datetime=\"");
                w.append(v.getCommitTime().toString());
                w.append("\",");
                w.newLine();
                first = false;
            }
            w.flush();
            w.close();
        }
        catch (RepositoryException e) {
            throw new IOException("cannot serialize versions in application/link-format");
        }
    }
}

