/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.io;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.marmotta.commons.http.ContentType;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.versioning.io.VersionSerializer;
import org.apache.marmotta.platform.versioning.utils.MementoUtils;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

@ApplicationScoped
public class HtmlVersionSerializer
implements VersionSerializer {
    @Inject
    ConfigurationService configurationService;
    private Configuration configuration;
    private static final String TEMPLATE = "timemap";
    private static final List<ContentType> contentTypes = new ArrayList(){
        {
            this.add(new ContentType("text", "html"));
        }
    };

    @PostConstruct
    private void initialize() {
        this.configuration = new Configuration();
        this.configuration.setClassForTemplateLoading(HtmlVersionSerializer.class, "/template/");
    }

    @Override
    public ContentType getContentType() {
        return new ContentType("text", "html");
    }

    @Override
    public List<ContentType> getContentTypes() {
        return contentTypes;
    }

    @Override
    public void write(Resource original, RepositoryResult<Version> versions, OutputStream out) throws IOException {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("original", original.toString());
            ArrayList vs = new ArrayList();
            while (versions.hasNext()) {
                Version v = (Version)versions.next();
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("date", v.getCommitTime().toString());
                m.put("uri", MementoUtils.resourceURI(original.toString(), v.getCommitTime(), this.configurationService.getBaseUri()).toString());
                vs.add(m);
            }
            data.put("versions", vs);
            String project = this.configurationService.getStringConfiguration("kiwi.pages.project", "lmf");
            data.put("LOGO", this.configurationService.getStringConfiguration("kiwi.pages.project." + project + ".logo", "logo.png"));
            data.put("FOOTER", this.configurationService.getStringConfiguration("kiwi.pages.project." + project + ".footer", "a footer"));
            data.put("SERVER_URL", this.configurationService.getServerUri());
            data.put("baseUri", this.configurationService.getServerUri());
            Template template = this.configuration.getTemplate("timemap.ftl");
            OutputStreamWriter writer = new OutputStreamWriter(out);
            template.process(data, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (RepositoryException e) {
            throw new IOException("cannot serialize versions in text/html format");
        }
        catch (TemplateException e) {
            throw new IOException("cannot finish templating");
        }
    }
}

