/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.tripletable;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.marmotta.commons.sesame.model.StatementCommons;
import org.apache.marmotta.commons.sesame.tripletable.IntArray;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TripleTable<Triple extends Statement>
implements Set<Triple>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Triple> data = StatementCommons.newQuadrupleSet();
    private NavigableMap<IntArray, Triple> indexSPOC = new TreeMap<IntArray, Triple>();
    private NavigableMap<IntArray, Triple> indexCSPO = new TreeMap<IntArray, Triple>();

    public TripleTable() {
    }

    public TripleTable(Collection<Triple> triples) {
        this.addAll((Collection<? extends Triple>)triples);
    }

    @Override
    public synchronized int size() {
        return this.data.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.data.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public synchronized boolean add(Triple triple) {
        this.indexSPOC.put(IntArray.createSPOCKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()), triple);
        this.indexCSPO.put(IntArray.createCSPOKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()), triple);
        return this.data.add(triple);
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (o instanceof Statement) {
            Statement triple = (Statement)o;
            this.indexSPOC.remove(IntArray.createSPOCKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()));
            this.indexCSPO.remove(IntArray.createCSPOKey(triple.getSubject(), triple.getPredicate(), triple.getObject(), triple.getContext()));
        }
        return this.data.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Triple> c) {
        boolean modified = false;
        for (Statement t : c) {
            modified = this.add((Triple)t) || modified;
        }
        return modified;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        Iterator it = this.indexSPOC.entrySet().iterator();
        while (it.hasNext()) {
            if (c.contains(it.next().getValue())) continue;
            it.remove();
        }
        Iterator it2 = this.indexCSPO.entrySet().iterator();
        while (it2.hasNext()) {
            if (c.contains(it2.next().getValue())) continue;
            it2.remove();
        }
        return this.data.retainAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified = this.remove(o) || modified;
        }
        return modified;
    }

    @Override
    public synchronized void clear() {
        this.data.clear();
        this.indexSPOC.clear();
        this.indexCSPO.clear();
    }

    public synchronized Collection<Triple> listTriples(final Resource subject, final URI property, final Value object, final Resource context, boolean wildcardContext) {
        if (subject != null && property != null && object != null && context != null) {
            IntArray key = IntArray.createSPOCKey(subject, property, object, context);
            Statement result = (Statement)this.indexSPOC.get(key);
            if (result != null) {
                return Collections.singleton(result);
            }
            return Collections.emptyList();
        }
        if (wildcardContext && (subject != null && property != null && object != null || subject != null && property != null || subject != null)) {
            IntArray fromKey = IntArray.createSPOCKey(subject, property, object, context);
            IntArray toKey = IntArray.createSPOCMaxKey(subject, property, object, context);
            return this.indexSPOC.subMap(fromKey, true, toKey, true).values();
        }
        if (context != null && subject != null && property != null || context != null && subject != null || context != null) {
            IntArray fromKey = IntArray.createCSPOKey(subject, property, object, context);
            IntArray toKey = IntArray.createCSPOMaxKey(subject, property, object, context);
            return this.indexCSPO.subMap(fromKey, true, toKey, true).values();
        }
        Predicate<Statement> p = new Predicate<Statement>(){

            public boolean apply(Statement triple) {
                if (subject != null && !triple.getSubject().equals(subject)) {
                    return false;
                }
                if (property != null && !triple.getPredicate().equals((Object)property)) {
                    return false;
                }
                if (object != null && !triple.getObject().equals(object)) {
                    return false;
                }
                return context == null || triple.getContext().equals(context);
            }
        };
        return Collections2.filter(this.data, (Predicate)p);
    }

    public synchronized Collection<Resource> listContextIDs() {
        HashSet<Resource> result = new HashSet<Resource>();
        for (Statement t : this.data) {
            result.add(t.getContext());
        }
        return result;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripleTable that = (TripleTable)o;
        return this.data.equals(that.data);
    }

    @Override
    public synchronized int hashCode() {
        return this.data.hashCode();
    }
}

