/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.tripletable;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public final class IntArray
implements Comparable<IntArray>,
Serializable {
    private static HashFunction hashFunction32 = Hashing.goodFastHash((int)32);
    private static HashFunction hashFunction64 = Hashing.goodFastHash((int)64);
    private int[] data;
    private HashCode hashCode32;
    private HashCode hashCode64;

    public IntArray(int[] data) {
        this.data = data;
    }

    private void ensureHashCode() {
        if (this.hashCode32 == null) {
            Hasher hasher = hashFunction32.newHasher();
            for (int i : this.data) {
                hasher.putInt(i);
            }
            this.hashCode32 = hasher.hash();
        }
    }

    private void ensureLongHashCode() {
        if (this.hashCode64 == null) {
            Hasher hasher = hashFunction64.newHasher();
            for (int i : this.data) {
                hasher.putInt(i);
            }
            this.hashCode64 = hasher.hash();
        }
    }

    public static final IntArray createSPOCKey(Resource subject, URI property, Value object, Resource context) {
        int s = subject != null ? subject.hashCode() : Integer.MIN_VALUE;
        int p = property != null ? property.hashCode() : Integer.MIN_VALUE;
        int o = object != null ? IntArray.calcObjectHash(object) : Integer.MIN_VALUE;
        int c = context != null ? context.hashCode() : Integer.MIN_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        bb.put(c);
        return new IntArray(bb.array());
    }

    public static final IntArray createSPOCMaxKey(Resource subject, URI property, Value object, Resource context) {
        int s = subject != null ? subject.hashCode() : Integer.MAX_VALUE;
        int p = property != null ? property.hashCode() : Integer.MAX_VALUE;
        int o = object != null ? IntArray.calcObjectHash(object) : Integer.MAX_VALUE;
        int c = context != null ? context.hashCode() : Integer.MAX_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        bb.put(c);
        return new IntArray(bb.array());
    }

    public static final IntArray createCSPOKey(Resource subject, URI property, Value object, Resource context) {
        int s = subject != null ? subject.hashCode() : Integer.MIN_VALUE;
        int p = property != null ? property.hashCode() : Integer.MIN_VALUE;
        int o = object != null ? IntArray.calcObjectHash(object) : Integer.MIN_VALUE;
        int c = context != null ? context.hashCode() : Integer.MIN_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(c);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        return new IntArray(bb.array());
    }

    public static final IntArray createCSPOMaxKey(Resource subject, URI property, Value object, Resource context) {
        int s = subject != null ? subject.hashCode() : Integer.MAX_VALUE;
        int p = property != null ? property.hashCode() : Integer.MAX_VALUE;
        int o = object != null ? IntArray.calcObjectHash(object) : Integer.MAX_VALUE;
        int c = context != null ? context.hashCode() : Integer.MAX_VALUE;
        IntBuffer bb = IntBuffer.allocate(4);
        bb.put(c);
        bb.put(s);
        bb.put(p);
        bb.put(o);
        return new IntArray(bb.array());
    }

    private static int calcObjectHash(Value value) {
        if (value instanceof Literal) {
            int i = value.stringValue().hashCode();
            i = ((Literal)value).getLanguage() != null ? i * 31 + ((Literal)value).getLanguage().hashCode() : (i *= 31);
            i = ((Literal)value).getDatatype() != null ? i * 31 + ((Literal)value).getDatatype().hashCode() : (i *= 31);
            return i;
        }
        return value.hashCode();
    }

    public String toString() {
        return "IntArray{data=" + Arrays.toString(this.data) + '}';
    }

    @Override
    public int compareTo(IntArray o) {
        for (int i = 0; i < this.data.length && i < o.data.length; ++i) {
            if (this.data[i] < o.data[i]) {
                return -1;
            }
            if (this.data[i] <= o.data[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArray intArray = (IntArray)o;
        return Arrays.equals(this.data, intArray.data);
    }

    public int hashCode() {
        this.ensureHashCode();
        return this.hashCode32.asInt();
    }

    public long longHashCode() {
        this.ensureLongHashCode();
        return this.hashCode64.asLong();
    }
}

