/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.backend.kiwi;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.marmotta.kiwi.config.CacheMode;
import org.apache.marmotta.kiwi.config.CachingBackends;
import org.apache.marmotta.kiwi.config.KiWiConfiguration;
import org.apache.marmotta.kiwi.config.RegistryStrategy;
import org.apache.marmotta.kiwi.exception.DriverNotFoundException;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.h2.H2Dialect;
import org.apache.marmotta.kiwi.persistence.mysql.MySQLDialect;
import org.apache.marmotta.kiwi.persistence.pgsql.PostgreSQLDialect;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.apache.marmotta.kiwi.sparql.sail.KiWiSparqlSail;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.api.triplestore.StoreProvider;
import org.apache.marmotta.platform.core.events.ConfigurationChangedEvent;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.slf4j.Logger;

@ApplicationScoped
public class KiWiStoreProvider
implements StoreProvider {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;

    public NotifyingSail createStore() {
        H2Dialect dialect;
        block8: {
            this.log.info("Initializing Backend: KiWi Store");
            String database = this.configurationService.getStringConfiguration("database.type");
            try {
                if ("h2".equalsIgnoreCase(database)) {
                    dialect = new H2Dialect();
                    break block8;
                }
                if ("mysql".equalsIgnoreCase(database)) {
                    dialect = new MySQLDialect();
                    break block8;
                }
                if ("postgres".equalsIgnoreCase(database)) {
                    dialect = new PostgreSQLDialect();
                    break block8;
                }
                throw new IllegalStateException("database type " + database + " currently not supported!");
            }
            catch (DriverNotFoundException dnf) {
                this.log.error("{}, can't build KiwiStore.", (Object)dnf.getMessage());
                throw dnf;
            }
        }
        String jdbcUrl = this.configurationService.getStringConfiguration("database.url");
        String dbUser = this.configurationService.getStringConfiguration("database.user");
        String dbPass = this.configurationService.getStringConfiguration("database.password");
        KiWiConfiguration configuration = new KiWiConfiguration(this.configurationService.getStringConfiguration("clustering.name", "Marmotta") + " KiWi", jdbcUrl, dbUser, dbPass, (KiWiDialect)dialect, this.configurationService.getDefaultContext(), this.configurationService.getInferredContext());
        configuration.setQueryLoggingEnabled(this.configurationService.getBooleanConfiguration("database.debug.slowqueries", false));
        configuration.setTripleBatchCommit(this.configurationService.getBooleanConfiguration("database.triples.batchcommit", true));
        configuration.setTripleBatchSize(this.configurationService.getIntConfiguration("database.triples.batchsize", 10000));
        configuration.setDatacenterId(this.configurationService.getIntConfiguration("database.datacenter.id", 0));
        configuration.setFulltextEnabled(this.configurationService.getBooleanConfiguration("database.fulltext.enabled", true));
        configuration.setFulltextLanguages(this.configurationService.getListConfiguration("database.fulltext.languages", (List)ImmutableList.of((Object)"en")));
        configuration.setClustered(this.configurationService.getBooleanConfiguration("clustering.enabled", false));
        configuration.setClusterName(this.configurationService.getStringConfiguration("clustering.name", "Marmotta"));
        configuration.setLiteralCacheSize(this.configurationService.getIntConfiguration("caching.literal.size", 100000));
        configuration.setBNodeCacheSize(this.configurationService.getIntConfiguration("caching.bnode.size", 10000));
        configuration.setUriCacheSize(this.configurationService.getIntConfiguration("caching.uri.size", 500000));
        configuration.setTripleCacheSize(this.configurationService.getIntConfiguration("caching.triple.size", 100000));
        configuration.setClusterPort(this.configurationService.getIntConfiguration("clustering.port", 46655));
        configuration.setClusterAddress(this.configurationService.getStringConfiguration("clustering.address", "228.6.7.8"));
        configuration.setCachingBackend(CachingBackends.valueOf((String)this.configurationService.getStringConfiguration("clustering.backend", "GUAVA")));
        configuration.setCacheMode(CacheMode.valueOf((String)this.configurationService.getStringConfiguration("clustering.mode", "LOCAL")));
        if (configuration.isClustered()) {
            configuration.setRegistryStrategy(RegistryStrategy.CACHE);
        } else {
            configuration.setRegistryStrategy(RegistryStrategy.LOCAL);
        }
        KiWiStore base = new KiWiStore(configuration);
        if ("native".equalsIgnoreCase(this.configurationService.getStringConfiguration("sparql.strategy"))) {
            this.log.info(" - enabling native SPARQL support");
            base = new KiWiSparqlSail((NotifyingSail)base);
        }
        return base;
    }

    public SailRepository createRepository(Sail sail) {
        return new SailRepository(sail);
    }

    public String getName() {
        return "KiWi Store";
    }

    public boolean isEnabled() {
        return true;
    }

    public void configurationChanged(@Observes ConfigurationChangedEvent e) {
        this.log.info("configuration changed: {}", (Object)e.getKeys());
        if (e.containsChangedKey("sparql.strategy") || e.containsChangedKey("database.datacenter.id") || e.containsChangedKey("contexts.default") || e.containsChangedKey("contexts.inferred") || e.containsChangedKey("database.fulltext.enabled") || e.containsChangedKey("database.fulltext.languages") || e.containsChangedKey("database.debug.slowqueries") || e.containsChangedKey("clustering.enabled") || e.containsChangedKey("caching.literal.size") || e.containsChangedKey("caching.triple.size") || e.containsChangedKey("caching.uri.size") || e.containsChangedKey("caching.bnode.size") || e.containsChangedKey("caching.query.enabled") || e.containsChangedKey("clustering.backend") || e.containsChangedKey("clustering.address") || e.containsChangedKey("clustering.port") || e.containsChangedKey("clustering.mode")) {
            this.log.info("KiWi backend configuration changed, re-initialising triple store");
            this.sesameService.restart();
        }
    }
}

